/*
 *---------------------------------------------------------------------
 *            Copyright 1990 University of New Mexico
 * 
 * Permission to copy and modify this software and its documen- 
 * tation only for internal use in your organization is hereby 
 * granted, provided that this notice is retained thereon and 
 * on all copies.  UNM makes no representations as too the sui- 
 * tability and operability of this software for any purpose. 
 * It is provided 'as is' without express or implied warranty. 
 *  
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT- 
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL, 
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT- 
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER- 
 * FORMANCE OF THIS SOFTWARE. 
 *  
 * No other rights, including for example, the right to redis- 
 * tribute this software and its documentation or the right to 
 * prepare derivative works, are granted unless specifically 
 * provided in a separate license agreement. 
 * 
 *---------------------------------------------------------------------
 */
#include "unmcopyright.h"
#include "xvforms.h"
#include <strings.h>
#include "form_info.h"


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name:  form_init.c
 >>>>
 >>>>      Program Desc:  code to initialize fields
 >>>>                      in the structure found in form_info.h
 >>>>
 >>>>            Author:  automatically generated by conductor
 >>>>
 >>>> Date Last Updated:  Mon Feb 18 16:13:06 1991
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


_xvf_init_Master(formptr,forminfo)

xvf_form *formptr; 
Master *forminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);
	database = formptr->db;

	/***** initializing 'Master' Form Information structure *****/

	forminfo->master_action = false;
	forminfo->workspace_index = 5;
	forminfo->quit = false;
	forminfo->Subform1 = (Master_Subform1 *) 
			  malloc(sizeof(Master_Subform1));


	index = 10;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->Subform1_selected = line_info.selected;
	forminfo->Subform1_index = 10;
	forminfo->Subform1_sfb_index = 2;

	/*** initializing 'forminfo->Subform1'
	      Subform Information structure ***/

	forminfo->Subform1->operation = false;
	forminfo->Subform1->quit = false;
	forminfo->Subform1->input = (Subform1_input *) 
			  malloc(sizeof(Subform1_input));


	index = 17;

	xvf_parse_startpane_line(database[index], &line_info);
	forminfo->Subform1->input_selected = line_info.selected;
	forminfo->Subform1->input_index = 17;
	forminfo->Subform1->input_gb_index = 12;
	index++;


	/* initializing 'forminfo->Subform1->input'
	       Pane Information structure */

	xvf_parse_input_line(database[index], &line_info);
	if (line_info.file_def != NULL) {
	   forminfo->Subform1->input->infile = 
		xvf_strcpy(line_info.file_def);
	}
	else  forminfo->Subform1->input->infile = NULL;

	xvf_deparse_input_line(&line_info, database, index);
	forminfo->Subform1->input->infile_index = index;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	forminfo->Subform1->input->add_file = line_info.logical_def;
	line_info.logical_val = line_info.logical_def;
	xvf_deparse_logic_line(&line_info, database,index);
	forminfo->Subform1->input->add_file_index = index;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	forminfo->Subform1->input->delete_file = line_info.logical_def;
	line_info.logical_val = line_info.logical_def;
	xvf_deparse_logic_line(&line_info, database,index);
	forminfo->Subform1->input->delete_file_index = index;
	index++;

	forminfo->Subform1->input->get_input = false;
	forminfo->Subform1->input->get_input_index = index;
	index++;

	forminfo->Subform1->output = (Subform1_output *) 
			  malloc(sizeof(Subform1_output));


	index = 23;

	xvf_parse_startpane_line(database[index], &line_info);
	forminfo->Subform1->output_selected = line_info.selected;
	forminfo->Subform1->output_index = 23;
	forminfo->Subform1->output_gb_index = 13;
	index++;


	/* initializing 'forminfo->Subform1->output'
	       Pane Information structure */

	xvf_parse_output_line(database[index], &line_info);
	if (line_info.file_def != NULL) {
	   forminfo->Subform1->output->outfile = 
		xvf_strcpy(line_info.file_def);
	}
	else  forminfo->Subform1->output->outfile = NULL;

	xvf_deparse_output_line(&line_info, database,index);
	forminfo->Subform1->output->outfile_index = index;
forminfo->Subform1->output->outfile_selected = false;
	index++;

	forminfo->Subform1->output->save_output = false;
	forminfo->Subform1->output->save_output_index = index;
	index++;

	forminfo->Subform2 = (Master_Subform2 *) 
			  malloc(sizeof(Master_Subform2));


	index = 28;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->Subform2_selected = line_info.selected;
	forminfo->Subform2_index = 28;
	forminfo->Subform2_sfb_index = 3;

	/*** initializing 'forminfo->Subform2'
	      Subform Information structure ***/

	forminfo->Subform2->transforms = (Subform2_transforms *) 
			  malloc(sizeof(Subform2_transforms));


	index = 29;

	xvf_parse_startpane_line(database[index], &line_info);
	forminfo->Subform2->transforms_selected = line_info.selected;
	forminfo->Subform2->transforms_index = 29;
	forminfo->Subform2->transforms_gb_index = 0;
	index++;


	/* initializing 'forminfo->Subform2->transforms'
	       Pane Information structure */

	xvf_parse_toggle_line(database[index], &line_info);
	forminfo->Subform2->transforms->trans_type_val = line_info.toggle_def;
	line_info.toggle_val = line_info.toggle_def;
	xvf_deparse_toggle_line(&line_info, database,index);
	forminfo->Subform2->transforms->trans_type_index = index;
	index++;

	index = 35;
	xvf_parse_float_line(database[index], &line_info);
	forminfo->Subform2->transforms->x_val = line_info.float_def;
	line_info.float_val = line_info.float_def;
	xvf_deparse_float_line(&line_info, database,index);
	forminfo->Subform2->transforms->x_val_index = index;
	index++;

	xvf_parse_float_line(database[index], &line_info);
	forminfo->Subform2->transforms->y_val = line_info.float_def;
	line_info.float_val = line_info.float_def;
	xvf_deparse_float_line(&line_info, database,index);
	forminfo->Subform2->transforms->y_val_index = index;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	forminfo->Subform2->transforms->int2 = line_info.int_def;
	line_info.int_val = line_info.int_def;
	xvf_deparse_int_line(&line_info, database,index);
	forminfo->Subform2->transforms->int2_index = index;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	forminfo->Subform2->transforms->int1 = line_info.int_def;
	line_info.int_val = line_info.int_def;
	xvf_deparse_int_line(&line_info, database,index);
	forminfo->Subform2->transforms->int1_index = index;
	index++;

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_def != NULL) {
	   forminfo->Subform2->transforms->string1 = 
		xvf_strcpy(line_info.string_def);
	}
	else  forminfo->Subform2->transforms->string1 = NULL;

	xvf_deparse_string_line(&line_info, database,index);
	forminfo->Subform2->transforms->string1_index = index;
forminfo->Subform2->transforms->string1_selected = true;
	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_def != NULL) {
	   forminfo->Subform2->transforms->string2 = 
		xvf_strcpy(line_info.string_def);
	}
	else  forminfo->Subform2->transforms->string2 = NULL;

	xvf_deparse_string_line(&line_info, database,index);
	forminfo->Subform2->transforms->string2_index = index;
forminfo->Subform2->transforms->string2_selected = false;
	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_def != NULL) {
	   forminfo->Subform2->transforms->string3 = 
		xvf_strcpy(line_info.string_def);
	}
	else  forminfo->Subform2->transforms->string3 = NULL;

	xvf_deparse_string_line(&line_info, database,index);
	forminfo->Subform2->transforms->string3_index = index;
forminfo->Subform2->transforms->string3_selected = false;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	forminfo->Subform2->transforms->int4 = line_info.int_def;
	line_info.int_val = line_info.int_def;
	xvf_deparse_int_line(&line_info, database,index);
	forminfo->Subform2->transforms->int4_index = index;
forminfo->Subform2->transforms->int4_selected = false;
	index++;

	index++;

	forminfo->Subform2->transforms->do_something = false;
	forminfo->Subform2->transforms->do_something_index = index;
	index++;

	forminfo->Subform2->transforms->quit = false;
	index++;

	_xvf_get_Master(formptr, forminfo);

}

