.\" @(#)intro.n	1.3 5/2/90
.\"
.\" Copyright (c) 1988 by Sam Leffler.
.\" All rights reserved.
.\"
.\" This file is provided for unrestricted use provided that this
.\" legend is included on all tape media and as a part of the
.\" software program in whole or part.  Users may copy, modify or
.\" distribute this file at will.
.\"
.TH tiff 3T "May 2, 1990"
.SH NAME
tiff \- introduction to libtiff a library for reading and writing
.SM TIFF
files
.SH SYNOPSIS
.B "#include <tiffio.h>"
.br
cc file.c
.B -ltiff
.SH DESCRIPTION
.I Libtiff
is a library for reading and writing data files encoded with the
.I "Tag Image File"
format, Revision 5.0.
This file format is suitable for archiving multi-color and
monochromatic image data.
.PP
The library supports several compression algorithms, as indicated
by the
.I Compression
field, including:
no compression (1),
.SM CCITT
Group 3 Facsimile compression (3),
Lempel-Ziv & Welch compression (5), and
PackBits compression (32773).
In addition, several nonstandard compression algorithms are supported:
the 4-bit compression algorithm used
by the
.I ThunderScan
program (32809) (decompression only), Pixar's
Picio compression scheme (32900),
Silicon Graphics' compression scheme (32901),
and NeXT's 2-bit compression algorithm (32766) (decompression only).
Directory information may be in either little- or big-endian byte
order\-byte swapping is automatically done by the library.
Data bit ordering may be either Most Significant Bit (\c
.SM MSB\c
) to Least Significant Bit (\c
.SM LSB\c
) or
.SM LSB
to
.SM MSB.
Data may not have more than four samples per pixel.
Finally, the library does not support files in which the
.IR BitsPerSample ,
.IR Compression ,
.IR MinSampleValue ,
or
.IR MaxSampleValue
fields are defined differently on a per-sample basis
(in Rev. 5.0 the
.I Compression
tag is not defined on a per-sample basis, so this is immaterial).
.PP
In addition to the nonstandard compression schemes, the library also
supports one other nonstandard facility: a
.I Matteing
field (32995) that indicates whether or not sample
.IR SamplesPerPixel \-1
in each pixel holds Alpha (matteing) data.
When Alpha data is present, associated sample data
are assumed to be pre-multiplied by Alpha.
(The
.I Matteing
tag is a registered
.I private
tag that has been assigned to Silicon Graphics.)
.SH "LIST OF ROUTINES"
The following routines are available.
Consult specific manual pages for details on their operation.
.nf
.ta \w'TIFFWriteEncodedStrip'u+2n +\w'Appears on Page'u+2n
\fIName\fP	\fIAppears on Page\fP	\fIDescription\fP
.sp 5p
TIFFClose	close.n	close an open file
TIFFError	error.n	library error handler
TIFFFlush	flush.n	flush all pending writes
TIFFFlushData	flush.n	flush pending data writes
TIFFGetField	getfield.n	return tag value in current directory
TIFFOpen	open.n	open a file for reading or writing
TIFFReadDirectory	readdir.n	read the next directory
TIFFReadEncodedStrip	rdestrip.n	read and decode a strip of data
TIFFReadRawStrip	rdrstrip.n	read a raw strip of data
TIFFReadScanline	readline.n	read and decode a row of data
TIFFScanlineSize	linesize.n	return size of a scanline
TIFFSetDirectory	setdir.n	set the current directory
TIFFSetField	setfield.n	set a tag's value in the current directory
TIFFWarning	warning.n	library warning handler
TIFFWriteDirectory	writedir.n	write the current directory
TIFFWriteEncodedStrip	wrestrip.n	compress and write a strip of data
TIFFWriteRawStrip	wrrstrip.n	write a raw strip of data
TIFFWriteScanline	writeline.n	write a scanline of data
.fi
.SH DIAGNOSTICS
All error messages are directed to the
.IR TIFFError ()
routine which may be redefined by applications to
redirect messages.
By default messages are directed to
.B stderr
in the form:
.IR "module: message\en."
Warning messages are likewise directed to the
.IR TIFFWarning ()
routine.
.SH "SEE ALSO"
.IR fax2tiff (1),
.IR tiff2bw (1),
.IR tiffdither (1),
.IR tiffdump (1),
.IR tiffcp (1),
.IR tiffcmp (1),
.IR tiffgt (1),
.IR tiffinfo (1),
.IR tiffmedian (1),
.IR tiffsv (1),
.br
.IR "Tag Image File Format Specification \(em Revision 5.0" ,
an Aldus/Microsoft Technical Memorandum,
August 8, 1988.
.br
.IR "The Spirit of TIFF Class F" ,
an appendix to the TIFF 5.0 specification prepared by Cygnet Technologies.
.SH BUGS
It is not possible to overwrite the contents of a strip with
.IR TIFFWriteEncodedStrip ()
and
.IR TIFFWriteRawStrip ()
since they
.I append
to a strip.
Should handle more CCITT compression schemes.
Does not support random access to compressed data
that is organized with more than one row per strip.
Cannot handle unknown tags (perhaps should just save them
for the application?).
Does not do enough validity checking of a directory's contents.
