 /*
  * Khoros: $Id: form_info.c,v 1.1 1991/05/10 15:59:17 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: form_info.c,v 1.1 1991/05/10 15:59:17 khoros Exp $";
#endif

 /*
  * $Log: form_info.c,v $
 * Revision 1.1  1991/05/10  15:59:17  khoros
 * Initial revision
 *
  */ 

/*
 *---------------------------------------------------------------------
 *            Copyright 1990 University of New Mexico
 * 
 * Permission to copy and modify this software and its documen- 
 * tation only for internal use in your organization is hereby 
 * granted, provided that this notice is retained thereon and 
 * on all copies.  UNM makes no representations as too the sui- 
 * tability and operability of this software for any purpose. 
 * It is provided 'as is' without express or implied warranty. 
 *  
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT- 
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL, 
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT- 
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER- 
 * FORMANCE OF THIS SOFTWARE. 
 *  
 * No other rights, including for example, the right to redis- 
 * tribute this software and its documentation or the right to 
 * prepare derivative works, are granted unless specifically 
 * provided in a separate license agreement. 
 * 
 *---------------------------------------------------------------------
 */
#include "unmcopyright.h"
#include "xvforms.h"
#include "form_info.h"


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name:  form_info.c
 >>>>
 >>>>      Program Desc:  code to extract values
 >>>>                     from the graphical user interface 
 >>>>
 >>>>            Author:  automatically generated by conductor
 >>>>
 >>>> Date Last Updated:  Wed Jan 30 09:41:11 1991
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


/********************************************************
*
*  Routine Name: xvf_get_Master
*
*       Purpose: Fills in the user-specified
*                'Master'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                forminfo - pointer to the user-specified
*                'Master'
*
*       Output:  current values stored in  Master
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_Master(formptr, forminfo)

xvf_form *formptr;
Master *forminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;

	/***** getting 'Master' Form Information structure *****/


	index = 1;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->WarpImage_selected = line_info.selected;
	_xvf_get_WarpImage(formptr, forminfo->WarpImage);

}

/********************************************************
*
*  Routine Name: xvf_get_WarpImage
*
*       Purpose: Fills in the user-specified
*                'Master_WarpImage'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'Master_WarpImage'
*
*       Output:  current values stored in  'Master_WarpImage'
*
*    Called By:  xvf_get_*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_WarpImage(formptr, subforminfo)

xvf_form *formptr;
Master_WarpImage *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 2;


	/*** extracting 'Master->WarpImage'
 	   Subform Information structure ***/


	index = 3;

	xvf_parse_workspace_line(database[index], &line_info);
	subforminfo->workspace = line_info.workspace;

	index = 7;

	xvf_parse_subform_action_line(database[index], &line_info);
	subforminfo->view = line_info.selected;

	index = 8;

	xvf_parse_subform_action_line(database[index], &line_info);
	subforminfo->clear = line_info.selected;

	index = 9;

	xvf_parse_subform_action_line(database[index], &line_info);
	subforminfo->warp = line_info.selected;

	index = 12;

	xvf_parse_quit_line(database[index], &line_info);
	subforminfo->quit = line_info.selected;

	index = 14;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->Options_selected = line_info.selected;
	_xvf_get_Options(formptr, subforminfo->Options);

	index = 26;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->Input_selected = line_info.selected;
	_xvf_get_Input(formptr, subforminfo->Input);

	index = 31;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->Output_selected = line_info.selected;
	_xvf_get_Output(formptr, subforminfo->Output);

}



/********************************************************
*
*  Routine Name: xvf_get_Options
*
*       Purpose: Fills in the user-specified
*                'WarpImage_Options'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'WarpImage_Options'
*
*       Output:  current values stored in  'WarpImage_Options'
*
*    Called By:  xvf_get_WarpImage
*

*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_Options(formptr, paneinfo)

xvf_form *formptr;
WarpImage_Options *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 15;


	/* extracting 'Master->WarpImage->Options'
 	   Pane Information structure */

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->operation_val = line_info.toggle_val;
	paneinfo->operation_selected = line_info.selected;
	index++;

	index = 19;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->rb_zoom = line_info.selected;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->pc_zoom = line_info.selected;
	index++;

	index++;

	xvf_parse_float_line(database[index], &line_info);
	paneinfo->src_zoom_factor = line_info.float_val;
	paneinfo->src_zoom_factor_selected = line_info.selected;
	index++;

	xvf_parse_float_line(database[index], &line_info);
	paneinfo->dest_zoom_factor = line_info.float_val;
	paneinfo->dest_zoom_factor_selected = line_info.selected;
	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_Input
*
*       Purpose: Fills in the user-specified
*                'WarpImage_Input'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'WarpImage_Input'
*
*       Output:  current values stored in  'WarpImage_Input'
*
*    Called By:  xvf_get_WarpImage
*

*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_Input(formptr, paneinfo)

xvf_form *formptr;
WarpImage_Input *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 27;


	/* extracting 'Master->WarpImage->Input'
 	   Pane Information structure */

	xvf_parse_input_line(database[index], &line_info);
	if (line_info.filename != NULL) {
	   paneinfo->in_src_img = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->in_src_img = NULL;

	paneinfo->in_src_img_selected = line_info.selected;
	index++;

	xvf_parse_input_line(database[index], &line_info);
	if (line_info.filename != NULL) {
	   paneinfo->in_dest_img = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->in_dest_img = NULL;

	paneinfo->in_dest_img_selected = line_info.selected;
	index++;

	xvf_parse_output_line(database[index], &line_info);
	if (line_info.filename != NULL) {

	   paneinfo->in_tp = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->in_tp = NULL;

	paneinfo->in_tp_selected = line_info.selected;
	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_Output
*
*       Purpose: Fills in the user-specified
*                'WarpImage_Output'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'WarpImage_Output'
*
*       Output:  current values stored in  'WarpImage_Output'
*
*    Called By:  xvf_get_WarpImage
*

*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_Output(formptr, paneinfo)

xvf_form *formptr;
WarpImage_Output *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 32;


	/* extracting 'Master->WarpImage->Output'
 	   Pane Information structure */

	xvf_parse_output_line(database[index], &line_info);
	if (line_info.filename != NULL) {

	   paneinfo->out_tp = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->out_tp = NULL;

	paneinfo->out_tp_selected = line_info.selected;
	index++;

	xvf_parse_output_line(database[index], &line_info);
	if (line_info.filename != NULL) {

	   paneinfo->out_coeff = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->out_coeff = NULL;

	paneinfo->out_coeff_selected = line_info.selected;
	index++;



}


