 /*
  * Khoros: $Id: structs.h,v 1.1 1991/05/10 15:59:03 khoros Exp $
  */

 /*
  * $Log: structs.h,v $
 * Revision 1.1  1991/05/10  15:59:03  khoros
 * Initial revision
 *
  */ 


#ifndef _structs_h_
#define _structs_h_

/*
 *  structure holding information about the zoom window
 */
typedef struct
{
	Widget  parent;
        Widget  workspace;
        Widget  plotobj;

	Widget  view_wksp;
	Widget  view;

	Widget  top_wksp;
	Widget  top;

	Widget  front_wksp;
	Widget  front;

	Widget  right_wksp;
	Widget  right;

	Widget  left_wksp;
	Widget  left;

} PlotStructure;


/*
 * structure holding information about scroll bars 
 */
typedef struct
{
	int	 num;
        char     *string;
        unsigned long pixel;

        Widget   value;
        Widget   scrollbar;
}  ScrollStruct;

/*
 *  structure holding information about the pseudocolor window
 */
typedef struct
{
	Widget	      pseudo, color1, color2, palette, undo;

	int   	      model;
	Widget	      rgb_back, cmy_back, hsv_back, hls_back, 
	              yiq_back, xyz_back, uvw_back, grey_back;

	ScrollStruct  rgb[3], cmy[3], hsv[3], hls[3], yiq[3],
		      xyz[3], uvw[3], grey[1];
} PseudoStructure;


/*
 *  structure holding information about the individual lut canvas
 */
typedef struct
{
	int	  num;
        unsigned  long pixel;

	Widget    canvas;
	Widget    xpos;
	Widget    ypos;

} LutCanvasStruct;

/*
 *  structure holding information about the lut window
 */
typedef struct
{
	int   	  model, histogram, hist_type;

	Widget	  rgb_back, cmy_back, hsv_back, hls_back, 
	          yiq_back, xyz_back, uvw_back, grey_back;

	LutCanvasStruct *current_lut, *active_canvas;
	LutCanvasStruct rgb[3], cmy[3], hsv[3], hls[3], yiq[3],
		        xyz[3], uvw[3], grey[1];
        Widget toplevel;
        Widget back;
        Widget palette;
	Widget undo;

} LutStructure;


typedef struct
{
	unsigned long fill_pixel, nonzero_pixel;
	int	      mode, accept, invert;

	Widget        toplevel;
	Widget        palette;
	Widget        reset;
	ScrollStruct  *lower;
	ScrollStruct  *upper;

} ThresStructure;

typedef struct
{
	float	      eye_dist, alpha_val, theta_val;

	Widget        toplevel;
	Widget        back;
	ScrollStruct  *eye;
	ScrollStruct  *alpha;
	ScrollStruct  *theta;

} PerspStructure;

/*
 * structure holding information the X color elements.  Before
 * any of the display utilites change the color aray they push
 * the color structures onto the "color" stack, so that the user
 * has the option to pop or "undo" the coloring operations.
 */
typedef struct _color_stack
{
        int     index1, index2;

        XColor  *xcolors;
        struct  _color_stack *prev;
} ColorStack;

#endif
