 /*
  * Khoros: $Id: inquire.c,v 1.2 1991/10/02 00:13:46 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: inquire.c,v 1.2 1991/10/02 00:13:46 khoros Exp $";
#endif

 /*
  * $Log: inquire.c,v $
 * Revision 1.2  1991/10/02  00:13:46  khoros
 * HellPatch2
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: inquire.c
   >>>>                                                       <<<<
   >>>>   description:  routines used to inquire about the gwin
			and plot structures
   >>>>                                                       <<<<
   >>>>      routines: inquire_gwin_plots()
   >>>>                 inquire_plot()
   >>>>			inquire_gwin_attr_2D()
   >>>>                                                       <<<<
   >>>> modifications:					      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "xprism.h"	


/***********************************************************************
*
*  Routine Name: inquire_gwin_plots()
*
*          Date: Thu Aug 16 13:05:23 MDT 1990
*        
*       Purpose: This routine will return the number of
*		 plots in the gwin structure. The gwin_num
*		 for now should be set to 1 since we only have
*		 one gwin.
*
*         Input: int - gwin_num - which gwin to give info on
*		 int - *numplots - pointer to returned value
*
*        Output:  int - *numplots - number of plots for this gwin
*
*    Written By:  Tom Sauer
*
* Modifications:
*
***********************************************************************/
inquire_gwin_plots(gwin_num, numplots )

int gwin_num, *numplots;
{
	*numplots = gwin->plotnum;

}

/***********************************************************************
*
*  Routine Name: inquire_plot
*
*          Date: Thu Aug 16 13:46:16 MDT 1990
*        
*       Purpose: This routine will return information about the
*		 given plot structure.  
*
*         Input: int - plotnum - which plot to give info on.
*		 int - gwinnum - which gwin the plot is in (for later use)
*		 all other variables must be passed as pointers
*
*        Output: int - *active - active field of plot structure
*		 int - *plot_type - plot_type field of plot structure
*		 int - *data_type - data_type field of plot structure
*		 int - *data_format - data_format field of plot structure
*		 int - *marker - marker field of plot structure
*		 int - *line_type - line_type field of plot structure
*		 int - *colorindex - colorindex field of plot structure
*		 int - *begin_point - begin_point field of plot structure
*		 int - *end_point - end_point field of plot structure
*		 int - *step_size - step_size field of plot structure
*		 int - *machine_type_index - index for machine type for raw data
*		 int - *band - if a VIFF, the band number plotted
*		 int - *cmplx - if a COMPLEX VIFF, the complex type plotted
*		 int - *input_type - the file type
*		 char - *filename - filename fiels of plot structure
*		 char - *function - function fiels of plot structure
*		 char - *xrange - xrange fiels of plot structure
*
*    Written By:  Tom Sauer
*
* Modifications:
*
***********************************************************************/
inquire_plot_2D(plotnum, gwinnum, active, plot_type, data_type,
		    data_format, filename, function, xrange,
		    legend_str, marker, line_type, colorindex, 
		    begin_point, end_point, step_size, machine_type_index,
		    band, cmplx, input_type)

int plotnum, gwinnum;
int *active, *plot_type, *data_type, *data_format, *machine_type_index;
char **filename, **function, **xrange, **legend_str;
int  *marker, *line_type, *colorindex, *begin_point, *end_point, *step_size;
int  *band, *cmplx, *input_type;

{
	XPlot *plot;
	int i;

        if (gwin == NULL)
	   return(0);

        if (gwin->plotnum == 0) 
	   return(0);

        plot = gwin->plist;
	for (i = 0; i < gwin->plotnum; i++)
	{
           if (plot->id == plotnum)
	       break;
 	   else
               plot = plot->next;
	}
	*active 	= plot->active;
	*plot_type 	= plot->plot_type;
	*data_type 	= plot->data_type;
	*data_format 	= plot->data_format;
	*marker 	= plot->marker;
	*line_type 	= plot->line_type;
	*colorindex 	= plot->colorindex;
	*begin_point 	= (int)  plot->begin_point.x;
	*end_point 	= (int) plot->end_point.x;
	*step_size 	= (int) plot->step_size.x;
        *machine_type_index = plot->machine_type_index;
	*band 		= plot->band;
	*cmplx		= plot->cmplx;
	*input_type	= plot->input_type;

	if (plot->filename != NULL)
	   *filename = VStrcpy(plot->filename);
	else
	   *filename = NULL;
	if (plot->function != NULL)
	   *function = VStrcpy(plot->function);
	else
	   *function = NULL;
	if (plot->xrange != NULL)
	   *xrange = VStrcpy(plot->xrange);
	else
	   *xrange = NULL;
	if (plot->legend_str != NULL)
	   *legend_str = VStrcpy(plot->legend_str);
	else
	   *legend_str = NULL;
	
	return(1);
}


/***********************************************************************
*
*  Routine Name: inquire_gwin_attr
*
*          Date: Thu Aug 16 13:48:51 MDT 1990
*        
*       Purpose: Returns information about the gwin_attr structure. 
*
*         Input: int - gwin_attr_num - which gwin_attr we want info on 
*					(for later use)
*                pointers to all variables
*
*        Output: int - *clear_labels - clear_labels field in gwin_attr 
*		 int - *draw_grid - draw_grid field in gwin_attr
*		 int - *draw_box - draw_box field in gwin_attr
*		 int - *draw_legend - draw_legend field in gwin_attr
*		 int - *draw_axes - draw_axes field in gwin_attr
*		 int - *draw_numlabels - draw_numlabels field in gwin_attr
*		 int - *auto_scale - auto_scale field in gwin_attr
*		 int - *rescale_relabel - rescale_relabel field in gwin_attr
*		 int - *font - font field in gwin_attr
*		 Coord - scale - scale field in gwin_attr
*		 Coord - minor_tics - minor_tics field in gwin_attr
*		 Coord - disp_label_min - disp_label_min field in gwin_attr
*		 Coord - disp_label_max - disp_label_max field in gwin_attr
*		 Coord - disp_label_intv - disp_label_major_intv field in gwin_attr
*		 Coord - disp_scale_min - disp_scale_min field in gwin_attr
*		 Coord - disp_scale_max - disp_scale_max field in gwin_attr
*		 Coord - disp_scale_intv - disp_scale_major_intv field in gwin_attr
*		 char - *title - title field in gwin_attr
*		 char - *xaxis - xaxis field in gwin_attr
*		 char - *yaxis - yaxis field in gwin_attr
*
*		 float - *alpha - alpha perspective
*		 float - *theta - theta perspective
*		 float - *viewdist - viewdist perspective
*		 float - *eysdist - eysdist perspective
*
*    Written By: Tom Sauer 
*
* Modifications:
*
***********************************************************************/
inquire_gwin_attr(gwin_attr_num, title, xaxis, yaxis,zaxis,font,current_colors,
		     clear_labels, draw_grid, draw_box, draw_legend, 
		     draw_axes, draw_numlabels, auto_scale, 
		     rescale_relabel, scale, minor_tics, 
		     disp_label_min, disp_label_max, disp_label_intv,
		     disp_scale_min, disp_scale_max, disp_scale_intv,
		     alpha, theta, eyedist, viewdist)

int gwin_attr_num;
int *font, *current_colors, *clear_labels, *draw_grid, *draw_box,
    *draw_legend, *draw_axes, *draw_numlabels, *auto_scale, *rescale_relabel;
char **title, **xaxis, **yaxis, **zaxis;
Coord *scale, *minor_tics, *disp_label_min, *disp_label_max, *disp_label_intv,
	     *disp_scale_min, *disp_scale_max, *disp_scale_intv;
float *alpha, *theta, *eyedist, *viewdist;
    
{
	int i;

	if (gwin_attr == NULL)
	   return(0);

	if (gwin_attr->title != NULL)
	  *title = VStrcpy(gwin_attr->title);
	else
	  *title = NULL;
	if (gwin_attr->xaxis != NULL)
	  *xaxis = VStrcpy(gwin_attr->xaxis);
	else
	  *xaxis = NULL;

	if (gwin_attr->yaxis != NULL)
	  *yaxis = VStrcpy(gwin_attr->yaxis);
	else
	  *yaxis = NULL;

	if (gwin_attr->zaxis != NULL)
	  *zaxis = VStrcpy(gwin_attr->zaxis);
	else
	  *zaxis = NULL;

	for (i = 0; i < 12; i++)
	  current_colors[i] = gwin_attr->current_colors[i];

	*clear_labels = gwin_attr->clear_labels;
	*draw_axes = gwin_attr->draw_axes;
	*draw_numlabels = gwin_attr->draw_numlabels;
	*draw_grid = gwin_attr->draw_grid;
	*draw_box = gwin_attr->draw_box;
	*draw_legend = gwin_attr->draw_legend;
	*auto_scale = gwin_attr->auto_scale;
	*rescale_relabel = gwin_attr->rescale_relabel;

	*alpha = (float) gwin_attr->alpha;
	*theta = (float) gwin_attr->theta;
	*eyedist = (float) gwin_attr->eye_dist;
	*viewdist = (float) gwin_attr->view_dist;

	scale->x = gwin_attr->scale.x;
	scale->y = gwin_attr->scale.y;
	scale->z = gwin_attr->scale.z;

	minor_tics->x = gwin_attr->minor_tics.x;
	minor_tics->y = gwin_attr->minor_tics.y;
	minor_tics->z = gwin_attr->minor_tics.z;

	disp_label_min->x = gwin_attr->disp_label_min.x;
	disp_label_min->y = gwin_attr->disp_label_min.y;
	disp_label_min->z = gwin_attr->disp_label_min.z;

	disp_label_max->x = gwin_attr->disp_label_max.x;
	disp_label_max->y = gwin_attr->disp_label_max.y;
	disp_label_max->z = gwin_attr->disp_label_max.z;

	disp_label_intv->x = gwin_attr->disp_label_major_intv.x;
	disp_label_intv->y = gwin_attr->disp_label_major_intv.y;
	disp_label_intv->z = gwin_attr->disp_label_major_intv.z;

	disp_scale_min->x = gwin_attr->disp_scale_min.x;
	disp_scale_min->y = gwin_attr->disp_scale_min.y;
	disp_scale_min->z = gwin_attr->disp_scale_min.z;

	disp_scale_max->x = gwin_attr->disp_scale_max.x;
	disp_scale_max->y = gwin_attr->disp_scale_max.y;
	disp_scale_max->z = gwin_attr->disp_scale_max.z;

	disp_scale_intv->x = gwin_attr->disp_scale_major_intv.x;
	disp_scale_intv->y = gwin_attr->disp_scale_major_intv.y;
	disp_scale_intv->z = gwin_attr->disp_scale_major_intv.z;


	for (i = 0; i < 6; i++)
	{
	   font[i] = get_font_number(gwin_attr->font[i]);
	}

	return(1);
}

/***********************************************************************
*
*  Routine Name: inquire_plot_3D
*
*          Date: Thu Aug 16 13:46:16 MDT 1990
*        
*       Purpose: This routine will return information about the
*		 given plot structure.  
*
*         Input: int - plotnum - which plot to give info on.
*		 int - gwinnum - which gwin the plot is in (for later use)
*		 all other variables must be passed as pointers
*
*        Output: int - *active - active field of plot structure
*		 int - *plot_type - plot_type field of plot structure
*		 int - *data_type - data_type field of plot structure
*		 int - *data_format - data_format field of plot structure
*		 int - *marker - marker field of plot structure
*		 int - *line_type - line_type field of plot structure
*		 int - *row_size - row_size field of plot structure
*		 int - *colorindex - colorindex field of plot structure
*		 int - *begin_point_x - begin_point_x field of plot structure
*		 int - *end_point_x - end_point_x field of plot structure
*		 int - *step_size_x - step_size_x field of plot structure
*		 int - *begin_point_y - begin_point_y field of plot structure
*		 int - *end_point_y - end_point_y field of plot structure
*		 int - *step_size_y - step_size_y field of plot structure
*		 int - *machine_type_index - index for mach type for raw data
*		 int - *row - the number of columns in the image
*		 int - *band - if a VIFF, the band number plotted
*		 int - *cmplx - if a COMPLEX VIFF, the complex type plotted
*		 int - *input_type - the file type
*		 char - *filename - filename fiels of plot structure
*		 char - *function - function fiels of plot structure
*		 char - *xrange - xrange fiels of plot structure
*
*    Written By:  Tom Sauer
*
* Modifications:
*
***********************************************************************/
inquire_plot_3D(plotnum, gwinnum, active, plot_type, data_type,
		    data_format, filename, function, xrange, yrange,
		    legend_str, marker, line_type, colorindex, rows,
		    begin_point_x, end_point_x, step_size_x,
		    begin_point_y, end_point_y, step_size_y, 
		    machine_type_index, band, cmplx, input_type)

int plotnum, gwinnum;
int *active, *plot_type, *data_type, *data_format, *machine_type_index;
char **filename, **function, **xrange, **yrange, **legend_str;
int  *marker, *line_type, *colorindex, *rows,
     *begin_point_x, *end_point_x, *step_size_x,
     *begin_point_y, *end_point_y, *step_size_y;
int  *band, *cmplx, *input_type;


{
	XPlot *plot;
	int i;

        if (gwin == NULL)
	   return(0);

        if (gwin->plotnum == 0)
	   return(0);

        plot = gwin->plist;
	for (i = 0; i < gwin->plotnum; i++)
	{
           if (plot->id == plotnum)
	       break;
 	   else
               plot = plot->next;
	}
	*active 	= plot->active;
	*plot_type 	= plot->plot_type;
	*data_type 	= plot->data_type;
	*data_format 	= plot->data_format;
	*marker 	= plot->marker;
	*line_type 	= plot->line_type;
	*colorindex 	= plot->colorindex;
	*begin_point_x 	= (int)  plot->begin_point.x;
	*end_point_x 	= (int) plot->end_point.x;
	*step_size_x 	= (int) plot->step_size.x;
	*begin_point_y 	= (int)  plot->begin_point.y;
	*end_point_y 	= (int) plot->end_point.y;
	*step_size_y 	= (int) plot->step_size.y;
	*rows		= plot->size/plot->row_size;
	*machine_type_index = plot->machine_type_index;
	*band		= plot->band;
	*cmplx		= plot->cmplx;
	*input_type	= plot->input_type;

	if (plot->filename != NULL)
	   *filename = VStrcpy(plot->filename);
	else
	   *filename = NULL;
	if (plot->function != NULL)
	   *function = VStrcpy(plot->function);
	else
	   *function = NULL;
	if (plot->xrange != NULL)
	   *xrange = VStrcpy(plot->xrange);
	else
	   *xrange = NULL;
	if (plot->yrange != NULL)
	   *yrange = VStrcpy(plot->yrange);
	else
	   *yrange = NULL;
	if (plot->legend_str != NULL)
	   *legend_str = VStrcpy(plot->legend_str);
	else
	   *legend_str = NULL;
	
	return(1);
}


/***********************************************************************
*
*  Routine Name: get_font_number()
*
*          Date: Thu Aug 16 15:03:50 MDT 1990
*        
*       Purpose: given a font name, this routine returns the
*		 index associated with that font name. 
*
*         Input: font_name - name of the font
*
*        Output: returns the font index
*
*    Written By: Tom Sauer 
*
* Modifications:
*
***********************************************************************/
int get_font_number(font_name)

char *font_name;
{
	int i;

	for (i = 0; font_name != NULL && i < NUMBER_FONTS ; i++)
	{
           if (! strcmp(font_name, font_names[i]) )
	   {
	      return(i);
	   }
	}	
	return(-1);
}
