 /*
  * Khoros: $Id: clear.c,v 1.3 1991/12/18 09:15:42 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: clear.c,v 1.3 1991/12/18 09:15:42 dkhoros Exp $";
#endif

 /*
  * $Log: clear.c,v $
 * Revision 1.3  1991/12/18  09:15:42  dkhoros
 * HellPatch3
 *
  */
 
/*
 *----------------------------------------------------------------------
 *
 *            Copyright 1990 University of New Mexico
 *  
 *  Permission to use, copy, modify, distribute, and sell this
 *  software and its documentation for any purpose is hereby
 *  granted without fee, provided that the above copyright
 *  notice appear in all copies and that both that copyright
 *  notice and this permission notice appear in supporting docu-
 *  mentation, and that the name of UNM not be used in advertis-
 *  ing or publicity pertaining to distribution of the software
 *  without specific, written prior permission.  UNM makes no
 *  representations about the suitability of this software for
 *  any purpose.  It is provided "as is" without express or
 *  implied warranty.
 *  
 *  UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 *  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 *  NESS, IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 *  INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 *  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 *  ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 *  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 *  OF THIS SOFTWARE.
 *  
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "xvdisplay.h"

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>            Clear Display Utility Routines	      <<<<
   >>>>                                                       <<<<
   >>>>		    xvd_clear_image()			      <<<<
   >>>>		    xvd_clear_shape()			      <<<<
   >>>>		    xvd_clear_clip()			      <<<<
   >>>>		    xvd_clear_overlay()			      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */



/************************************************************
*
*  MODULE NAME: xvd_clear_image
*
*      PURPOSE: Clears the display image associated with the
*		xvdisplay structure.
*
*        INPUT: xvdisplay - the xvdisplay structure to be updated.
*
*		free_image - should it free the original image
*
*       OUTPUT: returns True if we are successful, otherwise False.
*
*    CALLED BY: the application program
*
*   WRITTEN BY: Mark Young
*
*
*************************************************************/


int xvd_clear_image(xvdisplay, free_image)

DisplayStructure *xvdisplay;
int		 free_image;
{
	struct xvimage *temp, *disp_image;


	temp	   = xvdisplay->image;
	disp_image = xvdisplay->disp_image;

	xvdisplay->image =
	xvdisplay->disp_image = NULL;
	if (xvd_update_image(xvdisplay, NULL) == False)
	{
	   xvdisplay->image = temp;
	   xvdisplay->disp_image = disp_image;
	   return(False);
	}

	if (free_image == True)
	{
	   if (temp != disp_image && disp_image != NULL)
	      freeimage(disp_image);

	   if (temp != NULL) freeimage(temp);
	}
	return(True);

}  /* end xvd_clear_image */



/************************************************************
*
*  MODULE NAME: xvd_clear_shape
*
*      PURPOSE: Clears the display shape associated with the
*		xvdisplay structure.
*
*        INPUT: xvdisplay - the xvdisplay structure to be updated.
*
*		free_shape - should it free the original shape mask
*
*       OUTPUT: returns True if we are successful, otherwise False.
*
*    CALLED BY: the application program
*
*   WRITTEN BY: Mark Young
*
*
*************************************************************/


int xvd_clear_shape(xvdisplay, free_shape)

DisplayStructure *xvdisplay;
int		 free_shape;
{
	struct xvimage *temp;


	temp = xvdisplay->shape;
	xvdisplay->shape = NULL;
	if (xvd_update_shape(xvdisplay, NULL) == False)
	{
	   xvdisplay->shape = temp;
	   return(False);
	}

	if (temp != NULL && free_shape == True)
	   freeimage(temp);

	return(True);

}  /* end xvd_clear_shape */



/************************************************************
*
*  MODULE NAME: xvd_clear_clip
*
*      PURPOSE: Clears the display clip associated with the
*		xvdisplay structure.
*
*        INPUT: xvdisplay - the xvdisplay structure to be updated.
*
*		free_clip - should it free the original clip mask
*
*       OUTPUT: returns True if we are successful, otherwise False.
*
*    CALLED BY: the application program
*
*   WRITTEN BY: Mark Young
*
*
*************************************************************/


int xvd_clear_clip(xvdisplay, free_clip)

DisplayStructure *xvdisplay;
int		 free_clip;
{
	struct xvimage *temp;


	temp = xvdisplay->clip;
	xvdisplay->clip = NULL;
	if (xvd_update_clip(xvdisplay, NULL) == False)
	{
	   xvdisplay->clip = temp;
	   return(False);
	}

	if (temp != NULL && free_clip == True)
	   freeimage(temp);

	return(True);

}  /* end xvd_clear_clip */



/************************************************************
*
*  MODULE NAME: xvd_clear_overlay
*
*      PURPOSE: Clears the display shape associated with the
*		xvdisplay structure.
*
*        INPUT: xvdisplay - the xvdisplay structure to be updated.
*
*		free_overlay - should it free the original image
*
*       OUTPUT: returns True if we are successful, otherwise False.
*
*    CALLED BY: the application program
*
*   WRITTEN BY: Mark Young
*
*
*************************************************************/


int xvd_clear_overlay(xvdisplay, free_overlay)

DisplayStructure *xvdisplay;
int		 free_overlay;
{
	struct xvimage *temp;


	temp = xvdisplay->overlay;
	xvdisplay->overlay = NULL;
	if (xvd_update_overlay(xvdisplay, NULL) == False)
	{
	   xvdisplay->overlay = temp;
	   return(False);
	}

	if (temp != NULL && free_overlay == True)
	   freeimage(temp);

	return(True);

}  /* end xvd_clear_overlay */
