 /*
  * Khoros: $Id: vinsert.h,v 1.1 1991/05/10 15:51:21 khoros Exp $
  */

 /*
  * $Log: vinsert.h,v $
 * Revision 1.1  1991/05/10  15:51:21  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vinsert.h
 >>>>            Author: John Rasure, Tom Sauer, Mark Young
 >>>> Date Last Updated: Thu Mar  7 15:56:03 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vinsert_h_
#define _vinsert_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vinsert Argument Structure
*
****************************************************************/

typedef struct _vinsert  {

/*
 *  input image (Required infile)
 */
char	*i1_file;	/* input image FILENAME */
int	 i1_flag;	/* input image FLAG */

/*
 *  second input image (Required infile)
 */
char	*i2_file;	/* second input image FILENAME */
int	 i2_flag;	/* second input image FLAG */

/*
 *  resulting combined image (Required outfile)
 */
char	*o_file;	/* resulting combined image FILENAME */
int	 o_flag;	/* resulting combined image FLAG */

/*
 *  insert subimage beginning at upper left x coordinate (Optional integer)
 */
int	 x_int; 	/* insert subimage beginning at upper left x coordinate INT */
int	 x_flag;	/* insert subimage beginning at upper left x coordinate FLAG */

/*
 *  insert subimage beginning at upper left y coordinate (Optional integer)
 */
int	 y_int; 	/* insert subimage beginning at upper left y coordinate INT */
int	 y_flag;	/* insert subimage beginning at upper left y coordinate FLAG */

/*
 *  image real constant pad level (Optional float)
 */
float	 l_float;	/* image real constant pad level FLOAT */
int	 l_flag;   	/* image real constant pad level FLAG */

/*
 *  image imaginary constant pad level (Optional float)
 */
float	 m_float;	/* image imaginary constant pad level FLOAT */
int	 m_flag;   	/* image imaginary constant pad level FLAG */

}  vinsert_struct;

vinsert_struct *vinsert;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT1(img1, program) \
img1 = readimage(vinsert->i1_file); \
if(img1 == NULL){ \
(void) fprintf(stderr,"%s: Image 1 could not be read\n", program); \
exit(1); \
}
#define READINPUT2(img2, program) \
img2 = readimage(vinsert->i2_file); \
if(img2 == NULL){ \
(void) fprintf(stderr,"%s: Image 2 could not be read\n", program); \
exit(1); \
}
#define CHECKINPUT(program, img1, img2) \
        (void) proper_num_images(program,img1,1,TRUE); \
        (void) match_num_images(program,img1,img2,TRUE); \
        \
        (void) match_num_bands(program,img1,img2,TRUE); \
        \
        (void) proper_map_enable(program,img1,VFF_MAP_OPTIONAL,TRUE); \
        (void) match_map_enable(program,img1,img2,TRUE)
/* -include_macros_end */

#endif
