 /*
  * Khoros: $Id: vfileinfo.c,v 1.3 1992/03/20 23:08:19 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vfileinfo.c,v 1.3 1992/03/20 23:08:19 dkhoros Exp $";
#endif

 /*
  * $Log: vfileinfo.c,v $
 * Revision 1.3  1992/03/20  23:08:19  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vfileinfo.c
 >>>>
 >>>>      Program Name: vfileinfo
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Gives information about an Khoros Image File (xviff)
 >>>>	
 >>>>	

 >>>>            Author: Argiro, Young, Neher, Rasure
 >>>>
 >>>> Date Last Updated: Fri Feb 14 20:34:33 1992
 >>>>
 >>>>          Routines: main- the main program for vfileinfo
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vfileinfo.h"


/****************************************************************
 *
 * Routine Name:  main program for vfileinfo
 *
 *       Input:  
 *           -i  input image 
 *
 *
 *           [-f] output ASCII file
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    int    fid;
    struct xvimage *image, *readheader();
    FILE *printdev;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);

if ((fid = kopen(vfileinfo->i_file, O_RDONLY)) < 0)
{
   (void) fprintf(stderr, "vfileinfo:  Can't open input file: %s\n",
                  vfileinfo->i_file);
   exit(1);
}
if ((image = readheader(fid)) == NULL)
{
   (void) fprintf(stderr, "vfileinfo:  Error reading VIFF header from file: \
%s\n", vfileinfo->i_file);
   exit(1);
}

if (vfileinfo->f_flag) 
{
   if (! vwrite_ascii(vfileinfo->f_file, &printdev))
   {
      (void) fprintf(stderr, "vfileinfo:  Can't open ascii output file: n");
      exit(1);
   }
}
else printdev = stdout;
/* -main_before_lib_call_end */

/* -main_library_call */
if (! lvfileinfo(image, vfileinfo->i_file, printdev))
{
   (void) fprintf(stderr, "lvfileinfo Failed\n");
   exit(1);
}
/* -main_library_call_end */

/* -main_after_lib_call */
(void) fclose(printdev);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vfileinfo 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vfileinfo :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tGives information about an Khoros Image File (xviff)\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-f]  output ASCII file (outfile) [null]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vfileinfo\n");
	fprintf(stderr, "\t[-U] Gives the usage for vfileinfo\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vfileinfo.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vfileinfo.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vfileinfo
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*f_pstr = 
	"\nEnter: (f) output ASCII file \n        {outfile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vfileinfo", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vfileinfo.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vfileinfo: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vfileinfo.ans");
		}

	     }

	}

	/*
	 * allocate the vfileinfo structure
	 */
	vfileinfo = (vfileinfo_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vfileinfo_struct));

	/*
	 * get required arguments for vfileinfo
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vfileinfo->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vfileinfo->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vfileinfo->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vfileinfo->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vfileinfo->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vfileinfo
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vfileinfo->f_flag = vget_outfile(fid, prompt_flag,
	"-f", f_pstr, &(vfileinfo->f_file))
;


}



