 /*
  * Khoros: $Id: vmspan.c,v 1.1 1991/05/10 15:48:52 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vmspan.c,v 1.1 1991/05/10 15:48:52 khoros Exp $";
#endif

 /*
  * $Log: vmspan.c,v $
 * Revision 1.1  1991/05/10  15:48:52  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vmspan.c
 >>>>
 >>>>      Program Name: vmspan
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Dilate a binary image region by a single pixel
 >>>>	
 >>>>	
 >>>>            Author: Greg Donohoe  Pascal Adam 
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:31:50 1991
 >>>>
 >>>>          Routines: main- the main program for vmspan
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vmspan.h"


/****************************************************************
 *
 * Routine Name:  main program for vmspan
 *
 *       Input:  
 *        -i  input image 
 *        -o  output image 
 *
 *
 *        [-s] source value  (0 < value < 255)
 *        [-m] medium value  (0 < value < 255)
 *        [-w] wave value  (0 < value < 255)
 *        [-iter] iterations 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */

   if (check_args()) exit(1);

   READINPUT(image) ;
   CHECKINPUT(program, image) ;

/* -main_before_lib_call_end */

/* -main_library_call */

   if(! lvmspan(image,vmspan->s_int,vmspan->m_int,vmspan->w_int,
                       vmspan->iter_int))
   {
      (void) fprintf(stderr, "vmspan: lvmspan Failed\n");
      exit(1);
   }


/* -main_library_call_end */

/* -main_after_lib_call */
   writeimage(vmspan->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vmspan 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vmspan :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tDilate a binary image region by a single pixel\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-s]  source value (integer, 0 to 255) [255]\n");
	fprintf(stderr,"\t[-m]  medium value (integer, 0 to 255) [0]\n");
	fprintf(stderr,"\t[-w]  wave value (integer, 0 to 255) [255]\n");
	fprintf(stderr,"\t[-iter]  iterations (integer) [1]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vmspan\n");
	fprintf(stderr, "\t[-U] Gives the usage for vmspan\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vmspan.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vmspan.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vmspan
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image \n        {outfile}: "; 
char	*s_pstr = 
	"\nEnter: (s) source value \n        {integer, 0 to 255 [255] }: "; 
char	*m_pstr = 
	"\nEnter: (m) medium value \n        {integer, 0 to 255 [0] }: "; 
char	*w_pstr = 
	"\nEnter: (w) wave value \n        {integer, 0 to 255 [255] }: "; 
char	*iter_pstr = 
	"\nEnter: (iter) iterations \n        {integer [1] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vmspan", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vmspan.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vmspan: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vmspan.ans");
		}

	     }

	}

	/*
	 * allocate the vmspan structure
	 */
	vmspan = (vmspan_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vmspan_struct));

	/*
	 * get required arguments for vmspan
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vmspan->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vmspan->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vmspan->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vmspan->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vmspan->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vmspan->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vmspan->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vmspan->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vmspan->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vmspan->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vmspan
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vmspan->s_flag = vget_int(fid, prompt_flag,
	"-s", s_pstr, &(vmspan->s_int),
	255, 0, 255);

	vmspan->m_flag = vget_int(fid, prompt_flag,
	"-m", m_pstr, &(vmspan->m_int),
	0, 0, 255);

	vmspan->w_flag = vget_int(fid, prompt_flag,
	"-w", w_pstr, &(vmspan->w_int),
	255, 0, 255);

	vmspan->iter_flag = vget_int(fid, prompt_flag,
	"-iter", iter_pstr, &(vmspan->iter_int),
	1, 0, 0);


}



