 /*
  * Khoros: $Id: vwiener.c,v 1.2 1992/03/20 23:09:55 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vwiener.c,v 1.2 1992/03/20 23:09:55 dkhoros Exp $";
#endif

 /*
  * $Log: vwiener.c,v $
 * Revision 1.2  1992/03/20  23:09:55  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vwiener.c
 >>>>
 >>>>      Program Name: vwiener
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Perform  image   restoration   by   Wiener   (least-squares)
 >>>>	filtering.
 >>>>	
 >>>>	

 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Mon Mar  9 18:44:43 1992
 >>>>
 >>>>          Routines: main- the main program for vwiener
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vwiener.h"


/****************************************************************
 *
 * Routine Name:  main program for vwiener
 *
 *       Input:  
 *         -i1  FFT of image to be restored 
 *         -i2  FFT of PSF function 
 *         -o1  FFT of restored image 
 *         -t  minimum PSF threshold   (value >= 0.0)
 *         -w  Weiner parameter   (value >= 0.0)
 *
 *
 *         [-i3] FFT of reference image
 *         [-o2] FFT of restoration filter
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *f1, *f2, *f3, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);
    f1 = readimage(vwiener->i1_file);
    if (f1 == NULL) exit(1);              /* Quit if bad image */
    if (vwiener->i3_flag) f2 = readimage(vwiener->i3_file);
    if (vwiener->i3_flag && (f2 == NULL)) exit(1);    /* Quit if bad image */
    f3 = readimage(vwiener->i2_file);
    if (f3 == NULL) exit(1);              /* Quit if bad image */

    CHECKINPUT(program,f1,f3);  /* Verify input images */

    if(vwiener->i3_flag){
        MATCHINPUT(program,f1,f2);      /* Verify input images */
    }
/* -main_before_lib_call_end */

/* -main_library_call */
    if (! lvwiener(f1,f2,f3,vwiener->i3_flag,vwiener->t_float,vwiener->w_float) )
    {
        (void) fprintf(stderr, "lvwiener Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(vwiener->o1_file,f1);
    if (vwiener->o2_flag) writeimage(vwiener->o2_file,f3);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vwiener 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vwiener :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tPerform  image   restoration   by   Wiener   (least-squares)\n");
	fprintf(stderr, "\tfiltering.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  FFT of image to be restored  (infile)\n");
	fprintf(stderr,"\t-i2  FFT of PSF function  (infile)\n");
	fprintf(stderr,"\t-o1  FFT of restored image  (outfile)\n");
	fprintf(stderr,"\t-t  minimum PSF threshold  (float, >= 0.0)\n");
	fprintf(stderr,"\t-w  Weiner parameter  (float, >= 0.0)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-i3]  FFT of reference image (infile) [null]\n");
	fprintf(stderr,"\t[-o2]  FFT of restoration filter (outfile) [null]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vwiener\n");
	fprintf(stderr, "\t[-U] Gives the usage for vwiener\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vwiener.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vwiener.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vwiener
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) FFT of image to be restored \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) FFT of PSF function \n        {infile}: "; 
char	*o1_pstr = 
	"\nEnter: (o1) FFT of restored image \n        {outfile}: "; 
char	*t_pstr = 
	"\nEnter: (t) minimum PSF threshold \n        {float, >= 0.0}: "; 
char	*w_pstr = 
	"\nEnter: (w) Weiner parameter \n        {float, >= 0.0}: "; 
char	*i3_pstr = 
	"\nEnter: (i3) FFT of reference image \n        {infile}: "; 
char	*o2_pstr = 
	"\nEnter: (o2) FFT of restoration filter \n        {outfile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vwiener", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vwiener.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vwiener: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vwiener.ans");
		}

	     }

	}

	/*
	 * allocate the vwiener structure
	 */
	vwiener = (vwiener_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vwiener_struct));

	/*
	 * get required arguments for vwiener
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vwiener->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(vwiener->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vwiener->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    vwiener->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(vwiener->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vwiener->i2_flag = vget_infile(fid, prompt_flag,
			"-i2", i2_pstr, &(vwiener->i2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vwiener->i2_flag))
		{
		    fprintf(stderr, "\t\ti2 is required, please re-enter: \n");
		    vwiener->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(vwiener->i2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vwiener->o1_flag = vget_outfile(fid, prompt_flag,
			"-o1", o1_pstr, &(vwiener->o1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vwiener->o1_flag))
		{
		    fprintf(stderr, "\t\to1 is required, please re-enter: \n");
		    vwiener->o1_flag = vget_outfile(fid, prompt_flag,
		    "-o1", o1_pstr, &(vwiener->o1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vwiener->t_flag = vget_float(fid, prompt_flag,
			"-t", t_pstr, &(vwiener->t_float),
			0.000001, 1.000000, 1.000000)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vwiener->t_flag))
		{
		    fprintf(stderr, "\t\tt is required, please re-enter: \n");
		    vwiener->t_flag = vget_float(fid, prompt_flag,
		    "-t", t_pstr, &(vwiener->t_float),
		    0.000001, 1.000000, 1.000000);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-t' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vwiener->w_flag = vget_float(fid, prompt_flag,
			"-w", w_pstr, &(vwiener->w_float),
			0.000001, 1.000000, 1.000000)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vwiener->w_flag))
		{
		    fprintf(stderr, "\t\tw is required, please re-enter: \n");
		    vwiener->w_flag = vget_float(fid, prompt_flag,
		    "-w", w_pstr, &(vwiener->w_float),
		    0.000001, 1.000000, 1.000000);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-w' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vwiener
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vwiener->i3_flag = vget_infile(fid, prompt_flag,
	"-i3", i3_pstr, &(vwiener->i3_file))
;

	vwiener->o2_flag = vget_outfile(fid, prompt_flag,
	"-o2", o2_pstr, &(vwiener->o2_file))
;


}



