 /*
  * Khoros: $Id: vencode.c,v 1.1 1991/05/10 15:46:43 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vencode.c,v 1.1 1991/05/10 15:46:43 khoros Exp $";
#endif

 /*
  * $Log: vencode.c,v $
 * Revision 1.1  1991/05/10  15:46:43  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vencode.c
 >>>>
 >>>>      Program Name: vencode
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Change the data encoding scheme of an image
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:22:30 1991
 >>>>
 >>>>          Routines: main- the main program for vencode
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vencode.h"


/****************************************************************
 *
 * Routine Name:  main program for vencode
 *
 *       Input:  
 *         -i  input image 
 *         -o  output image 
 *
 *
 *         [-s] Encoding scheme
 *		0 (Raw (uncompressed) encoding),
 *		1 (compress(1) encoding),
 *		2 (RLE encoding),
 *		3 (Transform encoding),
 *		4 (CCITT encoding),
 *		5 (ADPCM encoding),
 *		or 6 (Generic (site local) encoding)
 *		   [default = 0] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        struct xvimage *image,*readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);
        image = readimage(vencode->i_file);
        if (image == NULL) exit(1);
/* -main_before_lib_call_end */

/* -main_library_call */
        image->data_encode_scheme = vencode->s_toggle;
/* -main_library_call_end */

/* -main_after_lib_call */
        writeimage(vencode->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vencode 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vencode :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tChange the data encoding scheme of an image\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
fprintf(stderr,"The allowable values that can be supplied to the -s argument are:\n");
fprintf(stderr," 0      VFF_DES_RAW       - no encoding\n");
fprintf(stderr," 1      VFF_DES_COMPRESS  - compress data using compress(1)\n");
fprintf(stderr," 2      VFF_DES_RLE       - run length encoding\n");
fprintf(stderr," 3      VFF_DES_TRANSFORM - encoding using transform coeffs\n");
fprintf(stderr," 4      VFF_DES_CCITT     - encoding using CCITT standard\n");
fprintf(stderr," 5      VFF_DES_ADPCM     - encoding using adaptive PCM\n");
fprintf(stderr," 6      VFF_DES_GENERIC   - site specific encoding\n\n");
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-s]  Encoding scheme\n");
	fprintf(stderr, "\t\t0  (Raw (uncompressed) encoding),\n");
	fprintf(stderr, "\t\t1  (compress(1) encoding),\n");
	fprintf(stderr, "\t\t2  (RLE encoding),\n");
	fprintf(stderr, "\t\t3  (Transform encoding),\n");
	fprintf(stderr, "\t\t4  (CCITT encoding),\n");
	fprintf(stderr, "\t\t5  (ADPCM encoding),\n");
	fprintf(stderr, "\t\tor 6  (Generic (site local) encoding)\n");
	fprintf(stderr, "\t\t[default = 0]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vencode\n");
	fprintf(stderr, "\t[-U] Gives the usage for vencode\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vencode.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vencode.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vencode
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image \n        {outfile}: "; 
char	*s_pstr = "\nEnter: (s) Encoding scheme -- \n      \t\t0 (Raw (uncompressed) encoding)\n\t\t1 (compress(1) encoding)\n\t\t2 (RLE encoding)\n\t\t3 (Transform encoding)\n\t\t4 (CCITT encoding)\n\t\t5 (ADPCM encoding)\n\t\tor 6 (Generic (site local) encoding)\n  [0]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vencode", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vencode.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vencode: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vencode.ans");
		}

	     }

	}

	/*
	 * allocate the vencode structure
	 */
	vencode = (vencode_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vencode_struct));

	/*
	 * get required arguments for vencode
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vencode->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vencode->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vencode->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vencode->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vencode->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vencode->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vencode->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vencode->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vencode->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vencode->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


	/*
	 * get optional toggles for vencode
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		vencode->s_flag = vget_int(fid, prompt_flag,
		"-s", s_pstr, &(vencode->s_toggle),
		0, 0, 0);

		if ((vencode->s_toggle == 0 ) || 
		    (vencode->s_toggle == 1 ) || 
		    (vencode->s_toggle == 2 ) || 
		    (vencode->s_toggle == 3 ) || 
		    (vencode->s_toggle == 4 ) || 
		    (vencode->s_toggle == 5 ) || 
		    (vencode->s_toggle == 6 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		vencode->s_flag = vget_int(fid, prompt_flag,
		"-s", s_pstr, &(vencode->s_toggle),
		0, 0, 0);

		if ((vencode->s_toggle != 0 ) && 
		    (vencode->s_toggle != 1 ) && 
		    (vencode->s_toggle != 2 ) && 
		    (vencode->s_toggle != 3 ) && 
		    (vencode->s_toggle != 4 ) && 
		    (vencode->s_toggle != 5 ) && 
		    (vencode->s_toggle != 6 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



