 /*
  * Khoros: $Id: vcrgbhsv.h,v 1.1 1991/05/10 15:46:36 khoros Exp $
  */

 /*
  * $Log: vcrgbhsv.h,v $
 * Revision 1.1  1991/05/10  15:46:36  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vcrgbhsv.h
 >>>>            Author: Tom Sauer
 >>>> Date Last Updated: Tue Mar  5 22:22:10 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vcrgbhsv_h_
#define _vcrgbhsv_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vcrgbhsv Argument Structure
*
****************************************************************/

typedef struct _vcrgbhsv  {

/*
 *  input image filename (Required infile)
 */
char	*i_file;	/* input image filename FILENAME */
int	 i_flag;	/* input image filename FLAG */

/*
 *  output image filename (Required outfile)
 */
char	*o_file;	/* output image filename FILENAME */
int	 o_flag;	/* output image filename FLAG */

/*
 *  normalization factor (Optional float)
 */
float	 n_float;	/* normalization factor FLOAT */
int	 n_flag;   	/* normalization factor FLAG */

/*
 *  Convert (RGB to HSV) [True] or (HSV to RGB) [False] (Optional logical)
 */
int	 h_logic;	/* Convert (RGB to HSV) [True] or (HSV to RGB) [False] LOGIC */
int	 h_flag;  	/* Convert (RGB to HSV) [True] or (HSV to RGB) [False] FLAG */

}  vcrgbhsv_struct;

vcrgbhsv_struct *vcrgbhsv;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT(img1) \
img1 = readimage(vcrgbhsv->i_file); \
if (img1 == NULL) { \
   (void) fprintf(stderr, "vcrgbhsv: Can not read input image 1\\n"); \
   exit(1);  /* Quit if bad image */ \
}

#define CHECKINPUT(program, img1) \
    propertype(program,img1,VFF_TYP_FLOAT,TRUE); \
    proper_num_images(program,img1,1,TRUE); \
    proper_num_bands(program,img1,3,TRUE); \
    proper_map_enable(program,img1,VFF_MAP_OPTIONAL,TRUE);

#define CHECKMODEL(program, img1,vcrgbhsv) \
    if (vcrgbhsv->h_logic == 1)  { \
        if (! (proper_color_model(program,img1,VFF_CM_ntscRGB,FALSE)) && \
           (! (proper_color_model(program,img1,VFF_CM_genericRGB,FALSE)))) { \
           (void)fprintf(stderr,"vcrgbhsv: input image must be "); \
           (void)fprintf(stderr,"either genericRGB or ntscRGB\\n"); \
            exit(1); \
         } \
    } \
    else \
        proper_color_model(program,img1,VFF_CM_HSV,TRUE);
/* -include_macros_end */

#endif
