 /*
  * Khoros: $Id: lvdiv.c,v 1.2 1991/12/18 09:21:44 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvdiv.c,v 1.2 1991/12/18 09:21:44 dkhoros Exp $";
#endif

 /*
  * $Log: lvdiv.c,v $
 * Revision 1.2  1991/12/18  09:21:44  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvdiv.c
 >>>>
 >>>>      Program Name: vdiv
 >>>>
 >>>> Date Last Updated: Sat Nov 23 23:50:44 1991 
 >>>>
 >>>>          Routines: lvdiv - the library call for vdiv
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvdiv - library call for vdiv
*
* Purpose:
*    
*    Divide two images pixel by pixel.
*    
*    

* Input:
*    
*         1. img1 -- first xvimage strcuture
*         2. img2 -- second xvimage structure
*         3. img3 -- gating mask image
*         4. mflg -- a flag set (equal 1) if gating image
*                    mask is available
*         5. jflg -- 0 means do scalar arithmetic
*                    1 means do vector arithmetic
*    
*         The inputs must be of the same data type and size.
*    
*    

* Output:
*    
*         1. img1 -- holds the result of the divide
*                    operation.  The output data
*                    type is the same as the input data
*                    type.
*    
*         img1 is used for both the input xvimage  structure  and  the
*         output  result  xvimage  structure.   This  is  done to save
*         space, but you must be careful not  to  overwrite  important
*         data.
*    
*         lvdiv returns a one on success and a zero upon failure.
*    
*         lvdiv does NOT check for division by zero!
*    
*    

*
* Written By: Scott Wilson
*    
*    Marcelo Teran, John Rasure, Tom Sauer
*    28-Dec-89 Added  scalar/vector  complex  arithmetic  switch.
*    Scott Wilson
*    28-Dec-89 Upgrade to multiband. Scott Wilson
*    25-Feb-91 Ugrade to handle double and double complex images.
*    Jeremy Worley
*    23-Nov-91 Fixed bogus pointer arithmetic for  COMPLEX  case.
*    Scott Wilson
*    
*    

****************************************************************/


/* -library_def */
int
lvdiv(img1,img2,img3,mflg,jflg)
struct xvimage *img1,*img2,*img3;
int   mflg,jflg;
/* -library_def_end */

/* -library_code */
{
    int    j,k;
    int    *i1,*i2,*i3,*i4;
    short  *s1,*s2,*s3,*s4;
    float  *f1,*f2,*f3,*f4;
    double *d1,*d2,*d3,*d4,denom;
    unsigned char *c1,*c2,*c3,*c4;

    switch (img1->data_storage_type)
      {
        case VFF_TYP_BIT :
          fprintf(stderr,"lvdiv: Don't know how to divide BIT images\n");
          return(0);
          break;
        case VFF_TYP_1_BYTE : 
          k = img1->row_size*img1->col_size*img1->num_data_bands;
          c1 = (unsigned char *)(img1->imagedata);
          c2 = (unsigned char *)(img2->imagedata);
          c3 = (unsigned char *)(img1->imagedata);
          if (mflg) c4 = (unsigned char *)(img3->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++) *c3++ = *c1++ / *c2++;
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*c4++) *c3++ = *c1++ / *c2++;
                  else
                    {
                      c1++; c2++; c3++;
                    }
                }
            }
          break;
        case VFF_TYP_2_BYTE :
          k = img1->row_size*img1->col_size*img1->num_data_bands;
          s1 = (short *)(img1->imagedata);
          s2 = (short *)(img2->imagedata);
          s3 = (short *)(img1->imagedata);
          if (mflg) s4 = (short *)(img3->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++) *s3++ = *s1++ / *s2++;
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*s4++) *s3++ = *s1++ / *s2++;
                  else
                    {
                      s1++; s2++; s3++;
                    }
                }
            }
          break;
        case VFF_TYP_4_BYTE :
          k = img1->row_size*img1->col_size*img1->num_data_bands;
          i1 = (int *)(img1->imagedata);
          i2 = (int *)(img2->imagedata);
          i3 = (int *)(img1->imagedata);
          if (mflg) i4 = (int *)(img3->imagedata); if (!mflg) { for (j=0; j<k; j++) *i3++ = *i1++ / *i2++; } else {
              for (j=0; j<k; j++)
                {
                  if (*i4++) *i3++ = *i1++ / *i2++;
                  else
                    {
                      i1++; i2++; i3++;
                    }
                }
            }
          break;
        case VFF_TYP_FLOAT :
          k = img1->row_size*img1->col_size*img1->num_data_bands;
          f1 = (float *)(img1->imagedata);
          f2 = (float *)(img2->imagedata);
          f3 = (float *)(img1->imagedata);
          if (mflg) f4 = (float *)(img3->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++) *f3++ = *f1++ / *f2++;
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*f4++) *f3++ = *f1++ / *f2++;
                  else
                    {
                      f1++; f2++; f3++;
                    }
                }
            }
          break;
        case VFF_TYP_COMPLEX :
          k = img1->row_size*img1->col_size*img1->num_data_bands;

          f1 = (float *)(img1->imagedata);
          f2 = (float *)(img2->imagedata);
          f3 = (float *)(img1->imagedata);
          if (mflg) f4 = (float *)(img3->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++)
                {
                  if (jflg) cdiv(f3,f3+1,*f1,*(f1+1),*f2,*(f2+1));
                  else
                    {
                      *f3 = *f1 / *f2;
                      *(f3+1) = *(f1+1) / *(f2+1);
                    }
                  f1 += 2; f2 += 2; f3 += 2;
                }
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*f4++)
                    {
                      if (jflg) cdiv(f3,f3+1,*f1,*(f1+1),*f2,*(f2+1));
                      else
                        {
                          *f3 = *f1 / *f2;
                          *(f3+1) = *(f1+1) / *(f2+1);
                        }
                      f1 += 2; f2 +=2; f3 +=2;
                    }
                  else 
                    {
                      f1 += 2; f2 += 2; f3 += 2;
                    }
                  f4++; /* Skip to next real part! */
                }
            }
          break;
        case VFF_TYP_DOUBLE :
          k = img1->row_size*img1->col_size*img1->num_data_bands;
          d1 = (double *)(img1->imagedata);
          d2 = (double *)(img2->imagedata);
          d3 = (double *)(img1->imagedata);
          if (mflg) d4 = (double *)(img3->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++) *d3++ = *d1++ / *d2++;
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*d4++) *d3++ = *d1++ / *d2++;
                  else
                    {
                      d1++; d2++; d3++;
                    }
                }
            }
          break;
        case VFF_TYP_DCOMPLEX :
          k = img1->row_size*img1->col_size*img1->num_data_bands;

          d1 = (double *)(img1->imagedata);
          d2 = (double *)(img2->imagedata);
          d3 = (double *)(img1->imagedata);
          if (mflg) d4 = (double *)(img3->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++)
                {
                  if (jflg){
                     denom = *d2 * *d2 + *(d2+1) * *(d2+1);
                     *d3 = (*d1 * *d2 - *(d1+1) * *(d2+1))/denom;
                     *(d3+1) = (*d1 * *(d2+1) - *(d1+1) * *d2)/denom;
                  }else{
                      *d3 = *d1 / *d2;
                      *(d3+1) = *(d1+1) / *(d2+1);
                  }
                  d1 += 2; d2 += 2; d3 += 2;
                }
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*d4++)
                    {
                      if (jflg) cdiv(d3,d3+1,*d1,*d1+1,*d2,*d2+1);
                      else
                        {
                          *d3 = *d1 / *d2;
                          *(d3+1) = *(d1+1) / *(d2+1);
                        }
                      d1 += 2; d2 +=2; d3 +=2;
                    }
                  else 
                    {
                      d1 += 2; d2 += 2; d3 += 2;
                    }
                  d4++; /* Skip to next real part! */
                }
            }
          break;
        default:
          fprintf(stderr,"lvdiv: Unknown data storage type, %d\n",img1->data_storage_type);
          return(0);
          break;
      }
      return(1);

}
/* -library_code_end */
