 /*
  * Khoros: $Id: vslope.c,v 1.1 1991/05/10 15:51:51 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vslope.c,v 1.1 1991/05/10 15:51:51 khoros Exp $";
#endif

 /*
  * $Log: vslope.c,v $
 * Revision 1.1  1991/05/10  15:51:51  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vslope.c
 >>>>
 >>>>      Program Name: vslope
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Compute slope and aspect images from elevation data.
 >>>>	
 >>>>	
 >>>>            Author: Per Lysne
 >>>>
 >>>> Date Last Updated: Thu Mar  7 15:34:11 1991
 >>>>
 >>>>          Routines: main- the main program for vslope
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vslope.h"


/****************************************************************
 *
 * Routine Name:  main program for vslope
 *
 *       Input:  
 *        -i  input image 
 *
 *
 *        [-s] slope image
 *        [-t] aspect image
 *        [-z] Value for Regions With no Aspect (flat) 
 *        [-so] slope options
 *		0 (Output Slope in Degrees),
 *		1 (Output Slope in Radians),
 *		or 2 (Output Slope in Percent Rise)
 *		   [default = 0] 
 *        [-to] aspect options
 *		0 (Output Aspect in Degrees),
 *		1 (Output Aspect in Radians),
 *		or 2 (Output Aspect in Quadrants)
 *		   [default = 0] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *img1, *img2, *img3;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);

    img1 = readimage(vslope->i_file);
    if (img1 == NULL) {
        fprintf (stderr, "error in vslope: could not read image from %s\n",
                 vslope->i_file);
        exit (1);
    }
                    
    CHECKINPUT (program, img1);
        
    if (img1->data_storage_type != VFF_TYP_FLOAT) {
        if (!lvconvert (img1, VFF_TYP_FLOAT, 0, 1, 0.0, 1.0, 0)) {
            fprintf (stderr, "error in vslope: call to lvconvert failed\n");
            exit (1);
        }
    }
/* -main_before_lib_call_end */

/* -main_library_call */
    if(!lvslope(img1,
                vslope->s_flag, vslope->so_toggle,
                vslope->t_flag, vslope->to_toggle,
                vslope->z_float,
                &img2, &img3)) {
        fprintf(stderr, "error in vslope: call to lvslope failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    if (vslope->s_flag) {
        if (!writeimage (vslope->s_file, img2)) {
            fprintf (stderr,"error in vslope: could not write slope image to");
            fprintf (stderr, " %s\n", vslope->s_file);
            exit (1);
        }
    }

    if (vslope->t_flag) {
        if (!writeimage(vslope->t_file, img3)) {
            fprintf (stderr,"error in vslope: could not write aspect image to");
            fprintf (stderr, " %s\n", vslope->t_file);
            exit (1);
        }
    }
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vslope 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vslope :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCompute slope and aspect images from elevation data.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-s]  slope image (outfile) [null]\n");
	fprintf(stderr,"\t[-t]  aspect image (outfile) [null]\n");
	fprintf(stderr,"\t[-z]  Value for Regions With no Aspect (flat) (float) [0]\n");
	fprintf(stderr, "\t[-so]  slope options\n");
	fprintf(stderr, "\t\t0  (Output Slope in Degrees),\n");
	fprintf(stderr, "\t\t1  (Output Slope in Radians),\n");
	fprintf(stderr, "\t\tor 2  (Output Slope in Percent Rise)\n");
	fprintf(stderr, "\t\t[default = 0]\n");
	fprintf(stderr, "\n");	fprintf(stderr, "\t[-to]  aspect options\n");
	fprintf(stderr, "\t\t0  (Output Aspect in Degrees),\n");
	fprintf(stderr, "\t\t1  (Output Aspect in Radians),\n");
	fprintf(stderr, "\t\tor 2  (Output Aspect in Quadrants)\n");
	fprintf(stderr, "\t\t[default = 0]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vslope\n");
	fprintf(stderr, "\t[-U] Gives the usage for vslope\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vslope.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vslope.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vslope
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*s_pstr = 
	"\nEnter: (s) slope image \n        {outfile}: "; 
char	*t_pstr = 
	"\nEnter: (t) aspect image \n        {outfile}: "; 
char	*z_pstr = 
	"\nEnter: (z) Value for Regions With no Aspect (flat) \n        {float [0.000000] }: "; 
char	*so_pstr = "\nEnter: (so) slope options -- \n      \t\t0 (Output Slope in Degrees)\n\t\t1 (Output Slope in Radians)\n\t\tor 2 (Output Slope in Percent Rise)\n  [0]:  "; 
char	*to_pstr = "\nEnter: (to) aspect options -- \n      \t\t0 (Output Aspect in Degrees)\n\t\t1 (Output Aspect in Radians)\n\t\tor 2 (Output Aspect in Quadrants)\n  [0]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vslope", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vslope.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vslope: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vslope.ans");
		}

	     }

	}

	/*
	 * allocate the vslope structure
	 */
	vslope = (vslope_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vslope_struct));

	/*
	 * get required arguments for vslope
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vslope->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vslope->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vslope->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vslope->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vslope->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vslope
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vslope->s_flag = vget_outfile(fid, prompt_flag,
	"-s", s_pstr, &(vslope->s_file))
;

	vslope->t_flag = vget_outfile(fid, prompt_flag,
	"-t", t_pstr, &(vslope->t_file))
;

	vslope->z_flag = vget_float(fid, prompt_flag,
	"-z", z_pstr, &(vslope->z_float),
	0.000000, 0.000000, 0.000000);


	/*
	 * get optional toggles for vslope
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		vslope->so_flag = vget_int(fid, prompt_flag,
		"-so", so_pstr, &(vslope->so_toggle),
		0, 0, 0);

		if ((vslope->so_toggle == 0 ) || 
		    (vslope->so_toggle == 1 ) || 
		    (vslope->so_toggle == 2 ))
		      ok = TRUE;
		else
		{
		}
	    }
	    ok = FALSE;
	    while(!ok)
	    {
		vslope->to_flag = vget_int(fid, prompt_flag,
		"-to", to_pstr, &(vslope->to_toggle),
		0, 0, 0);

		if ((vslope->to_toggle == 0 ) || 
		    (vslope->to_toggle == 1 ) || 
		    (vslope->to_toggle == 2 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		vslope->so_flag = vget_int(fid, prompt_flag,
		"-so", so_pstr, &(vslope->so_toggle),
		0, 0, 0);

		if ((vslope->so_toggle != 0 ) && 
		    (vslope->so_toggle != 1 ) && 
		    (vslope->so_toggle != 2 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
		vslope->to_flag = vget_int(fid, prompt_flag,
		"-to", to_pstr, &(vslope->to_toggle),
		0, 0, 0);

		if ((vslope->to_toggle != 0 ) && 
		    (vslope->to_toggle != 1 ) && 
		    (vslope->to_toggle != 2 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



