 /*
  * Khoros: $Id: asc2viff.c,v 1.1 1991/05/10 15:52:29 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: asc2viff.c,v 1.1 1991/05/10 15:52:29 khoros Exp $";
#endif

 /*
  * $Log: asc2viff.c,v $
 * Revision 1.1  1991/05/10  15:52:29  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: asc2viff.c
 >>>>
 >>>>      Program Name: asc2viff
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Transforms ASCII data into a VIFF file format.
 >>>>	
 >>>>	
 >>>>            Author: Ramiro Jordan, Mike Lang, Mark Young
 >>>>
 >>>> Date Last Updated: Wed Mar 27 18:34:11 1991
 >>>>
 >>>>          Routines: main- the main program for asc2viff
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "asc2viff.h"


/****************************************************************
 *
 * Routine Name:  main program for asc2viff
 *
 *       Input:  
 *          -i  input ascii data file 
 *          -o  resulting output image (viff file) 
 *          -r  number of rows   (value >= 0)
 *          -c  number of columns   (value >= 0)
 *
 *
 *          [-fi] if yes the ascii input file is supposed to be interleaved; if no (default) it is considered as not interleaved
 *          [-t] if no (default), the data are supposed real, if yes, the data should be defined as a complex pair in the ascii file
 *          [-m] increment factor for skipping rows  (value >= 0)
 *          [-n] increment factor for skipping columns  (value >= 0)
 *          [-b] specify the number of data bands (image)  (value > 0)
 *          [-d] specify the number of location bands (dimensions)  (value >= 0)
 *          [-h] number of points to offset from the start of the data file  (value >= 0)
 *          [-s] number of points to offset from the first point of each band  (value >= 0)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image;
int     start, offset, row_inc, col_inc, numbands, dimensions;
int     interleave, complex, nrows, ncols;
char    *malloc();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
start = asc2viff->s_int;
offset = asc2viff->h_int;
row_inc = asc2viff->m_int;
col_inc = asc2viff->n_int;
numbands = asc2viff->b_int;
dimensions = asc2viff->d_int;
interleave = asc2viff->fi_logic;
complex = asc2viff->t_logic;
nrows = asc2viff->r_int;
ncols = asc2viff->c_int;
/* -main_before_lib_call_end */

/* -main_library_call */
if(! lasc2viff(asc2viff->i_file,
                 &image, 
                 nrows, 
                 ncols, 
                 offset, 
                 start, 
                 row_inc,
                 col_inc,
                 numbands,
                 dimensions, 
                 interleave, 
                 complex))
{
    (void) fprintf(stderr, "lasc2viff Failed\n");
    exit(1);
}

/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(asc2viff->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for asc2viff 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "asc2viff :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tTransforms ASCII data into a VIFF file format.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input ascii data file  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image (viff file)  (outfile)\n");
	fprintf(stderr,"\t-r  number of rows  (integer, >= 0)\n");
	fprintf(stderr,"\t-c  number of columns  (integer, >= 0)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-fi]  if yes the ascii input file is supposed to be interleaved; if no (default) it is considered as not interleaved (boolean) [false]\n");
	fprintf(stderr,"\t[-t]  if no (default), the data are supposed real, if yes, the data should be defined as a complex pair in the ascii file (boolean) [false]\n");
	fprintf(stderr,"\t[-m]  increment factor for skipping rows (integer, >= 0) [1]\n");
	fprintf(stderr,"\t[-n]  increment factor for skipping columns (integer, >= 0) [1]\n");
	fprintf(stderr,"\t[-b]  specify the number of data bands (image) (integer, > 0) [1]\n");
	fprintf(stderr,"\t[-d]  specify the number of location bands (dimensions) (integer, >= 0) [0]\n");
	fprintf(stderr,"\t[-h]  number of points to offset from the start of the data file (integer, >= 0) [0]\n");
	fprintf(stderr,"\t[-s]  number of points to offset from the first point of each band (integer, >= 0) [0]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for asc2viff\n");
	fprintf(stderr, "\t[-U] Gives the usage for asc2viff\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called asc2viff.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses asc2viff.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for asc2viff
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input ascii data file \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image (viff file) \n        {outfile}: "; 
char	*r_pstr = 
	"\nEnter: (r) number of rows \n        {integer, >= 0}: "; 
char	*c_pstr = 
	"\nEnter: (c) number of columns \n        {integer, >= 0}: "; 
char	*fi_pstr = 
	"\nEnter: (fi) if yes the ascii input file is supposed to be interleaved; if no (default) it is considered as not interleaved \n        {boolean, (y/n)  [no] }: "; 
char	*t_pstr = 
	"\nEnter: (t) if no (default), the data are supposed real, if yes, the data should be defined as a complex pair in the ascii file \n        {boolean, (y/n)  [no] }: "; 
char	*m_pstr = 
	"\nEnter: (m) increment factor for skipping rows \n        {integer, >= 0 [1] }: "; 
char	*n_pstr = 
	"\nEnter: (n) increment factor for skipping columns \n        {integer, >= 0 [1] }: "; 
char	*b_pstr = 
	"\nEnter: (b) specify the number of data bands (image) \n        {integer, > 0 [1] }: "; 
char	*d_pstr = 
	"\nEnter: (d) specify the number of location bands (dimensions) \n        {integer, >= 0 [0] }: "; 
char	*h_pstr = 
	"\nEnter: (h) number of points to offset from the start of the data file \n        {integer, >= 0 [0] }: "; 
char	*s_pstr = 
	"\nEnter: (s) number of points to offset from the first point of each band \n        {integer, >= 0 [0] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "asc2viff", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "asc2viff.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "asc2viff: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "asc2viff.ans");
		}

	     }

	}

	/*
	 * allocate the asc2viff structure
	 */
	asc2viff = (asc2viff_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (asc2viff_struct));

	/*
	 * get required arguments for asc2viff
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(asc2viff->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(asc2viff->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(asc2viff->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    asc2viff->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(asc2viff->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(asc2viff->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(asc2viff->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(asc2viff->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    asc2viff->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(asc2viff->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(asc2viff->r_flag = vget_int(fid, prompt_flag,
			"-r", r_pstr, &(asc2viff->r_int),
			512, 1, 1)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(asc2viff->r_flag))
		{
		    fprintf(stderr, "\t\tr is required, please re-enter: \n");
		    asc2viff->r_flag = vget_int(fid, prompt_flag,
		    "-r", r_pstr, &(asc2viff->r_int),
		    512, 1, 1);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-r' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(asc2viff->c_flag = vget_int(fid, prompt_flag,
			"-c", c_pstr, &(asc2viff->c_int),
			512, 1, 1)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(asc2viff->c_flag))
		{
		    fprintf(stderr, "\t\tc is required, please re-enter: \n");
		    asc2viff->c_flag = vget_int(fid, prompt_flag,
		    "-c", c_pstr, &(asc2viff->c_int),
		    512, 1, 1);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-c' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for asc2viff
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	asc2viff->fi_flag = vget_logic(fid, prompt_flag,
	"-fi", fi_pstr, &(asc2viff->fi_logic), 0);

	asc2viff->t_flag = vget_logic(fid, prompt_flag,
	"-t", t_pstr, &(asc2viff->t_logic), 0);

	asc2viff->m_flag = vget_int(fid, prompt_flag,
	"-m", m_pstr, &(asc2viff->m_int),
	1, 1, 1);

	asc2viff->n_flag = vget_int(fid, prompt_flag,
	"-n", n_pstr, &(asc2viff->n_int),
	1, 1, 1);

	asc2viff->b_flag = vget_int(fid, prompt_flag,
	"-b", b_pstr, &(asc2viff->b_int),
	1, 2, 2);

	asc2viff->d_flag = vget_int(fid, prompt_flag,
	"-d", d_pstr, &(asc2viff->d_int),
	0, 1, 1);

	asc2viff->h_flag = vget_int(fid, prompt_flag,
	"-h", h_pstr, &(asc2viff->h_int),
	0, 1, 1);

	asc2viff->s_flag = vget_int(fid, prompt_flag,
	"-s", s_pstr, &(asc2viff->s_int),
	0, 1, 1);


}



