 /*
  * Khoros: $Id: dwindow.h,v 1.2 1992/03/20 23:35:03 dkhoros Exp $
  */

 /*
  * $Log: dwindow.h,v $
 * Revision 1.2  1992/03/20  23:35:03  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dwindow.h
 >>>>            Author: Ramiro Jordan, Glen Abousleman
 >>>> Date Last Updated: Sat Feb 15 16:37:01 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _dwindow_h_
#define _dwindow_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    dwindow Argument Structure
*
****************************************************************/

typedef struct _dwindow  {

/*
 *  input data file (xviff file) (Required infile)
 */
char	*i_file;	/* input data file (xviff file) FILENAME */
int	 i_flag;	/* input data file (xviff file) FLAG */

/*
 *  resulting output file (xviff file) (Required outfile)
 */
char	*o_file;	/* resulting output file (xviff file) FILENAME */
int	 o_flag;	/* resulting output file (xviff file) FLAG */

/*
 *  desired THETA parameter for Kaiser window (Optional float)
 */
float	 k_float;	/* desired THETA parameter for Kaiser window FLOAT */
int	 k_flag;   	/* desired THETA parameter for Kaiser window FLAG */

/*
 *  desired damping parameter for Exponential window (Optional float)
 */
float	 e_float;	/* desired damping parameter for Exponential window FLOAT */
int	 e_flag;   	/* desired damping parameter for Exponential window FLAG */

/*
 *  desired window width for User defined window (Optional integer)
 */
int	 b_int; 	/* desired window width for User defined window INT */
int	 b_flag;	/* desired window width for User defined window FLAG */

/*
 *  data processing direction (0 = down vectors, 1 = across bands) (Optional logical)
 */
int	 d_logic;	/* data processing direction (0 = down vectors, 1 = across bands) LOGIC */
int	 d_flag;  	/* data processing direction (0 = down vectors, 1 = across bands) FLAG */

/*
 * windowed output file to be created (Optional integer toggle - )
 */
int	 w_toggle;		/* windowed output file to be created INT TOGGLE */
int	 w_flag;		/* windowed output file to be created FLAG */

}  dwindow_struct;

dwindow_struct *dwindow;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READIMAGE(image) \
image = readimage(dwindow->i_file);  \
if (image == NULL) {  \
   (void) fprintf(stderr, "dwindow: Can not read input image \n");  \
   exit(1);  /* Quit if bad image */ \
}

#define CHECKTYPE(program, image) \
    if( ! (propertype(program,image,VFF_TYP_FLOAT,FALSE)) && \
        ! (propertype(program,image,VFF_TYP_COMPLEX,FALSE)) &&\
        ! (propertype(program,image,VFF_TYP_4_BYTE,FALSE)) ) { \
          fprintf(stderr,"%s: data storage type must be integer, float or complex.",program); \
          exit(1); \
    }

#define CHECKINPUT(program, image) \
    proper_num_images(program,image,1,TRUE);  \
    proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE);
/* -include_macros_end */

#endif
