 /*
  * Khoros: $Id: dinsert.h,v 1.2 1992/03/20 23:34:14 dkhoros Exp $
  */

 /*
  * $Log: dinsert.h,v $
 * Revision 1.2  1992/03/20  23:34:14  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dinsert.h
 >>>>            Author: Donna Koechner
 >>>> Date Last Updated: Sat Feb 15 16:34:50 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _dinsert_h_
#define _dinsert_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    dinsert Argument Structure
*
****************************************************************/

typedef struct _dinsert  {

/*
 *  input image (Required infile)
 */
char	*i1_file;	/* input image FILENAME */
int	 i1_flag;	/* input image FLAG */

/*
 *  input image (Required infile)
 */
char	*i2_file;	/* input image FILENAME */
int	 i2_flag;	/* input image FLAG */

/*
 *  resulting output image (Required outfile)
 */
char	*o_file;	/* resulting output image FILENAME */
int	 o_flag;	/* resulting output image FLAG */

/*
 *  data processing direction (0 = down vectors, 1 = across bands) (Optional logical)
 */
int	 d_logic;	/* data processing direction (0 = down vectors, 1 = across bands) LOGIC */
int	 d_flag;  	/* data processing direction (0 = down vectors, 1 = across bands) FLAG */

/*----  these are an Optional mutually exclusive group ----*/
/*
 *  Append i2 to the end of i1 (Required logical)
 */
int	 e_logic;	/* Append i2 to the end of i1 LOGIC */
int	 e_flag;  	/* Append i2 to the end of i1 FLAG */

/*
 *  Starting point where i2 is inserted into i1 (Required integer)
 */
int	 x_int; 	/* Starting point where i2 is inserted into i1 INT */
int	 x_flag;	/* Starting point where i2 is inserted into i1 FLAG */

/*
 *  File which contains insert point for each vector (Required infile)
 */
char	*i3_file;	/* File which contains insert point for each vector FILENAME */
int	 i3_flag;	/* File which contains insert point for each vector FLAG */

/*-------------------------------------------*/

}  dinsert_struct;

dinsert_struct *dinsert;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT1(img1) \
    img1 = readimage(dinsert->i1_file); \
    if(img1 == NULL){ \
        (void) fprintf(stderr,"dinsert: Image could not be read\n"); \
        exit(1); \
    }

#define READINPUT2(img2) \
    img2 = readimage(dinsert->i2_file); \
    if(img2 == NULL){ \
        (void) fprintf(stderr,"dinsert: Image could not be read\n"); \
        exit(1); \
    }

#define CHECKTYPE(program, img1) \
    if( ! (propertype(program,img1,VFF_TYP_FLOAT,FALSE)) && \
        ! (propertype(program,img1,VFF_TYP_COMPLEX,FALSE)) ) { \
          fprintf(stderr,"dinsert: data storage type must be float or complex.\n"); \
          exit(1); \
    }


#define CHECKINPUT(program, img1, img2) \
        (void) proper_num_images(program,img1,1,TRUE); \
        (void) match_num_images(program,img1,img2,TRUE); \
        \
        (void) matchtype(program,img1,img2,TRUE); \
        \
        (void) proper_dim(program,img1,0,TRUE); \
        (void) match_dim(program,img1,img2,TRUE); \
        \
        (void) proper_loc_type(program,img1,VFF_LOC_IMPLICIT,TRUE); \
        (void) match_loc_type(program,img1,img2,TRUE)
/* -include_macros_end */

#endif
