 /*
  * Khoros: $Id: cr_comment.c,v 1.1 1991/05/10 15:41:35 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: cr_comment.c,v 1.1 1991/05/10 15:41:35 khoros Exp $";
#endif

 /*
  * $Log: cr_comment.c,v $
 * Revision 1.1  1991/05/10  15:41:35  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

/*
#
# FILE NAME:	cr_comment.c
# 
# AUTHORS:	Tom Sauer
# 
# DATE:		5/27/89
# 
# DESCRIPTION:	create a new comment field for an image file
# 
# MODIFICATIONS:
# 
*/

/*INCLUDE*/
#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "vinclude.h"	 	

/**************************************************************
*
* MODULE NAME: create_comment
*
*     PURPOSE:	creates a new comment field from the original comment
*		field and the filename comment that it came from.  The
*		"image" field is of size 512, which means we can fit
*		255 characters and 1 end of string character. The
*		routine fits as much of the "filename" into "image"
*		and if there is any left it fills it with the "original"
*		comment field.
*
*  		This code was taken from khoros-libvrgbimage 
*		written by Mark Young, and modified.
*
*       INPUT: 1. filename -- a comment field describing where the new image
*			      came from.
*	       2. original -- the original image's comment field
*
*      OUTPUT: 1. image --  the new image comment field
*
* CALLED FROM: 
*
* ROUTINES CALLED: none
*
**************************************************************/

create_comment(image, filename, original)

char *image, *filename, *original;
{
	int length1, length2;

	/*
	 * Copy the filename comment into the image's comment field.
	 * Make sure the filename comment is not greater than 512,
	 * the size of the comment field.
	 */

	length1 = VStrlen(filename);
	if (length1 >= COMMENTLEN)
	{
	   (void) strncpy(image,filename,COMMENTLEN - 1);
	}
	else
	{
	   (void) strcpy(image, filename);

	   length2 = VStrlen(original);
	   if ((length1 + length2) >= COMMENTLEN)
	   {
	      /*
	       * Compute the amount of the original comment field we can fit 
	       * into the new image's comment field.  The result is stored in
	       * length1, which is really one less than the max since we need
	       * to make room for the end of string character '\0'.
	       */
	      length1 = length2 - ((length1 + length2) - COMMENTLEN - 1);
	      (void) strncat(image, original, length1);
	   }
	   else
	      (void) strcat(image, original);
	}
}
