 /*
  * Khoros: $Id: internals.h,v 1.3 1992/03/20 23:39:23 dkhoros Exp $
  */

 /*
  * $Log: internals.h,v $
 * Revision 1.3  1992/03/20  23:39:23  dkhoros
 * VirtualPatch5
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>								<<<<
   >>>>	    file name: internals.h				<<<<
   >>>>								<<<<
   >>>>   description:						<<<<
   >>>>								<<<<
   >>>> modifications:						<<<<
   >>>>								<<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _internals_h_
#define _internals_h_


#include "vgparm.h"

/*
 *   Definition for kfile structure, used by the internal reading & writing
 *   utilities.  This structure should not be manipulated by the application
 *   programmer but used as the "id" parameter for the public routines listed
 *   below.
 */
struct _kfile
{
	/*
	 *  Initial paramters used with the "open" initialization
	 *  routine.
	 */
	int	  id;		/*  entry id within the kfile table */
	char	  *path;	/*  used to open kfile "identifier=token" */
	int	  flags, mode;  /*  flags & mode used in opening kfile */

	/*
	 *
	 */
	caddr_t	  addr;
	int	  offset;
	int	  size;

	/*
	 *  The "resources" structure is an internal pointer used by each of
	 *  the different transport drivers.  When initiailized the resource
	 *  pointer is used to hold specific information necessary for the
	 *  transport driver.  The different transports are called via the
	 *  "TransportRoutine" structure.
	 */
	char	  *resources;
	struct _transport_info *routines;
};


typedef struct _daemon_info
{
	char    *label;
	char    *identifier;

	int	(*daemon)();
} DaemonInformation;

/*
 *  Internal transport driver routines for opening, closing, reading, writing,
 *  lseeking, etc.   This structure defines the different internal routines
 *  used by the 
 */
typedef struct _remote_transport_info
{
	int	(*exec)();
	int	(*machtype)();
	int	(*gethostname)();
} RemoteInformation;

typedef struct _transport_info
{
	char    *label;
	char    *identifier;
	int     data_permanence;

	int	(*tempnam)();
	int	(*open)();
	int	(*close)();
	int	(*read)();
	int	(*write)();
	int	(*lseek)();
	int	(*tell)();
	int	(*access)();
	int	(*unlink)();
	int	(*lock)();
	int	(*descriptors)();

	RemoteInformation *remote;
} TransportInformation;

/*
 *  internal routines found in distrib_util.c
 */
kfile	*kfile_get_entry();
int	kfile_add_entry();
int	kfile_delete_entry();
int	kfile_closeall_entry();

char	*transport_token();
char	*transport_machine();
char	*transport_location();
char	*transport_identifier();

char	*fopen_flags();
int	int_flags();
TransportInformation *transport_routines();
DaemonInformation *daemon_routines();

int	negotiate_open();
int	negotiate_close();

/*
 *  If the user doesn't specify any convention what is the default transport.
 *  Most likely it should be FILE, but in some cases it may be different
 */
#define DefaultTransport file_routines

/*
 *  If the user doesn't start the remote daemon this program will attempt
 *  to start it.
 */
#define PhantomExec "phantom"

/*
 *  The number of retries to start remote daemon before giving up
 */
#define DaemonRetry 1

/*
 *  define for figuring out the number of transports in the array list
 */
#define	NumTransports	  ((int) sizeof(transports)/sizeof(transports[0]))
#define	NumDaemons	  ((int) sizeof(daemons)/sizeof(daemons[0]))

/*
 *  Check for seeing if a transport
 */
#define NoTransport	0L
#define LocalTransport	(1L << 1)
#define RemoteTransport	(1L << 2)
#define TRANSPORT(trans) ((trans == NULL) ? NoTransport : \
	((trans->remote == NULL) ? LocalTransport : LocalTransport | RemoteTransport))

/*
 *  Default Page Size
 */
#ifdef SYSV
#define DefaultPageSize	4096
#else
#define DefaultPageSize	getpagesize()
#endif

/*
 *  Define the different seek options for lseek() if they are not already
 *  defined.
 */
#ifndef SEEK_SET
#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2
#endif

/*
 *  If O_ACCMODE mode is not defined then go ahead and define it.
 */
#ifndef O_ACCMODE
#define O_ACCMODE       (O_RDONLY|O_WRONLY|O_RDWR)
#endif

#endif /* _internals_h_ */
/* don`t add after the endif */
