 /*
  * Khoros: $Id: getarg_clc.c,v 1.2 1992/03/20 23:39:16 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: getarg_clc.c,v 1.2 1992/03/20 23:39:16 dkhoros Exp $";
#endif

 /*
  * $Log: getarg_clc.c,v $
 * Revision 1.2  1992/03/20  23:39:16  dkhoros
 * VirtualPatch5
 *
  */ 

/******************************************************************

	Get Command Line Argument 

	source filename:			get_arg_clc.c		

	revision	  date			programmer
	--------	  ----			----------
	   0.0		May-05-85		don hush
	   0.1		Sept 3, 1987		John M Salas
	   0.2		May 20, 1990		Mark Young
	   0.3		Feb 28, 1992		Mark Young & Tom Sauer

******************************************************************

	usage
	-----

	stat = get_arg_clc(key,arg,type)

	int stat;
	char *key,type;
	char *arg;

	#include "uio_defs"

	description
	-----------

	  This routine searches the command line for a
	match to the key. Once a match is found the string
	parameter is converted to the proper type according
	to 'type' ('i','f','l', or 's'). If no key is found 
	this routine returns a -1, otherwise it returns a 0.

	0.1 - Modified so that the - symbol can be used as the
	      designation for input/output to be stdin/stdout.
	      In conjunction with uio routines and to keep the
	      UNIX standard.  But, kept the ability to have
	      no input/output file specified.

	0.2 - Got rid of ' ' substitution for '~'.  get_arg_clc
	      when encountering a tilda would replace it with a
	      space.  This was orignally done so that strings could
	      be read as a single word and then converted back
	      to a multi-word text string.

	0.3 - Modified so that the - symbol can be used for all
	      string substitutions.  Before only standard in
	      and standard out substituion could be made (see
	      revision note 0.1).

*****************************************************************/
#include "vgparm.h"

extern int ac;
extern char **av;

int get_arg_clc(key,arg,type)

char *key,type;
char *arg;

{
	int num_args,num,match,len,i,j,err, loop;
	char sarg[MAX_ARG_LEN];
	char temp_sarg[MAX_ARG_LEN];

	num_args = ac;

	match = -1;
	for (num=1;num<num_args;num++)
	{
		if (av[num] != NULL)
		{
		   if ( (match=strcmp(key, av[num]))==0 )
			break;
		}
	}

	if (match == 0)
	{
	    err = 0;
	    num++;

	    if (av[num] != NULL)
	        strcpy(temp_sarg,av[num]);
	    else
	        temp_sarg[0] = '\0';

	    len = strlen(temp_sarg);
	    for (i = 0, j = 0; i <= len; i++)
	    {
/*
 *  Commented out the following code since "~username" was getting substituted
 *  for " username".  The reason why ~ was getting substituted with a space was
 *  so that answer files could contain string like:
 *
 *        this~is~a~test
 *
 *  which then end up as:
 *
 *        this is a test
 *
 *				Mark Young (Sun May 20 15:25:18 MDT 1990)
 *
 *		if (temp_sarg[i] == '^')
 *		   sarg[j++] = ' ';
 */

		if ((temp_sarg[i]=='\\') && (temp_sarg[i+1]=='n'))
		{
		    sarg[j++] = '\n';
		    i++;
		}
		else
		    sarg[j++] = temp_sarg[i];
	    }

	    switch (type)
	    {
		case 'i':
		    if (VStrlen(sarg) == 0)
			return(-2);
		    if (!(isdigit(sarg[0]) || sarg[0] == '-' ||
		          sarg[0] == '+'))
		        return(-2);
		    for (loop = 1; loop < VStrlen(sarg); loop++)
			if (! isdigit(sarg[loop]))
			    return(-2);
		    *(int *) arg = atoi(sarg);

		    av[num - 1] = NULL;
		    av[num] = NULL;
		    break;

		case 'f':
		    if (VStrlen(sarg) == 0)
			return(-2);
		    if (!sscanf(sarg, "%f", (float *)arg) == 1)
			return(-2);

		    av[num - 1] = NULL;
		    av[num] = NULL;
		    break;

		case 'l':
		    *(int *) arg = TRUE;
		    switch (sarg[0])
		    {
			case 'n':
			case 'N':
			case 'f':
			case 'F':
			case '0':
			    *(int *) arg = FALSE;
		    }

		    av[num - 1] = NULL;
		    if (sarg[0] != '\0')
		       av[num] = NULL;
		    break;

		case 's':
/*
    See revision note 0.1 and 0.3.

		    if (sarg[0] == '-' && sarg[1] != '\0')
			arg[0] = '\0';
		    else
*/
		    strcpy(arg, sarg);
		    av[num - 1] = NULL;
		    if (sarg[0] != '\0')
		       av[num] = NULL;
		    break;
	    }
	}
	else
	{
	    err = -1;
	    switch (type) {
		case 'i':
		    *(int *) arg = 0;
		    break;
		case 'f':
		    *(float *) arg = 0.0;
		    break;
		case 'l':
		    *(int *) arg = FALSE;
		    break;
		case 's':
		    arg[0] = '\0';
		    break;
	    }
	}
	return(err);
}
