 /*
  * Khoros: $Id: xvinclude.h,v 1.3 1991/12/18 08:53:36 dkhoros Exp $
  */

 /*
  * $Log: xvinclude.h,v $
 * Revision 1.3  1991/12/18  08:53:36  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 *
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 *
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */
#include "unmcopyright.h"        /* Copyright 1990 by UNM */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                          <<<<
   >>>>      file: xvinclude.h                                   <<<<
   >>>>                                                          <<<<
   >>>>      contains:  all #defines, structures, and global     <<<<
   >>>>                 definitions, routine declarations        <<<<
   >>>>                 and other #includes used by the xvforms  <<<<
   >>>>			and xvutils libraries                    <<<<
   >>>>                                                          <<<<
   >>>>      written by: Danielle Argiro                         <<<<
   >>>>                                                          <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _xvinclude_h_
#define _xvinclude_h_


/*
 *  general system and khoros #includes
 */
#include "vinclude.h"


/*
 *  includes for X Toolkit Calls
 */
#include <X11/Intrinsic.h>
#include <X11/X.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Core.h>
#include <X11/Constraint.h>
#include <X11/Composite.h>


/*
 *  includes for sundry X11 Calls
 */
#include <X11/keysym.h>
#include <X11/cursorfont.h>

/*
 *  includes for Athena Widget calls
 */
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Command.h> 
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/Simple.h>
#include <X11/Xaw/Viewport.h>

/*
 *  true and false 
 */
#ifndef true
#define true  1
#endif

#define false 0


/*
 *   a better strlen, which takes a string and returns 0 if
 *   it is null, the string length otherwise
 *
 *   a better strcpy, will calloc automatically
 *
 */
#define	   xvf_strlen(strng)	((strng == NULL) ? 0 : strlen(strng))
#define	   xvf_strcpy(strng)	(strcpy(calloc((unsigned)1, (unsigned) \
				(xvf_strlen(strng)+1)),strng))
#define xvf_strcat(s1, s2) (strcat(strcpy(malloc(xvf_strlen(s1) + \
                              xvf_strlen(s2) +1), (s1)), (s2)))


/*  
 *  argc and argv needed for creating toplevel widgets
 *  (XtAppCreateShell).  Global because too hard to carry
 *  around to each routine.
 */
char **xvf_av;
int xvf_ac;

/*
 * various and sundry declarations and #defines
 */

#define F_W   8
#define F_H   15

#define MaxLength 512
#define MaxDBSize 512
#define MaxMesg   1024
#define MaxArgs   25

int xvf_def_width, xvf_def_height;
int xvf_font_width, xvf_font_height;

/*
 *  for xvforms, and xvutils:
 *  global display, font, and application context
 */

Display      *xvf_display;
Screen 	     *xvf_screen;
int	     xvf_screen_num;
XFontStruct  *xvf_font;
XtAppContext xvf_app_context;


int  	FORM_DONE;
char   *XVF_FILE_DIR;

/*
 *  various & sundry utilities
 */

char *xvf_cap_first_letter();
char *xvf_lower();

/*
 *  toplevel widgets created by all xvutils routines
 *  are saved here to make journal playback more efficient
 */

typedef struct _xvf_toplevel_list {
	Widget toplevel;
	struct _xvf_toplevel_list *next;
	} xvf_toplevel_list;

xvf_toplevel_list *xvf_toplevels;

/*
 *  Create-Widget routines are utilities used by Create-Selection routines
 *  to actually perform the creation of widgets using the toolkit.
 *  These routines will be found in ~/lib/xvforms/wid_util.c, and are
 *  called by both the xvforms and the xvutils library.  In addition, other
 *  applications may call these convenience routines if desired.
 */
        Widget xvf_create_formback_widget();
        Widget xvf_create_submenu_widget();
        Widget xvf_create_selback_widget();
        Widget xvf_create_button_widget();
        Widget xvf_create_submenu_button_widget();
        Widget xvf_create_optional_button();
        Widget xvf_create_label_widget();
        Widget xvf_create_psuedo_label_widget();
        Widget xvf_create_glyph_widget();
	Widget xvf_create_simple_widget();
        Widget xvf_create_ascii_widget();
        Widget xvf_create_cr_pixmap_widget();
        Widget xvf_create_scroll_widget();
        Widget xvf_create_wksp_widget();

/*
 *  Routines for using a single-selection or multi-selection list widget 
 */
/*
 *  Declaration of routines available through xvutils
 */
int   xvf_warn_wait();
int   xvf_error_wait();
int   xvf_exit_wait();
int   xvf_help_wait();
int   xvf_view_wait();
char *xvf_query_wait();
int   xvf_info();
char *xvf_text_wait();

XawListReturnStruct  *xvf_run_list_wait();
XawListReturnStruct **xvf_run_list_multsel_wait();
char   		     *xvf_run_list();

#endif /* _xvinclude_h_ */
/* Don't add after the endif */
