 /*
  * Khoros: $Id: big.h,v 1.1 1991/05/10 04:13:15 khoros Exp $
  */

 /*
  * $Log: big.h,v $
 * Revision 1.1  1991/05/10  04:13:15  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: big.h                                  <<<<
   >>>>                                                       <<<<
   >>>>      contains: contains defines to Terra-Mar          <<<<
   >>>>                MicroImage file format.		      <<<<
   >>>>                                                       <<<<
   >>>>      written by: Tom Sauer 			      <<<<
   >>>>                                                       <<<<
   >>>>      date: 12/14/89                                   <<<<
   >>>>                                                       <<<<
   >>>>      modifications:				      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _big_h_
#define _big_h_


/*
 *                       
 *	The "big" image file format describes the image format
 *	used by Terra-Mar MicroImage. This format is based on
 *	record sizes of 512.
 *
 *	Record 1 contains all the header information. The remaining records,
 *	beginning with record 2 store image data one scanline at a time
 *	in (BIL) band-interleaved-by-line format for any number of bands. 
 *	Since a scanline has a variable number of pixels depending on 
 *	the original data, each scanline is divided into an appropriate 
 *	number of records (512 pixels per record). If the number of 
 *	pixels per scanline is not evenly divisible by 512, then the 
 *	last record for each line will contain the remainder for 
 *	that line; it will be only partially full. Note, records are 
 *	padded to a length of 512.
 *
 *	The Band-Interleaved-By-Line order means that the first scanline
 *	of the first band is stored first. It is followed by the first
 *	scanline of the second band, third band, fourth band, and so on
 *	up to the last band avaliable. This order then repeats for
 *	the second scanline, the third scanline and so on.
 *
 */

struct big {

	char	reserved1[22];		/* Reserved                      */
	char	data_type;		/* 'L' -> MSS data               */
					/* 'T' -> TM data                */
					/* 'S' -> SPOT data              */
	char	reserved2;              /* Reserved                      */
	short	num_channels;		/* Number of Channels/Bands      */
	short	start_line_num;         /* Starting Line Number          */
	short	start_pixel_num;        /* Starting Pixel Number         */
	short	num_lines;              /* Number of Lines (row size)    */
	short	num_pixels_line;         /* Number of Pixels per Line     */
					/*   (column size)               */
	char	reserved3[2];           /* Reserved                      */
	char	reserved4[2];           /* Reserved                      */
	char	title[80];              /* Title of Image                */
	short	records_line;           /* Records_Per_Line (rounded up) */
        char    reserved5[392];         /* Reserved                      */

	char 	*imagedata;

};

#endif

/* Don't add after the endif */

