 /*
  * Khoros: $Id: lvll2utm.c,v 1.2 1991/07/15 06:05:47 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvll2utm.c,v 1.2 1991/07/15 06:05:47 khoros Exp $";
#endif

 /*
  * $Log: lvll2utm.c,v $
 * Revision 1.2  1991/07/15  06:05:47  khoros
 * HellPatch1
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvll2utm.c
 >>>>
 >>>>      Program Name: vll2utm
 >>>>
 >>>> Date Last Updated: Thu Mar  7 13:32:30 1991 
 >>>>
 >>>>          Routines: lvll2utm - the library call for vll2utm
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
#define CHECKLIBINPUT(program, img) {                                         \
        if (!proper_num_images (program, img, 1, FALSE)) {                    \
            fprintf (stderr, "error in lvll2utm: input image must contain "); \
            fprintf (stderr, "only 1 image\n");                               \
            return (0);                                                       \
        }                                                                     \
        if (!proper_loc_type (program, img, VFF_LOC_EXPLICIT, FALSE)) {       \
            fprintf (stderr, "error in lvll2utm: input image must have ");    \
            fprintf (stderr, "explicit location data\n");                     \
            return (0);                                                       \
        }                                                                     \
}
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvll2utm - library call for vll2utm
*
* Purpose:
*    
*    Convert explicit location data from geographical coordinates
*    to utm.
*    
*    
* Input:
*    
*         1.  img -- a pointer to a struct xvimage.  This pointer
*                    is used for both the input and the output
*                    images.  The location data in the input
*                    image will be replaced by the converted
*                    coordinates in the ouput image, so be
*                    careful not to overwrite important data.
*    
*         2.  s_flag -- a flag that is set to specify that the
*                    input coordinates are given in arc seconds
*                    instead of degrees of latitude and
*                    longitude.
*    
*    
* Output:
*    
*    
*
* Written By: Per Lysne
*    
*    
****************************************************************/


/* -library_def */
int lvll2utm (img, s_flag)
struct xvimage *img;
int s_flag;
/* -library_def_end */

/* -library_code */
{
    char *program = "lvll2utm";
    int rows, cols, index, product, zone;
    float *location, *x_loc_ptr, *y_loc_ptr;
    float *new_location, *new_x_loc_ptr, *new_y_loc_ptr; 
    double x_loc, y_loc, new_x_loc, new_y_loc;

    /*
     * Error check the inputs.
     */
    if (img == NULL) {
        fprintf (stderr, "error in lvll2utm: bad image input\n");
        return (0);
    }
    if ((s_flag != 0) && (s_flag != 1)) {
        fprintf (stderr, "error in lvll2utm: bad s_flag input\n");
        return (0);
    }

    CHECKLIBINPUT (program, img);

    /*
     * Some useful values.
     */
    rows = img->col_size;
    cols = img->row_size;
    location = img->location;
    x_loc_ptr = location;
    y_loc_ptr = &(img->location[rows*cols]);
    
    /*
     * Allocate the space for the new locations after they have been
     * converted to utm.
     */
    new_location = (float *) calloc (2*rows*cols, sizeof(float));
    if (new_location == NULL) {
        fprintf (stderr,"error in lvll2utm: malloc for new locations failed\n");
        return (0);
    }
    new_x_loc_ptr = new_location;
    new_y_loc_ptr = &(new_location[rows*cols]);

    /*
     * Make this call to determine which utm zone the data is in.  We
     * want to force all of the data into the same zone.
     */
    x_loc = (double) x_loc_ptr[0];
    y_loc = (double) y_loc_ptr[0];
    if (!ll_to_utm (x_loc, y_loc, 1, 0, &new_x_loc, &new_y_loc, &zone)) {
        fprintf (stderr, "error in lvll2utm: call to ll_to_utm failed ");
        fprintf (stderr, "for coords: x=%lf, y=%lf\n", x_loc, y_loc);
        return (0);
    }

    /*
     * This loop converts the values.
     */
    product = rows*cols;
    for (index=0; index<product; index++) {
        x_loc = (double) x_loc_ptr[index];
        y_loc = (double) y_loc_ptr[index];

        if (!ll_to_utm (x_loc, y_loc, 1, 1, &new_x_loc, &new_y_loc, &zone)) {
            fprintf (stderr, "error in lvll2utm: call to ll_to_utm failed ");
            fprintf (stderr, "for coords: x=%lf, y=%lf\n", x_loc, y_loc);
            return (0);
        }

        new_x_loc_ptr[index] = (float) new_x_loc;
        new_y_loc_ptr[index] = (float) new_y_loc;

        printf ("index=%d, x=%f, y=%f\n", index,
                 new_x_loc_ptr[index], new_y_loc_ptr[index]);
    }

    /*
     * Replace the old location data with the converted coordinates.
     */
    free (location);
    img->location = new_location;

    return (1);
}
/* -library_code_end */
