/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dct2d.h
 >>>>            Author: Michael Gilge, gilge@icsi.berkeley.edu

        Copyright 1991, Michael Gilge. All rights reserved.
        Distribution and use permitted as provided in the 
        KHOROS copyright as long as this notice is attached
        to the code and its derivatives.
 >>>> Date Last Updated: Mon Apr 22 21:55:28 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _dct2d_h_
#define _dct2d_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    dct2d Argument Structure
*
****************************************************************/

typedef struct _dct2d  {

/*
 *  input image (Required infile)
 */
char	*i_file;	/* input image FILENAME */
int	 i_flag;	/* input image FLAG */

/*
 *  resulting output image (Required outfile)
 */
char	*o_file;	/* resulting output image FILENAME */
int	 o_flag;	/* resulting output image FLAG */

/*
 *  select blocksize 8x8 pixel (0) or 16x16 pixel (1) (Optional logical)
 */
int	 bs_logic;	/* select blocksize 8x8 pixel (0) or 16x16 pixel (1) LOGIC */
int	 bs_flag;  	/* select blocksize 8x8 pixel (0) or 16x16 pixel (1) FLAG */

}  dct2d_struct;

dct2d_struct *dct2d;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define CHECKINPUT(program, img1) \
        proper_num_images(program,img1,1,TRUE); \
        proper_num_bands(program,img1,1,TRUE); \
        if (propertype(program,img1,VFF_TYP_BIT,FALSE) || \
            propertype(program,img1,VFF_TYP_COMPLEX,FALSE) || \
            propertype(program,img1,VFF_TYP_DCOMPLEX,FALSE) || \
            propertype(program,img1,VFF_TYP_DOUBLE,FALSE)) \
        { \
            (void) fprintf(stderr, "Image data type can NOT be \
VFF_TYP_BIT || VFF_TYP_COMPLEX || VFF_TYP_DCOMPLEX || VFF_TYP_DOUBLE\n"); \
            exit(1); \
        } \
        proper_map_enable(program,img1,VFF_MAP_OPTIONAL,TRUE); \
        proper_map_scheme(program,img1,VFF_MS_NONE,TRUE)
/* -include_macros_end */

#endif
