/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: Scfp2viff.c
 >>>>
 >>>>      Program Name: Scfp2viff
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Conversion from GE Signa Magnet floating point complex  data
 >>>>	file to VIFF file.
 >>>>	
 >>>>	
 >>>>            Author: Donna Koechner
 >>>>
 >>>> Date Last Updated: Mon Apr 15 22:24:21 1991
 >>>>
 >>>>          Routines: main- the main program for Scfp2viff
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "Scfp2viff.h"


/****************************************************************
 *
 * Routine Name:  main program for Scfp2viff
 *
 *       Input:  
 *           -i  input Signa cmplx fp data file 
 *
 *
 *           [-o1] complex output image (viff file)
 *           [-o2] real output image filename
 *           [-o3] imaginary output image filename
 *           [-r] number of rows  (value >= 0)
 *           [-c] number of columns  (value >= 0)
 *           [-h] byte offset from the start of the input data file  (value >= 0)
 *           [-b] number of points per voxel (bands)  (value >= 0)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage  *img1, *img2, *img3;
int     single_voxel, header_offset, numbands, nrows, ncols, row_offset;
int     col_offset, type;
char    *malloc();
int     file;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args())
{
  fprintf(stderr, "%s: Illegal arguments on command line.\n", program);
  exit(1);
}

single_voxel = 0;
header_offset = Scfp2viff->h_int;
numbands = Scfp2viff->b_int;
nrows = Scfp2viff->r_int;
ncols = Scfp2viff->c_int;
row_offset = 0;
col_offset = 0;
type = VFF_TYP_FLOAT;

if ( single_voxel && ((row_offset >= nrows) || (col_offset >= ncols)))
{
  (void) fprintf(stderr,"Scfp2viff: row or column offset out of range\n");
  exit(1);
}

/* Make sure that at least one output file type has been specified */
if ( (!Scfp2viff->o1_flag) && (!Scfp2viff->o2_flag) && (!Scfp2viff->o3_flag) )
{
  (void) fprintf(stderr,"Scfp2viff:  specify at least one output file\n");
  exit(1);
}
/* -main_before_lib_call_end */

/* -main_library_call */

if ( (file = open_input(Scfp2viff->i_file)) < 0)
{
  (void) fprintf(stderr,"Scfp2viff:  Unable to access input file %s\n",Scfp2viff->i_file);
  exit(1);
}

/* Call sig2viff to read in the raw data and create and format the complex
   output file. */
if(! sig2viff(file, &img1, nrows, ncols, header_offset, type, 
                 single_voxel, row_offset, col_offset, numbands))
{
  (void) fprintf(stderr, "sig2viff Failed\n");
  exit(1);
}
/* -main_library_call_end */

/* -main_after_lib_call */

/* If a real output file was specified, create real file by copying complex
   VIFF file and then calling lctor to extract the real part of the data. */
if (Scfp2viff->o2_flag)
{
  if ((img2=(struct xvimage *)malloc(sizeof(struct xvimage)))==NULL)
  {
    (void) fprintf(stderr,"Scfp2viff: malloc failed\n");
    exit(1);
  }
  if (!(copyheader(img1, img2)))           
  {
    (void) fprintf(stderr, "copyheader for %s Failed\n", Scfp2viff->o2_file);
    exit(1);
  }
  if (!(copyimagedata(img1, &img2, 1)))   
  {
    (void)fprintf(stderr, "copyimagedata for %s Failed\n", Scfp2viff->o2_file);
    exit(1);
  }
  if (!(lvctor(img2, 1)))
  {
    (void) fprintf(stderr, "lvctor for %s Failed\n", Scfp2viff->o2_file);
    exit(1);
  }
}

/* If a imaginary output file was specified, create imaginary file by 
   copying complex VIFF file and then calling lctor to extract the 
   imaginary part of the data. */
if (Scfp2viff->o3_flag)
{
  if ((img3=(struct xvimage *)malloc(sizeof(struct xvimage)))==NULL)
  {
    (void) fprintf(stderr,"Scfp2viff: malloc failed\n");
    exit(1);
  }
  if (!(copyheader(img1, img3)))
  {
    (void) fprintf(stderr, "copyheader for %s Failed\n", Scfp2viff->o3_file);
    exit(1);
  }
  if (!(copyimagedata(img1, &img3, 1)))  
  {
    (void)fprintf(stderr, "copyimagedata for %s Failed\n", Scfp2viff->o3_file);
    exit(1);
  }
  if (!(lvctor(img3, 2)))
  {
    (void) fprintf(stderr, "lvctor for %s Failed\n", Scfp2viff->o3_file);
    exit(1);
  }
}
/* Write out complex file if specified */
if (Scfp2viff->o1_flag)
{
  writeimage(Scfp2viff->o1_file,img1);
}

/* Write out real file if specified */
if (Scfp2viff->o2_flag)
{
  writeimage(Scfp2viff->o2_file,img2);
}

/* Write out imaginary file if specified */
if (Scfp2viff->o3_flag)
{
  writeimage(Scfp2viff->o3_file,img3);
}

/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for Scfp2viff 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "Scfp2viff :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tConversion from GE Signa Magnet floating point complex  data\n");
	fprintf(stderr, "\tfile to VIFF file.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
(void) fprintf(stderr,"where \"-o1\" creates complex output data file\n");
(void) fprintf(stderr,"      \"-o2\" creates real output data file\n");
(void) fprintf(stderr,"      \"-o3\" creates imaginary output data file\n");
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input Signa cmplx fp data file  (infile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-o1]  complex output image (viff file) (outfile) [null]\n");
	fprintf(stderr,"\t[-o2]  real output image filename (outfile) [null]\n");
	fprintf(stderr,"\t[-o3]  imaginary output image filename (outfile) [null]\n");
	fprintf(stderr,"\t[-r]  number of rows (integer, >= 0) [1]\n");
	fprintf(stderr,"\t[-c]  number of columns (integer, >= 0) [1024]\n");
	fprintf(stderr,"\t[-h]  byte offset from the start of the input data file (integer, >= 0) [1024]\n");
	fprintf(stderr,"\t[-b]  number of points per voxel (bands) (integer, >= 0) [1]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for Scfp2viff\n");
	fprintf(stderr, "\t[-U] Gives the usage for Scfp2viff\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called Scfp2viff.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses Scfp2viff.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for Scfp2viff
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input Signa cmplx fp data file \n        {infile}: "; 
char	*o1_pstr = 
	"\nEnter: (o1) complex output image (viff file) \n        {outfile}: "; 
char	*o2_pstr = 
	"\nEnter: (o2) real output image filename \n        {outfile}: "; 
char	*o3_pstr = 
	"\nEnter: (o3) imaginary output image filename \n        {outfile}: "; 
char	*r_pstr = 
	"\nEnter: (r) number of rows \n        {integer, >= 0 [1] }: "; 
char	*c_pstr = 
	"\nEnter: (c) number of columns \n        {integer, >= 0 [1024] }: "; 
char	*h_pstr = 
	"\nEnter: (h) byte offset from the start of the input data file \n        {integer, >= 0 [1024] }: "; 
char	*b_pstr = 
	"\nEnter: (b) number of points per voxel (bands) \n        {integer, >= 0 [1] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "Scfp2viff", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "Scfp2viff.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "Scfp2viff: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "Scfp2viff.ans");
		}

	     }

	}

	/*
	 * allocate the Scfp2viff structure
	 */
	Scfp2viff = (Scfp2viff_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (Scfp2viff_struct));

	/*
	 * get required arguments for Scfp2viff
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(Scfp2viff->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(Scfp2viff->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(Scfp2viff->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    Scfp2viff->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(Scfp2viff->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for Scfp2viff
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	Scfp2viff->o1_flag = vget_outfile(fid, prompt_flag,
	"-o1", o1_pstr, &(Scfp2viff->o1_file))
;

	Scfp2viff->o2_flag = vget_outfile(fid, prompt_flag,
	"-o2", o2_pstr, &(Scfp2viff->o2_file))
;

	Scfp2viff->o3_flag = vget_outfile(fid, prompt_flag,
	"-o3", o3_pstr, &(Scfp2viff->o3_file))
;

	Scfp2viff->r_flag = vget_int(fid, prompt_flag,
	"-r", r_pstr, &(Scfp2viff->r_int),
	1, 1, 1);

	Scfp2viff->c_flag = vget_int(fid, prompt_flag,
	"-c", c_pstr, &(Scfp2viff->c_int),
	1024, 1, 1);

	Scfp2viff->h_flag = vget_int(fid, prompt_flag,
	"-h", h_pstr, &(Scfp2viff->h_int),
	1024, 1, 1);

	Scfp2viff->b_flag = vget_int(fid, prompt_flag,
	"-b", b_pstr, &(Scfp2viff->b_int),
	1, 1, 1);


}



