/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vexpwarp.h
 >>>>            Author: Scott Wilson
 >>>> Date Last Updated: Tue Apr 16 14:17:53 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vexpwarp_h_
#define _vexpwarp_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vexpwarp Argument Structure
*
****************************************************************/

typedef struct _vexpwarp  {

/*
 *  input image (Required infile)
 */
char	*i_file;	/* input image FILENAME */
int	 i_flag;	/* input image FLAG */

/*
 *  output image (Required outfile)
 */
char	*o_file;	/* output image FILENAME */
int	 o_flag;	/* output image FLAG */

/*----- these are a Required mutually exclusive group ----*/
/*
 *  X map function (Required string)
 */
char	*xmap_string;	/* X map function STRING */
int	 xmap_flag;   	/* X map function FLAG */

/*
 *  X map function file (Required infile)
 */
char	*ix_file;	/* X map function file FILENAME */
int	 ix_flag;	/* X map function file FLAG */

/*-------------------------------------------*/

/*----- these are a Required mutually exclusive group ----*/
/*
 *  Y map function (Required string)
 */
char	*ymap_string;	/* Y map function STRING */
int	 ymap_flag;   	/* Y map function FLAG */

/*
 *  Y map function file (Required infile)
 */
char	*iy_file;	/* Y map function file FILENAME */
int	 iy_flag;	/* Y map function file FLAG */

/*-------------------------------------------*/

/*
 *  x coordinate of center-of-action (Optional float)
 */
float	 x_float;	/* x coordinate of center-of-action FLOAT */
int	 x_flag;   	/* x coordinate of center-of-action FLAG */

/*
 *  y coordinate of center-of-action (Optional float)
 */
float	 y_float;	/* y coordinate of center-of-action FLOAT */
int	 y_flag;   	/* y coordinate of center-of-action FLAG */

}  vexpwarp_struct;

vexpwarp_struct *vexpwarp;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define CHECKINPUT(program, img1) \
        (void) proper_num_images(program,img1,1,TRUE); \
        if (propertype(program,img1,VFF_TYP_COMPLEX,FALSE) || \
            propertype(program,img1,VFF_TYP_DCOMPLEX,FALSE) || \
            propertype(program,img1,VFF_TYP_DOUBLE,FALSE) || \
            propertype(program,img1,VFF_TYP_BIT,FALSE)) \
        { \
            (void) fprintf(stderr, "Input image: Image data type can \
NOT be COMPLEX || BIT || DOUBLE || DCOMPLEX\n"); \
            exit(1); \
        } \
        (void) proper_map_enable(program,img1,VFF_MAP_OPTIONAL,TRUE); \
        \
        (void) proper_loc_type(program,img1,VFF_LOC_IMPLICIT,TRUE)
/* -include_macros_end */

#endif
