/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vdrape.c
 >>>>
 >>>>      Program Name: vdrape
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Project or drape an image over a surface
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Mon Apr 15 22:19:23 1991
 >>>>
 >>>>          Routines: main- the main program for vdrape
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vdrape.h"


/****************************************************************
 *
 * Routine Name:  main program for vdrape
 *
 *       Input:  
 *        -i  imagery image 
 *        -s  surface image 
 *        -o  output image 
 *        -xi  X coordinate of imagery reference pixel  
 *        -yi  Y coordinate of imagery reference pixel  
 *        -xs  X coordinate of surface reference pixel  
 *        -ys  Y coordinate of surface reference pixel  
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *img, *surface,*out;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);

        img = readimage(vdrape->i_file);
        if (img == NULL) exit(1);                    

        proper_num_images(program,img,1,1);
        proper_loc_type(program,img,VFF_LOC_IMPLICIT,1);
        proper_num_bands(program,img,1,1);
        if (img->data_storage_type != VFF_TYP_FLOAT)
          {
            lvconvert(img,VFF_TYP_FLOAT,0,1,0.0,1.0,0);
          }

        surface = readimage(vdrape->s_file);
        if (surface == NULL) exit(1);                    
        proper_num_images(program,surface,1,1);
        proper_loc_type(program,surface,VFF_LOC_IMPLICIT,1);
        proper_num_bands(program,surface,1,1);
        if (surface->data_storage_type != VFF_TYP_FLOAT)
          {
            lvconvert(surface,VFF_TYP_FLOAT,0,1,0.0,1.0,0);
          }
/* -main_before_lib_call_end */

/* -main_library_call */
        if(! lvdrape(img,surface,vdrape->xi_int,vdrape->yi_int,
                     vdrape->xs_int,vdrape->ys_int,&out) )
        {
            (void) fprintf(stderr, "lvdrape Failed\n");
            exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
        (void) writeimage(vdrape->o_file,out);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vdrape 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vdrape :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tProject or drape an image over a surface\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  imagery image  (infile)\n");
	fprintf(stderr,"\t-s  surface image  (infile)\n");
	fprintf(stderr,"\t-o  output image  (outfile)\n");
	fprintf(stderr,"\t-xi  X coordinate of imagery reference pixel  (integer)\n");
	fprintf(stderr,"\t-yi  Y coordinate of imagery reference pixel  (integer)\n");
	fprintf(stderr,"\t-xs  X coordinate of surface reference pixel  (integer)\n");
	fprintf(stderr,"\t-ys  Y coordinate of surface reference pixel  (integer)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vdrape\n");
	fprintf(stderr, "\t[-U] Gives the usage for vdrape\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vdrape.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vdrape.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vdrape
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) imagery image \n        {infile}: "; 
char	*s_pstr = 
	"\nEnter: (s) surface image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image \n        {outfile}: "; 
char	*xi_pstr = 
	"\nEnter: (xi) X coordinate of imagery reference pixel \n        {integer}: "; 
char	*yi_pstr = 
	"\nEnter: (yi) Y coordinate of imagery reference pixel \n        {integer}: "; 
char	*xs_pstr = 
	"\nEnter: (xs) X coordinate of surface reference pixel \n        {integer}: "; 
char	*ys_pstr = 
	"\nEnter: (ys) Y coordinate of surface reference pixel \n        {integer}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vdrape", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vdrape.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vdrape: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vdrape.ans");
		}

	     }

	}

	/*
	 * allocate the vdrape structure
	 */
	vdrape = (vdrape_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vdrape_struct));

	/*
	 * get required arguments for vdrape
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vdrape->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vdrape->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vdrape->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vdrape->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vdrape->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vdrape->s_flag = vget_infile(fid, prompt_flag,
			"-s", s_pstr, &(vdrape->s_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vdrape->s_flag))
		{
		    fprintf(stderr, "\t\ts is required, please re-enter: \n");
		    vdrape->s_flag = vget_infile(fid, prompt_flag,
		    "-s", s_pstr, &(vdrape->s_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-s' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vdrape->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vdrape->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vdrape->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vdrape->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vdrape->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vdrape->xi_flag = vget_int(fid, prompt_flag,
			"-xi", xi_pstr, &(vdrape->xi_int),
			0, 0, 0)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vdrape->xi_flag))
		{
		    fprintf(stderr, "\t\txi is required, please re-enter: \n");
		    vdrape->xi_flag = vget_int(fid, prompt_flag,
		    "-xi", xi_pstr, &(vdrape->xi_int),
		    0, 0, 0);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-xi' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vdrape->yi_flag = vget_int(fid, prompt_flag,
			"-yi", yi_pstr, &(vdrape->yi_int),
			0, 0, 0)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vdrape->yi_flag))
		{
		    fprintf(stderr, "\t\tyi is required, please re-enter: \n");
		    vdrape->yi_flag = vget_int(fid, prompt_flag,
		    "-yi", yi_pstr, &(vdrape->yi_int),
		    0, 0, 0);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-yi' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vdrape->xs_flag = vget_int(fid, prompt_flag,
			"-xs", xs_pstr, &(vdrape->xs_int),
			0, 0, 0)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vdrape->xs_flag))
		{
		    fprintf(stderr, "\t\txs is required, please re-enter: \n");
		    vdrape->xs_flag = vget_int(fid, prompt_flag,
		    "-xs", xs_pstr, &(vdrape->xs_int),
		    0, 0, 0);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-xs' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vdrape->ys_flag = vget_int(fid, prompt_flag,
			"-ys", ys_pstr, &(vdrape->ys_int),
			0, 0, 0)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vdrape->ys_flag))
		{
		    fprintf(stderr, "\t\tys is required, please re-enter: \n");
		    vdrape->ys_flag = vget_int(fid, prompt_flag,
		    "-ys", ys_pstr, &(vdrape->ys_int),
		    0, 0, 0);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-ys' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



