/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lveplane.c
 >>>>
 >>>>      Program Name: veplane
 >>>>
 >>>> Date Last Updated: Mon Apr 15 22:19:31 1991 
 >>>>
 >>>>          Routines: lveplane - the library call for veplane
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
#define VCALL(func) if (! func ) { fprintf(stderr,"lveplane: %s failed\n","func"); freeimage(copy); return(0); }
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lveplane - library call for veplane
*
* Purpose:
*    
*    Project interferomter data taken normal to tilted flat  back
*    to entrance plane
*    
*    
* Input:
*    
*    img            Pointer to FLOAT image to be draped over the  sur-
*                   face.
*    
*    xa             angle of image plane with respect  to  positive  X
*                   axis (degrees)
*    
*    ya             angle of image plane with respect  to  positive  Y
*                   axis (degrees)
*    
*    
* Output:
*    
*    out            Points to the output image.
*    
*    
*
* Written By: Scott Wilson
*    
*    
****************************************************************/


/* -library_def */
int
lveplane(image,xa,ya,out)
struct xvimage *image,**out;
float xa,ya;
/* -library_def_end */

/* -library_code */
  {
    int nc,nr,i,j;
    float ax,ay,*f;
    double cax,cay;
    struct xvimage *copy;

    ax = xa*XV_PI/180.0;
    ay = ya*XV_PI/180.0;
    cax = cos((double)ax);
    cay = cos((double)ay);

    if (image->num_data_bands != 1 ||
        image->num_of_images != 1 ||
        image->map_scheme != VFF_MS_NONE)
      {
        fprintf(stderr,"lveplane: input image must be single band, no maps!\n");
        return(0);
      }

    *out = NULL;

    nr = image->number_of_rows;
    nc = image->number_of_cols; 
    
    copy = copyimage(image);
    if (copy == NULL)
      {
        fprintf(stderr,"lveplane: Unable to create output image\n");
        return(0);
      }

    VCALL(lvresize(copy,cax,cay,(float)(nc/2),(float)(nr/2)))

    f = (float *)(image->imagedata);
    for (i=0; i<nr; i++)
      for (j=0; j<nc; j++)
        f[PIXEL(j,i,nr,nc)] /= (cax*cay);

    copy->pixsizx = image->pixsizx;
    copy->pixsizy = image->pixsizy;
    *out = copy;
    return(1);

  }
/* -library_code_end */
