/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vredim.c
 >>>>
 >>>>      Program Name: vredim
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Re-dimension the data part of an image
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Mon Apr 15 22:18:22 1991
 >>>>
 >>>>          Routines: main- the main program for vredim
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vredim.h"


/****************************************************************
 *
 * Routine Name:  main program for vredim
 *
 *       Input:  
 *        -i  input image 
 *        -r  number of rows   (value > 0)
 *        -c  number of cols   (value > 0)
 *        -b  number of bands   (value > 0)
 *        -o  output image 
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image,*readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);

        image = readimage(vredim->i_file);
        if (image == NULL) exit(1);                    
/* -main_before_lib_call_end */

/* -main_library_call */
        if(! lvredim(image,vredim->r_int, vredim->c_int, vredim->b_int) )
        {
            (void) fprintf(stderr, "lvredim Failed\n");
            exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
        (void) writeimage(vredim->o_file, image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vredim 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vredim :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tRe-dimension the data part of an image\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-r  number of rows  (integer, > 0)\n");
	fprintf(stderr,"\t-c  number of cols  (integer, > 0)\n");
	fprintf(stderr,"\t-b  number of bands  (integer, > 0)\n");
	fprintf(stderr,"\t-o  output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vredim\n");
	fprintf(stderr, "\t[-U] Gives the usage for vredim\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vredim.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vredim.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vredim
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*r_pstr = 
	"\nEnter: (r) number of rows \n        {integer, > 0}: "; 
char	*c_pstr = 
	"\nEnter: (c) number of cols \n        {integer, > 0}: "; 
char	*b_pstr = 
	"\nEnter: (b) number of bands \n        {integer, > 0}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image \n        {outfile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vredim", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vredim.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vredim: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vredim.ans");
		}

	     }

	}

	/*
	 * allocate the vredim structure
	 */
	vredim = (vredim_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vredim_struct));

	/*
	 * get required arguments for vredim
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vredim->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vredim->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vredim->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vredim->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vredim->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vredim->r_flag = vget_int(fid, prompt_flag,
			"-r", r_pstr, &(vredim->r_int),
			512, 2, 2)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vredim->r_flag))
		{
		    fprintf(stderr, "\t\tr is required, please re-enter: \n");
		    vredim->r_flag = vget_int(fid, prompt_flag,
		    "-r", r_pstr, &(vredim->r_int),
		    512, 2, 2);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-r' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vredim->c_flag = vget_int(fid, prompt_flag,
			"-c", c_pstr, &(vredim->c_int),
			512, 2, 2)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vredim->c_flag))
		{
		    fprintf(stderr, "\t\tc is required, please re-enter: \n");
		    vredim->c_flag = vget_int(fid, prompt_flag,
		    "-c", c_pstr, &(vredim->c_int),
		    512, 2, 2);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-c' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vredim->b_flag = vget_int(fid, prompt_flag,
			"-b", b_pstr, &(vredim->b_int),
			1, 2, 2)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vredim->b_flag))
		{
		    fprintf(stderr, "\t\tb is required, please re-enter: \n");
		    vredim->b_flag = vget_int(fid, prompt_flag,
		    "-b", b_pstr, &(vredim->b_int),
		    1, 2, 2);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-b' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vredim->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vredim->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vredim->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vredim->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vredim->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



