/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vthd.h
 >>>>            Author: Scott Wilson, Mike Murillo
 >>>> Date Last Updated: Mon Apr 15 22:17:26 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vthd_h_
#define _vthd_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vthd Argument Structure
*
****************************************************************/

typedef struct _vthd  {

/*
 *  input spectrum (Required infile)
 */
char	*i_file;	/* input spectrum FILENAME */
int	 i_flag;	/* input spectrum FLAG */

/*
 *  resulting output image (Required outfile)
 */
char	*o_file;	/* resulting output image FILENAME */
int	 o_flag;	/* resulting output image FLAG */

/*
 * lets user choose spectrum type (Optional integer toggle - )
 */
int	 t_toggle;		/* lets user choose spectrum type INT TOGGLE */
int	 t_flag;		/* lets user choose spectrum type FLAG */

}  vthd_struct;

vthd_struct *vthd;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define CHECKINPUT(program, img1) \
        (void) proper_num_images(program,img1,1,TRUE); \
        (void) proper_num_bands(program,img1,1,TRUE); \
        (void) propertype(program,img1,VFF_TYP_FLOAT,TRUE); \
        (void) proper_map_enable(program,img1,VFF_MAP_OPTIONAL,TRUE)
/* -include_macros_end */

#endif
