/*****************************************************************************
* Default fatal error handler for irit.					     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, April 1993  *
*****************************************************************************/

#include <stdio.h>
#include "irit_sm.h"

/*****************************************************************************
* DESCRIPTION:                                                               M
* Default trap for IRIT programs for irit fatal errors.			     M
*   This function just prints the given error message and die.		     M
*                                                                            *
* PARAMETERS:                                                                M
*   Msg:       Error message to print.                                       M
*                                                                            *
* RETURN VALUE:                                                              M
*   void                                                                     M
*                                                                            *
* KEYWORDS:                                                                  M
*   IritFatalError, error trap                                               M
*****************************************************************************/
void IritFatalError(char *Msg)
{
    fprintf(stderr, "Irit Fatal Error: %s\n", Msg);

    exit(-1);
}
