.TH Frame 3I "15 June 1987" "InterViews" "InterViews Reference Manual"
.SH NAME
Frame, ShadowFrame, MarginFrame, ShowFrame, TitleFrame, BorderFrame \-
surrounding interactor
.SH SYNOPSIS
.B #include <InterViews/frame.h>
.SH DESCRIPTION
A frame is a monoscene subclass that outlines another interactor.
A shadow frame draws an outline with a drop shadow.
A margin frame surrounds its component with horizontal and vertical glue.
.PP
A show frame is an abstract class that changes its appearance
in response to an EnterEvent or LeaveEvent.
A title frame provides a banner that it displays in reverse video
when it receives an EnterEvent.
A border frame draws an outline using a solid pattern when
it receives an EnterEvent and draws the outline using a gray pattern
when it receives a LeaveEvent.
.SH PUBLIC OPERATIONS
.TP
.B "Frame(Interactor*, int width = 1)"
Construct a frame.
If the given interactor is not nil, it is inserted as the frame's component.
The frame extends \fIwidth\fP pixels outside of the interactor.
.TP
.B "ShadowFrame(Interactor*, int h = 1, int v = 1)"
Construct a shadow frame.
The \fIh\fP and \fIv\fP ShadowFrame parameters specify the width of the
horizontal and vertical shadows, respectively.  Positive values for these
parameters specify shadows falling to the right and below the interactor,
respectively; negative values specify shadows falling to the left and above.
.TP
.B "MarginFrame(Interactor* = nil, int margin = 0)"
.ns
.TP
.B "MarginFrame(Interactor*, int margin, int shrink, int stretch)"
.ns
.TP
.B "MarginFrame(Interactor*, int hmargin, int vmargin)"
.ns
.TP
.B "MarginFrame(Interactor*, int hm, int hshr, int hstr, int vm, int vshr, int vstr)"
Construct a margin frame.  The first constructor puts rigid,
fixed-sized glue around the component, while the second surrounds it
with fixed-sized glue of the given shrinkability and stretchability.
Independent horizontal and vertical margins are set with the third
constructor.  The last constructor allows full specification of the
margin frame's horizontal and vertical margins, shrinkabilities, and
stretchabilities.
.TP
.B "virtual void ShowFrame::HandleInput(Event&)"
ShowFrame objects listen for EnterEvent and LeaveEvent.
When an EnterEvent is received, ShowFrame::Handle calls InsideFrame(true);
when an LeaveEvent is received, it calls InsideFrame(false).
For any other event, it calls HandleInput.
ShowFrame::InsideFrame does nothing.
ShowFrame::HandleInput calls Handle on the frame's component.
.TP
.B "TitleFrame(Banner*, Interactor*, int width = 1)"
Construct a title frame with the given banner.
TitleFrame::InsideFrame highlights and unhighlights the banner.
.TP
.B "BorderFrame(Interactor*, int width = 1)"
Construct a border frame.
BorderFrame::InsideFrame highlights and unhighlights the border.
.SH PROTECTED OPERATIONS
.TP
.B "Frame(Interactor*, int, int, int, int)"
This constructor is used by subclasses to explicitly set the widths 
of each line in the outline.  The integers specify the width of the
left, bottom, right, and top lines, respectively.
.SH SEE ALSO
Banner(3I), Event(3I), Glue(3I), Scene(3I)
