.if n .ll 7.5i
.if n .nr LL 7.5i
.LP
.ce 1000
\s+2\fBSan Diego Supercomputer Center\fR\s-2
.sp 1
\s+4\fBImage Tools\fR\s-4
.sp 1
\s+2\fBRelease Notes\fR\s-2
.sp 1
\s+1\fBBinary Release 2.1\fR\s-1
\s+1\fBDecember 1992\fR\s-1
.ce 0
.sp 3
\fB1.  Introduction\fR
.LP
These notes describe the December 1992 binary release of version
2.1 of the San Diego Supercomputer Center (SDSC) Image Tools.
.LP
The SDSC Image Tools
are a suite of portable image manipulation tools coupled with extensive
support for a wide range of image file formats.  Tool functionality and
file format support are implemented within a portable,
user-callable function library.  All tools, image file formats, and
library functions are fully documented.
.sp 2
.LP
\fB2.  Image Tools\fR
.LP
Release 2.1 includes the following command-line tools:
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
\fBimadjust\fR	Adjust image colors, desaturate, brighten, etc.
\fBimcat\fR	Concatenate images into multi-image files
\fBimcltroll\fR	Cycle a color lookup table
\fBimcomp\fR	Digitally composite images
\fBimconv\fR	Convert between all supported image file formats
\fBimcopy\fR	Copy a portion of an image into a new file
\fBimfile\fR	Display image attributes
\fBimfill\fR	Fill a region of an image with a color or gradient
\fBimflip\fR	Flip an image horizontally or vertically
\fBimformats\fR	Describe image file format support
\fBimgray\fR	Convert to grayscale
\fBimhist\fR	Compute an image histogram
\fBimmono\fR	Convert to monochrome
\fBimpaste\fR	Paste an image into another
\fBimroll\fR	Cycle an image horizontally or vertically
\fBimrotate\fR	Free rotate an image
\fBimscale\fR	Scale an image up or down
\fBimshear\fR	Shear an image horizontally or vertically
\fBimsplit\fR	Split apart multi-image files
.TE
.if t .in -0.5i
.if n .in -5
.LP
Source code and man pages for all tools are included.
.sp 2
.ne 5
.LP
\fB3.  Image File Formats\fR
.LP
Release 2.1 includes support for the following image file formats:
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
\fBbmp\fR	Microsoft Windows bitmap image file
\fBcur\fR	Microsoft Windows cursor image file
\fBeps\fR	Adobe Encapsulated PostScript file
\fBgif\fR	Compuserve Graphics image file
\fBhdf\fR	Hierarchical Data File
\fBico\fR	Microsoft Windows icon image file
\fBicon\fR	Sun Icon and Cursor file
\fBiff\fR	Sun TAAC Image File Format
\fBmpnt\fR	Apple Macintosh MacPaint file
\fBpbm\fR	PBM Portable Bit Map file
\fBpcx\fR	ZSoft IBM PC Paintbrush file
\fBpgm\fR	PBM Portable Gray Map file
\fBpic\fR	PIXAR picture file
\fBpict\fR	Apple Macintosh QuickDraw/PICT file
\fBpix\fR	Alias image file
\fBppm\fR	PBM Portable Pixel Map file
\fBpnm\fR	PBM Portable aNy Map file
\fBps\fR	Adobe PostScript file
\fBras\fR	Sun Rasterfile
\fBrgb\fR	SGI RGB image file
\fBrla\fR	Wavefront raster image file
\fBrle\fR	Utah Run length encoded image file
\fBsynu\fR	SDSC Synu image file
\fBtga\fR	Truevision Targa image file
\fBtiff\fR	Tagged image file
\fBviff\fR	Khoros Visualization image file
\fBx\fR	AVS X image file
\fBxbm\fR	X11 bitmap file
\fBxwd\fR	X Window System window dump image file
.TE
.if t .in -0.5i
.if n .in -5
.LP
Formats with multiple variants for handling different image depths and
compression schemes are fully supported (see exceptions later in this document).
You can obtain information on the supported variants by executing
the \fBimformats\fR tool with the \fB-long\fR option.  For instance:
.sp 0.5
.LP
.if t .in +0.5i
.if n .in +5
%  \fBimformats -long -hdf\fR
.br
.if t .ts 0.5i,1.0i,1.5i,2.0i,2.5i,3.0i
.if n .ts 8,16,24,32,40,48,56
hdf	Hierarchical Data File
.br
.if t .in +0.5i
.if n .in +8
.if t .ts 0.5i,1.0i,1.5i,2.0i,2.5i,3.0i
.if n .ts 8,16,24,32,40,48,56
a.k.a.:		df, ncsa
.br
.if t .ts 0.5i,1.0i,1.5i,2.0i,2.5i,3.0i
.if n .ts 8,16,24,32,40,48,56
Creator:	NCSA
.br
Read support:
.br
.if t .in +0.25i
.if n .in +2
8-bit color index images, un- and RLE-compressed.  16-, 24-, and
32-bit color index images, un-compressed.  24-bit RGB, un- and RLE-
compressed, un-, scanline- and plane-interleaved.  Raster image
groups as well as older Raster-8 files.
.br
.if t .in -0.25i
.if n .in -2
Write support:
.br
.if t .in +0.25i
.if n .in +2
8-bit color index images, un- and RLE-compressed.  16-bit color
index images, un-compressed.  24-bit RGB, uncompressed, un-,
scanline-, and plane-interleaved.  Raster image group and older
Raster-8 tags included.
.if t .in -0.25i
.if n .in -2
.if t .in -0.5i
.if n .in -8
.if t .in -0.5i
.if n .in -5
.sp 1
.LP
Release 2.1 includes support for the integration of additional site-specific
image file formats.  Source code for AVS X, SGI RGB, PostScript, and EPS file
formats is provided as examples for authoring image file format handlers.
.LP
Man pages on each of the supported file formats are included.
.sp 2
.ne 5
.LP
\fB4.  Image Library Functions.\fR
.LP
Release 2.1 includes a C-callable function library providing features for
image manipulation and image file format I/O.  A complete list of library
functionality is provided in the \fBimintro\fR(3IM) man page.
.LP
Man pages for all library functions are included.  Source code is not
included.
.sp 2
.LP
.ne 5
\fB5.  Documentation\fR
.LP
\fBMan\fR pages are included that describe the tools, library functions,
and all supported image file formats.  \fBnroff\fR source is provided in files
with \fB.n\fR filename
suffixes and should be processed through \fBtbl\fR and \fBnroff\fR.
For example:
.if t .in +0.5i
.if n .in +5
.LP
\fBtbl imconv.n | nroff -man > imconv.1l\fR
.br
	or
.br
\fBtbl imtiff.n | nroff -man > imtiff.3l\fR
.br
	or
.br
\fBtbl imintro.n | nroff -man > imintro.3l\fR
.if t .in -0.5i
.if n .in -5
.LP
A \fBMakefile\fR is provided to build man pages using \fBnroff\fR and \fBtbl\fR.
.LP
For sites without access to \fBnroff\fR and \fBtbl\fR, post-processed text
versions of all man pages are included in files
with \fB.1l\fR and \fB.3l\fR filename suffixes.
.LP
For sites with PostScript laserprinters, PostScript versions of the manual
pages are provided in files with \fB.ps\fR filename suffixes.
.sp 2
.LP
\fB6.  Binary Release\fR
.LP
This is a binary release.
Host architectures supported in this release include the following:
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l l.
alliantfx2800	Alliant Computer Sys	FX/2800 minisupercomputers
crayy	Cray Research Inc.	Y-MP supercomputers
decstation	Digital Equipment Corp.	DECStation workstations
decvax	Digital Equipment Corp.	DEC VAX and VAXStation workstations
ibmrs6000	BIM	RS/6000 workstations
next	NeXT Computers	NeXTStation workstations
sgi4d	Silicon Graphics Inc.	4D workstations
sun3	Sun Microsystems Inc.	Sun3 workstations
sun4	Sun Microsystems Inc.	Sun4 and SPARC workstations
.TE
.if t .in -0.5i
.if n .in -5
.LP
Additional architectures are expected in the near future.
.LP
A separate release \fBtar\fR or \fBcpio\fR file is generated for each
architecture.
.LP
Release 2.1 includes the C function library \fBlibim.a\fR, its
include file \fBim.h\fR and its manual pages..
.LP
For image file format handler authors, sample source is provided for
AVS X, SGI RGB,
PostScript, and EPS file format handlers, along with \fBimfmt.c\fR,
the master format table, and \fBiminternal.h\fR.
.LP
Use of the
SDSC Image Tools library requires the companion SDSC Utility Library
\fBlibsdsc.a\fR.
\fBlibsdsc.a\fR includes C packages to handle portable binary I/O,
command-line argument parsing, and the tag table data structure used
by the SDSC Image Tools.
The SDSC Utility Library and its documentation may be separately
uploaded via anonymous ftp from \fBftp.sdsc.edu\fR.
.sp 2
.ne 5
.LP
\fB7.  Changes since the last release\fR
.LP
The SDSC Image Tools have been expanded to include a variety of new library
routines and command-line tools, as well as support for additional image
file formats and additional variants of previously supported file formats.
.sp 1
\fB7.1.  Image Tools.\fR
.LP
\fBNew Tools:\fR
.if t .in +0.5i
.if n .in +5
.IP \(bu 0.1i
\fBimadjust\fR.  Adjust colors in an image.
Typical operations include brightening and darkening images, adjusting
image contrast and saturation, tweaking colors for special effects,
and creating alpha channels.  Adjust in RGB or HSI color spaces.
.IP \(bu 0.1i
\fBimcat\fR.  Concatenate multiple image files together into
a single multi-image file.  Useful for image file formats that
support multiple images in a single file, such as HDF.
.IP \(bu 0.1i
\fBimcltroll\fR.  Cycle a color lookup table (CLT) on a color
indexed image.
.IP \(bu 0.1i
\fBimcomp\fR.  Composite two images together using a variety
of digital compositing algorithms.  Composite all fields in an image, or
selected fields only.  Composite in RGB or HSI color spaces.
.IP \(bu 0.1i
\fBimfill\fR.  Fill an image with a single color or a color
gradient.  Fill in RGB or HSI color spaces.
.IP \(bu 0.1i
\fBimhist\fR.  Compute a histogram of unique colors and the number of
times they occur in an image.  Compute individual field histograms, or
histograms that correlate multiple fields (such as RGB rather than
R individually, then G individually, then B individually).
Compute in RGB or HSI color spaces.
.IP \(bu 0.1i
\fBimroll\fR.  Roll an an image's pixels horizontally or vertically.
Pixels that roll off one edge cycle back to the other edge.
.IP \(bu 0.1i
\fBimrotate\fR.  Rotate an image by an arbitrary floating point angle.
.IP \(bu 0.1i
\fBimshear\fR.  Shear an image vertically or horizontally by an
arbitrary floating point angle.
.IP \(bu 0.1i
\fBimsplit\fR.  Split multi-image files into multiple single-image files.
Useful for expanding multiple image files, such as HDF files.
.if t .in -0.5i
.if n .in -5
.LP
\fBTool Enhancements:\fR
.if t .in +0.5i
.if n .in +5
.IP \(bu 0.1i
\fBall tools\fR.  \fB-verbose\fR information is much more verbose about
the type of image file being read or written and the image's attributes.
.IP \(bu 0.1i
\fBimfile\fR.  \fB-long\fR flag added to display additional information on
image files.  \fBimfile\fR now displays the image's resolution, depth,
compression scheme, interleaving scheme, and so on.
.IP \(bu 0.1i
\fBimscale\fR.  \fB-bilinear\fR flag added to request bi-linear
pixel interpolation on image scaling (the default).  \fB-pixelrep\fR flag
added to request pixel-replication on image scaling (new feature).
.IP \(bu 0.1i
\fBimscale\fR.  \fB-scale\fR flag added to set a uniform X and Y scaling
factor.
.if t .in -0.5i
.if n .in -5
.LP
\fBTool Bug Fixes:\fR
.if t .in +0.5i
.if n .in +5
.IP \(bu 0.1i
\fBimpaste\fR.  In rare circumstances, \fBimpaste\fR would provide incorrect
arguments to an image library call that resulted in a core dump.  This has
been fixed.
.IP \(bu 0.1i
\fBimpaste\fR.  When centering pasted images, \fBimpaste\fR would sometimes fail
to perform the centering correctly.  This has been fixed.
.if t .in -0.5i
.if n .in -5
.sp 1
.LP
\fB7.2.  Image File Formats.\fR
.LP
\fBNew Image File Formats:\fR
.if t .in +0.5i
.if n .in +5
.IP \(bu 0.1i
\fBbmp\fR.  Microsoft Windows bitmap image format.
.IP \(bu 0.1i
\fBcur\fR.  Microsoft Windows cursor image format.
.IP \(bu 0.1i
\fBico\fR.  Microsoft Windows icon image format.
.IP \(bu 0.1i
\fBtga\fR.  Truevision Targa image format.
.IP \(bu 0.1i
\fBviff\fR.  Khoros visualization image format.
.if t .in -0.5i
.if n .in -5
.LP
\fBImage File Format Enhancements:\fR
.if t .in +0.5i
.if n .in +5
.IP \(bu 0.1i
\fBAll formats\fR.  Magic number recognition of image file formats has
been enhanced.
.IP \(bu 0.1i
\fBAll formats\fR.  Extensive "verbose" printing messages have been added
to all
image file format read and write handlers.  Verbose information printing
is requested using the \fB-verbose\fR flag on all Image Tools.
.IP \(bu 0.1i
\fBgif\fR.  GIF updated to match the 89a format specification.
.IP \(bu 0.1i
\fBiff\fR.  IFF updated to support Sun VX/MVX VFF file specification variant.
.IP \(bu 0.1i
\fBrgb\fR.  RGB updated to support 8-bit images.
.IP \(bu 0.1i
\fBxbm\fR.  XBM updated to read and write cursor hot-spot information,
when present.
.IP \(bu 0.1i
\fBxwd\fR.  XWD updated to read file window names.
.if t .in -0.5i
.if n .in -5
.LP
\fBImage File Format Bug Fixes:\fR
.if t .in +0.5i
.if n .in +5
.IP \(bu 0.1i
\fBgif\fR.  GIF reading incorrectly handled 2-bit images.  This has been
fixed.
.IP \(bu 0.1i
\fBrgb\fR.  Some RGB files, when read by the Image Tools, would display the
red, green, and blue portions of the image as three horizontal stripes,
rather than combining all three into a correct non-striped RGB image.  This
problem has been fixed.
.IP \(bu 0.1i
\fBrgb\fR.  On rare RGB files with very long image names, the Image Tools
would core dump on reading in the image file header.  This problem has been
fixed.
.IP \(bu 0.1i
\fBxwd\fR.  On least-significant-byte-first hosts, such as DECstations and
DEC Vaxen, XWD file header information reading used the wrong byte order
and thus obtained bogus information.  This usually resulted in a core dump.
This problem has been fixed.
.IP \(bu 0.1i
\fBxwd\fR.  XWD file format support would occasionally core dump on 24-bit
RGB image read and write.  This has been fixed.
.IP \(bu 0.1i
\fBxwd\fR.  The XWD format specification explicitly states the proper
setting of header fields.  However, some site-specific tools fail to set
this information correctly.  \fBxwud\fR, the X display tool, is tolerant
of these header imperfections.  Prior releases of the Image Tools were not.
XWD support has been made more tolerant of incorrect XWD file headers.
.if t .in -0.5i
.if n .in -5
.sp 1
.LP
\fB7.3.  Image Library.\fR
.LP
\fBNew Library Functions:\fR
.if t .in +0.5i
.if n .in +5
.IP \(bu 0.1i
\fBImCltRoll\fR.  Cycle a color lookup table.
.IP \(bu 0.1i
\fBImHsiToRgb\fR.  Convert HSI color to RGB color.
.IP \(bu 0.1i
\fBImRgbToHsi\fR.  Convert RGB color to HSI color.
.IP \(bu 0.1i
\fBImVfbAdjust\fR.  Adjust image fields.
.IP \(bu 0.1i
\fBImVfbComp\fR.  Digitally composite images.
.IP \(bu 0.1i
\fBImVfbFill\fR.  Fill fields in an image.
.IP \(bu 0.1i
\fBImVfbHist\fR.  Compute image histograms.
.IP \(bu 0.1i
\fBImVfbRoll\fR.  Roll an image vertically or horizontally.
.IP \(bu 0.1i
\fBImVfbRotate\fR.  Rotate an image.
.IP \(bu 0.1i
\fBImVfbShear\fR.  Shear an image vertically or horizontally.
.IP \(bu 0.1i
\fBImVfbStat\fR.  Compute image statistics.
.IP \(bu 0.1i
\fBImVfbToIndex\fR.  Convert an image to color indexed with a specific
maximum number of colors.
.if t .in -0.5i
.if n .in -5
.LP
\fBLibrary Function Enhancements:\fR
.if t .in +0.5i
.if n .in +5
.IP \(bu 0.1i
\fBImVfbResize\fR.  Pixel replication algorithm added.
.if t .in -0.5i
.if n .in -5
.LP
\fBLibrary Function Bug Fixes:\fR
.if t .in +0.5i
.if n .in +5
.IP \(bu 0.1i
\fBImVfbResize\fR.  Resizing of images with \fBIMVFBFDATA\fR fields was
not handled correctly.  This has been fixed.
.IP \(bu 0.1i
\fBImVfbToIndex16\fR.  Resizing of images with \fBIMVFBINDEX16\fR fields
caused an incorrect shift in image data.  This has been fixed.
.IP \(bu 0.1i
\fBImVfbToMono\fR.  RGB images converted to monochrome sometimes resulted in
all black images.  This has been fixed.
.if t .in -0.5i
.if n .in -5
.sp 1
.LP
\fB7.4.  General.\fR
.LP
\fBRemoved features:\fR
.if t .in +0.5i
.if n .in +5
.IP \(bu 0.1i
The Alliant FX/80 is no longer supported.
.if t .in -0.5i
.if n .in -5
.sp 2
.ne 5
.LP
\fB8.  Items that may cause confusion\fR
.LP
The following features of the SDSC Image Tools may confuse some users.
.if t .in +0.5i
.if n .in +5
.IP \(bu 0.1i
While the GIF read code can handle multi-image GIF files, the write code
can only write out GIF files with one image to a file.
.IP \(bu 0.1i
IFF format files are Sun's TAAC images, not Amiga images.  Both Sun and
Commodore used the same mnemonic for their image files.
.IP \(bu 0.1i
PCX files generated on the IBM PC by CorelDRAW! are always monochrome, even
if the image being drawn uses color.  This is a problem with CorelDRAW!.
CorelDRAW! can, however, read in color PCX files generated by the SDSC Image
Tools, or other PC tools.
.IP \(bu 0.1i
PCX files generated on the IBM PC by PC PaintBrush from images using more
than 16 colors are incorrectly written using the 4-bit PCX format.  Colors
are lost.  This is a problem with PC PaintBrush.  PC PaintBrush can, however,
read in 8-bit PCX files generated by the SDSC Image Tools.
.IP \(bu 0.1i
PCX files generated on the IBM PC by PC PaintBrush from images with 2, 3, or
4 colors are sometimes written without their color tables.  Colors are lost.
This is a problem with PC PaintBrush.
.IP \(bu 0.1i
PICT handles PICT2 as well.
.IP \(bu 0.1i
PICT files are always mapped to RGB images during conversion.  This is an
artifact made necessary by support of multi-image, multi-color map features
of the PICT and PICT2 formats.  A command line
like the following will result in an RGB HDF file instead of the
expected color index HDF file:
.sp 0.5
.ce 1
\fBimconv image.pict image.hdf\fR
.IP \(bu 0.1i
PICT support does not handle many drawing operations.  To do so would require
reimplementing Apple's QuickDraw and is beyond the scope of an image handling
package.  PICT files containing drawing operations should be converted to
bitmaps on the Macintosh, then uploaded to the UNIX host.  Bitmap conversion
may be accomplished with a variety of tools, including SuperPaint, PhotoShop,
and others.
.IP \(bu 0.1i
PICT support does not handle fonts.  Text stored in a PICT file references a
font, but does not include the font's bitmap.  When uploaded to a UNIX host,
the font bitmaps are no longer available.  This makes it impossible to support
PICT text operations.  PICT files containing text should be converted to
bitmaps on the Macintosh, then uploaded to the UNIX host.  Bitmap conversion
may be accomplished with a variety of tools, including SuperPaint, PhotoShop,
and others.
.IP \(bu 0.1i
Wavefront RLA handles RLB as well.
.IP \(bu 0.1i
The Image tools support PostScript and EPS image writing, but not
image reading.  To do so would require a full PostScript language
interpreter, and is well beyond the scope of this project.
.IP \(bu 0.1i
Stardent's \fBxwd\fR on Stardent GS1000s generates one
of two types of 24-bit RGB XWD files,
depending upon the type of image originally displayed.
.if t .in +0.5i
.if n .in +5
.IP "1." 0.25i
If a 24-bit image is displayed on a Stardent GS1000, then dumped to an XWD
file using \fBxwd\fR, a TrueColor RGB XWD image is created.  This is correct.
.IP "2." 0.25i
If an 8-bit image is displayed on a Stardent GS1000, then dumped to an XWD
file using \fBxwd\fR, a DirectColor RGB XWD image is created without a color
map.  This is incorrect and is a bug in Stardent's \fBxwd\fR.  DirectColor
RGB XWD images must have a color map.  SDSC's Image Tools, as well as
\fBxwud\fR and any
other image tools handling XWD files, will be unable to fix this problem.
.if t .in -0.5i
.if n .in -5
.if t .in -0.5i
.if n .in -5
.sp 2
.LP
\fB9.  Known Problems\fR
.LP
The following are known problems present in the 2.0 release of the SDSC
Image Tools:
.if t .in +0.5i
.if n .in +5
.IP \(bu 0.1i
When printing to some color PostScript printers, the page size calculated by
the PostScript generated by the Image Tools may be incorrect.  This can
result in portions of the image extending past the edge of the page and not
being printed.
.IP \(bu 0.1i
PICT support does not read or write 24-bit RGB images.
.IP \(bu 0.1i
TIFF core dumps on images only 1 scanline high,
or with fewer than 8 pixels per scanline.
.IP \(bu 0.1i
TIFF's "Photometric Interpretation" tag is not recognized to invert black
and white values in a monochrome image.  This is inconvenient when uploading
monochrome TIFF images from an IBM PC.
.IP \(bu 0.1i
TIFF handling supports uncompressed, PackBits compressed, and Limpel-Ziv &
Welch compressed images.  CCITT Huffman, CCIT RLE, CCIT Group 3 fax,
CCIT Group 4 fax, NeXT, Thunderscan, PIXAR PICIO, SGI RLE, and JPEG compression
schemes are not supported.
.IP \(bu 0.1i
XWD files stored in the XY format (instead of Z format) are not supported yet.
.if t .in -0.5i
.if n .in -5
.sp 2
.LP
\fB10.  Future Directions\fR
.LP
This is an ongoing project at SDSC.  Plans for expansion include
extending the depth of support for the current set of image file formats,
adding additional file formats, and creating more tools and library
functions.  Input from SDSC Image Tools users would be quite helpful in
optimally directing our future efforts.
.sp 2
.LP
\fB11.  Bug Reports and User Registration\fR
.LP
This software is developed and
supported by the San Diego Supercomputer Center, and we want
to hear from you.  If you find bugs (heaven forbid), or want to be put on
our mailing list for future software releases, please fill out
and send us a bug report and/or user registration form.  These forms may be
obtained by executing any one of our tools with the \fB-feedback\fR
or \fB-register\fR options.
.LP
For instance, to generate a bug report feedback form for \fBimconv\fR, type:
.if t .in +0.5i
.if n .in +5
.LP
% \fBimconv -feedback\fR
.if t .in -0.5i
.if n .in -5
.LP
The feedback (bug report) form is written to a file named \fBimconv.fbk.0\fR
in the current directory.
When generating a feedback form, the tool writes the form and exits without
executing further.
.LP
To generate a user registration form for \fBimconv\fR, type:
.if t .in +0.5i
.if n .in +5
.LP
% \fBimconv -register\fR
.if t .in -0.5i
.if n .in -5
.LP
Like the feedback form, the registration form is written to a file
named \fBimconv.reg.0\fR
in the current directory.  When
generating a registration form, the tool writes the form and exits without
executing further.
.LP
User registration is not required, but we'd like to hear from you anyway.
We'll put you on a mailing list for notification of future releases of
SDSC software tools, and read with interest who you are and what you
are doing with our software.
.LP
After you have filled out the form, please send the form, and any
accompanying data, source fragments, sample output, or whatever, to SDSC:
.if t .in +0.5i
.if n .in +5
.if n .bp
.ne 8
.LP
.TS
l l.
E-mail:	info@sdsc.edu

Surface mail:	Software Products Information
	San Diego Supercomputer Center
	P.O. Box 85608
	San Diego, CA  92186-9784

FAX:	(619) 534-5113
.TE
.if t .in -0.5i
.if n .in -5
.LP
If you have questions about this form or any of our software products, please
contact us via any of the above methods or call us at:
.if t .in +0.5i
.if n .in +5
.LP
(619) 534-5100  M-F, 8am-5pm, Pacific time
.if t .in -0.5i
.if n .in -5
.sp 2
.LP
\fB12.  Copyright\fR
.LP
Users and possessors of the files of this release are hereby granted a
nonexclusive, royalty-free copyright and design patent license to use
this code in individual software.  License is not granted for commercial
resale, in whole or in part, without prior written permission from SDSC.
This release is provided "AS IS" without express or implied warranty of any
kind.
.LP
We ask that the following message be included in all
derived works:  \fIPortions developed at the San Diego Supercomputer Center\fR.
.LP
Please do not redistribute this software.  We would prefer that interested
parties upload the software directly from our anonymous ftp account.  This
guarantees that they get the latest release, and helps us to keep track of
roughly how many sites out there are using our software.
.sp 2
.LP
\fB13.  Conclusion\fR
.LP
Please use these tools and send us feedback:  let us know what you like and what
you don't like about this software.  Tell us how you are using the SDSC
Image Tools and what you would like to see in the future, both as enhancements
to this product, and as additional products from SDSC.
.LP
We encourage you to cite in your publications
the use of the SDSC Image Tools, and any other
SDSC software you have used.  Your publication references and
your feedback support are what makes this project work, and what gives
us the opportunity to continue to develop portable free tools like
the SDSC Image Tools, and our other products.
We look forward to hearing from you!
.LP
