'\"t
.if t .TH IMVFBCOPY 3IM "August 25, 1992" "San Diego Supercomputer Center" "SDSC IMAGE LIBRARY" 
.if n .TH IMVFBCOPY 3IM "August 25, 1992" "SDSC" "SDSC IMAGE LIBRARY"
.SH NAME
ImVfbCopy - Copy a subarea within a virtual frame buffer
.SH SYNOPSIS
\fB
.nf
#include "im.h"

ImVfb *ImVfbCopy( srcVfb, srcXLeft, srcYTop, srcDX, srcDY, fieldMask, dstVfb, dstXLeft, dstYTop )
	ImVfb *srcVfb ;
	int srcXLeft, srcYTop ;
	int srcDX, srcDY ;
	int fieldMask ;
	ImVfb *dstVfb ;
	int dstXLeft, dstYTop ;
.fi
\fR
.SH DESCRIPTION
\fBImVfbCopy\fR copies a portion of a virtual frame buffer to another virtual
frame buffer.
A pointer to the destination virtual frame buffer is returned.
.LP
\fIsrcVfb\fR is the Vfb whose subarea is to be copied.
.LP
\fIsrcXLeft, srcYTop\fR indicate the top-left corner of the area of
the Vfb to be copied.
.LP
\fIsrcDX, srcDY\fR are the dimensions of the subarea of the Vfb to be
copied. 
.LP
\fIfieldMask\fR is a mask of field constants (see \fBImVfbAlloc\fR
(3IM)) that selects the fields in \fIsrcVfb\fR to be copied into
\fIdstVfb\fR.  
.LP
\fIdstVfb\fR is the Vfb to receive the copied area.
.LP
\fIdstXLeft, dstYTop\fR indicate the top-left corner of the area to
which the subarea will be copied.
.SH NOTES
If \fIdstVfb\fR is the constant \fBIMVFBNEW\fR, a new Vfb is allocated for
the copied data.  The Vfb has the same size as the region being copied,
and the fields are selected by \fIfieldMask\fR.
A pointer to the new Vfb is returned.
.LP
Portions of the copied data that would extend beyond the borders of the
\fIdstVfb\fR are skipped.
.LP
The \fIsrcVfb\fR and \fIdstVfb\fR may be the same Vfb.
The source and destination areas can overlap with no unpleasant side effects.
.SH RETURNS
Upon success, \fBImVfbCopy\fR returns a pointer to the destination Vfb.
Upon failure, \fBIMVFBNULL\fR is returned and \fBImErrNo\fR set
to the following:
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEMALLOC	Cannot allocate enough memory for the new Vfb
.TE
.if t .in -0.5i
.if n .in -5
.SH SEE ALSO
\fBImVfbIntro\fR (3IM),
\fBImVfbErrNo\fR (3IM),
\fBImVfbAlloc\fR (3IM),
\fBImVfbDup\fR (3IM)
.SH AUTHORS
Mike Bailey, Dave Nadeau
.br
San Diego Supercomputer Center
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br

