'\"et
.if t .TH IMRPNM 3IM "August 19, 1992" "San Diego Supercomputer Center" "SDSC IMAGE LIBRARY"
.if n .TH IMRPNM 3IM "August 19, 1992" "SDSC" "SDSC IMAGE LIBRARY"
.SH NAME
imrpnm \- PBM+ suite RPNM file translation
.SH SYNOPSIS
.nf
\fB
#include <stdio.h>
#include "sdsc.h"
#include "im.h"
.sp 1
int ImFileRead( fd, "rpnm", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFRead( fp, "rpnm", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileWrite( fd, "rpnm", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFWrite( fp, "rpnm", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
\fR
.fi
.SH DESCRIPTION
\fBrpnm\fR image files are used by various tools in Jef Poskanzer's PBM+
tool suite.
See the PBM documentation set for details on how to use these tools.
.SH "FILE RECOGNITION"
\fBrpnm\fR files are recognized by the filename suffix:  .rpnm.
.SH NOTES
SDSC image library support of the \fBrpnm\fR format does not require
use of the PBM+ libraries and tools.
It does not contain proprietary code or any code from Jef Poskanzer's
original PBM+ suite.  \fBrpnm\fR format handling
is available on any machine for which the SDSC image library is available.
.LP
PBM (Portable Bit Map) started with support for 1-bit monochrome
images (see \fBimpbm\fR(3IM)).  Support was added for 8-bit grayscale
images (see \fBimpgm\fR(3IM)), also called PGM (Portable Grayscale
Map), and 24-bit RGB images (see \fBimppm\fR(3IM)), also called PPM
(Portable Pixel Map).  Each of these defined a new file format. 
.LP
The original file formats were ASCII.  To reduce the disk space
required to store such files, three additional "raw" formats were defined.
The raw formats stored the same information as their ASCII
counterparts but in binary, reducing the disk space requirement by
around 60%. 
.LP
Today the PBM+ suite contains six related file formats:
.RS 0.5i
.LP
.TS
l l.
PBM	ASCII 1-bit bitmaps
PGM	ASCII 8-bit grayscale pixel maps
PPM	ASCII 24-bit RGB color pixel maps
RPBM	Raw binary 1-bit bitmaps
RPGM	Raw binary 8-bit grayscale pixel maps
RPPM	Raw binary 24-bit RGB color pixel maps
.TE
.RE
.LP
The original PBM suite included a variety of tools.  Some handled PBM
files, but not PGM or PPM.  Others handled PGM files, but not PBM or PPM.
Then the newer PBM+ distribution introduced a set of tools that
recognized all six file formats.  These tools generically referred to
image files as PNM files, which stands for "Portable aNy Map."
.LP
The SDSC image library treats the six PBM+ file formats separately.
However, to be compatible with the apparent trend in the PBM+ toolset,
the new generic \fBpnm\fR and \fBrpnm\fR names mean "any of the PBM+
formats."  This \fBman\fP page only discusses the RPNM generic filename.
The remaining file formats are discussed in their own \fBman\fP pages.
.SS "Reading RPNM image files"
The SDSC image library can read any of the PBM+ file formats when the
\fBrpnm\fP format name is used, including the ASCII format variants
and the raw binary variants.  PBM+ files are read in and mapped to
VFBs as follows: 
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l l.
\fBFile format	Depth/color	Mapped to VFB\fR
PBM	1-bit monochrome	\fBIMVFBMONO\fR without a CLT
PGM	8-bit color index	\fBIMVFBINDEX8\fR without a CLT
PPM	24-bit RGB	\fBIMVFBRGB\fR without a CLT
RPBM	1-bit monochrome	\fBIMVFBMONO\fR without a CLT
RPGM	8-bit color index	\fBIMVFBINDEX8\fR without a CLT
RPPM	24-bit RGB	\fBIMVFBRGB\fR without a CLT
.TE
.if t .in -0.5i
.if n .in -5
.LP
Header white space, and comments starting with # and extending to the end of
the line are ignored.
White space and comments are not allowed within the raw binary image body.
.SS "Writing RPNM image files"
The SDSC image library can write PBM+ suite files in the
following configurations:
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l l.
\fBMapped from VFB	Depth/color	File format\fR
\fBIMVFBMONO\fR without a CLT	1-bit monochrome	RPBM
\fBIMVFBINDEX8\fR without a CLT	8-bit color index	RPGM
\fBIMVFBRGB\fR without a CLT	24-bit RGB	RPPM
.TE
.if t .in -0.5i
.if n .in -5
.LP
RGB images are always stored noninterlaced
(i.e., RGBRGBRGB...).  Scanline- and plane-interlaced modes are not
available in RPPM.
.LP
The PBM+ suite files support no compression schemes.
.LP 
Other image library VFB types are converted to one of the above types
prior to being written out.  See the \fBImFileWrite\fR(3IM) \fBman\fP
page for details.
.SH ERRORS
In addition to those listed for \fBImFileRead\fR(3IM),
\fBrpnm\fR file reading returns the following error codes: 
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEMAGIC	Bad magic number in image file
IMEMALLOC	Cannot allocate enough memory
IMESYNTAX	Premature EOF
IMESYS	System call error in read operation
.TE
.if t .in -0.5i
.if n .in -5
.LP
In addition to those for \fBImFileWrite\fR(3IM),
\fBrpnm\fR file writing returns the following error codes: 
.ne 2
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEMALLOC	Cannot allocate enough memory
IMESYS	System call error in write operation
.TE
.if t .in -0.5i
.if n .in -5
.SH DOCUMENTATION
\fBpbm\fP(5), \fBpgm\fP(5), and \fBppm\fP(5) from the PBM+ \fBman\fP
page set. 
.SH SEE ALSO
\fBImIntro\fR(3IM),
\fBImErrNo\fR(3IM),
\fBimconv\fR(1IM),
\fBimfile\fR(1IM),
\fBimformats\fR(1IM),
\fBimpbm\fR(3IM),
\fBimpgm\fR(3IM),
\fBimpnm\fR(3IM),
\fBimppm\fR(3IM),
\fBimrpbm\fR(3IM),
\fBimrpgm\fR(3IM),
\fBimrppm\fR(3IM)
.SH AUTHORS
Dave Nadeau and Don Doering
.br
San Diego Supercomputer Center
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
