'\"et
.if t .TH IMHIST 1IM "December 2, 1992" "San Diego Supercomputer Center" "IMAGE TOOLS" 
.if n .TH IMHIST 1IM "December 2, 1992" "SDSC" "IMAGE TOOLS"
.SH NAME
imhist  -  compute a histogram of an image
.SH SYNOPSIS
\fBimhist\fR [\fIoptions\fR] \fIinfilename\fR [\fIoutfilename\fR]
.SH DESCRIPTION
\fBimhist\fR reads each image in the input file and computes a histogram
by counting the number of occurrences of each unique color in the image.
A table of the computed data, sorted from high to low, plus a header of
general image statistics is written to the output file, or \fBstdout\fR if
no output file is given.
.SH OPTIONS
\fBimhist\fR has a variety of options in the following categories:
.LP
.RS +0.5i
.TS
l l.
File Selection	What input file to use
Format Selection	What image file format to use
Standard	Standard generic options on all SDSC tools
Output Control	What to output
Fields	What fields to use in computing the histogram
.TE
.RE
.LP
\fIFile Selection\fR, \fIFormat Selection\fR, and
\fIStandard\fR options are common to all SDSC image tools and are
discussed in depth in the \fBman\fP page for \fBimconv\fR(1IM).
.LP
All options can be abbreviated to the first few unique characters.
.LP
.SS "Output Options"
.LP
\fBimhist\fR computes a variety of image statistics, as well as a histogram
of image colors.  When complete, a report is written to the output file
or \fBstdout\fR that contains a header followed by the histogram
occurrence table.
.LP
The output report's header contains the following information:
.RS 0.5i
.LP
.TS
l l.
File:	image file name
Resolution:	image resolution
Number of Pixels:	number of pixels in image
Number of Combinations:	number of unique color combinations
Maximum:	maximum field value for each histogram field
Minimum:	minimum field value for each histogram field
Unique Values:	number of unique field values for each histogram field
Column headings	headings for columns in the histogram occurrence table
.TE
.RE
.LP
Printing of the header information may be suppressed by giving the
\fB-outnoheader\fR option.  By default the header information is output.
.LP
The histogram occurrence table gives a list of the unique color combinations
that occurred in the image, and a count of the number of times they occurred.
The table is sorted to place the most-often occurring colors at the top of
the table.  Table values are printed one color to a line starting with the
occurrence value, followed by the value of each histogram pixel field.
For example, the following are the first few lines of a histogram table
generated on a simple RGB image:
.RS 0.5i
.LP
.TS
l l l l.
 ...	 ...	 ...	 ...
Number	RED	GREEN	BLUE
1004	255	0	0
842	128	255	0
712	0	0	255
500	0	0	0
 ...	 ...	 ...	 ...
.TE
.RE
.LP
In this example, the histogram data shows that there were 1004 occurrences
of pixels with the RGB combination (255,0,0), and 842 occurrences of pixels
with an RGB value of (128,255,0).  And so on.
.LP
Calculation and printing of the histogram table may be suppressed by giving
the \fB-outnohistogram\fR option.  By default the histogram information is
output.
.LP
Sorting of the histogram occurrence data on pathological cases
can take as long as collecting the
data in the first place.  If sorting is not important to your use of the
data, you may suppress sorting by giving the \fB-outnosort\fR option.
By default the histogram occurrence data is sorted from most-often occurring
to least-often occurring.
.SS "Fields"
By default, \fBimhist\fR computes a histogram on all fields (red, green, blue,
alpha, color index, etc) in the input image.  Alternatively, the user may
direct \fBimhist\fR to specifically compute a histogram on selected image
fields, or virtual fields (such as hue, saturation, and intensity) by
selecting the fields of interest on the command-line.
.RS 0.5i
.LP
.TS
l l.
\fIField\fR	\fBUse\fR
_
\fB-red\fR	Compute on red values
\fB-green\fR	Compute on green values
\fB-blue\fR	Compute on blue values
_
\fB-index\fR	Compute on color indexes or grayscale values
\fB-mono\fR	Compute on monochrome values
\fB-alpha\fR	Compute on alpha values
_
\fB-hue\fR	Compute on hue values
\fB-saturation\fR	Compute on saturation values
\fB-intensity\fR	Compute on intensity values
.TE
.RE
.LP
Legal field selections depend upon the image type.  Color indexed images
(images that use a color lookup table) may have histograms computed on
their color indexes, RGB values (as looked up in their color lookup tables),
and HSI values (derived from RGB values looked up in the color lookup table).
.LP
RGB images may have histograms computed on RGB values or on HSI values
(derived from the RGB values).
.LP
Images with alpha channels may have histograms computed on alpha values.
.LP
Histograms may not be computed that mix color spaces/representations.  For
instance, histograms on \fB-red -index\fR or \fB-green -hue\fR don't make sense.
.SH NOTES
\fBimhist\fR computes correlated field histograms.  Each
color in the output histogram is a unique combination of the selected input
fields.  For instance, say an image has the following RGB colors:
.RS 0.5i
.LP
.TS
l l l.
RED	GREEN	BLUE
_
0	0	0
255	0	0
0	255	255
128	128	255
255	255	255
.TE
.RE
.LP
A histogram on the red field alone would report that there are 3 different
unique values:  0, 128, and 255.  Similarly, independent single-field
histograms on the green and blue fields would report that green has 0, 128, and
255 as unique values, and blue has just 0 and 255 as unique values.
.LP
A \fBcorrelated\fR histogram on all three fields, however, would report each
unique combination of red, green, and blue field values that occur in the
image.  The answer would be the table listed above.  In the table the second
and fifth colors both have red values of 255, but differ in their green and
blue components.  This makes them different colors, and thus different entries
in the histogram.
.LP
Non-correlated single-field histograms are handy if you just want to see how
many pixels have some amount of red in them.  However, what if you want to
know how many have yellow in them?  For that you need to correlate a histogram
showing red \fBand\fR green values.  Independent red and green histograms
wouldn't show you anything useful.
.LP
\fBimhist\fR may be used to compute either single-field histograms or
multiple-field correlated histograms.  To compute single-field histograms on
red and green, for instance, run \fBimhist\fR twice, once with the \fB-red\fR
option, and once with the \fB-green\fR option.  Alternatively, to compute a
red-green correlated histogram, run \fBimhist\fR with both the \fB-red\fR
and the \fB-green\fR options at the same time.
.LP
Computing single-field histograms is very quick and doesn't use much memory.
Computing multiple-field correlated histograms can take quite a bit longer
and use a lot more memory, depending upon the number of correlated fields,
the size of the image, and the number of unique color combinations in the
image.  The following table provides an idea of the memory explosion that
can result when computing correlated histograms.  The table's values are
based upon a worst case 1024 x 1280 image with every pixel a different color.
.RS 0.5i
.LP
.TS
l l l.
\fBNumber	Color	Internal\fR
\fBof Fields	Space	Memory Use\fR
_
1	RGBA	2K Bytes
1	HSI	10K Bytes
2	RGBA	328K Bytes
2	HSIA	4,000K Bytes
3	RGBA	9,175K Bytes
3	HSI	20,972K Bytes
4	RGBA	10,486K Bytes  
4	HSIA	22,283K Bytes
.TE
.RE
.LP
The memory use reported above is for intermediate data structures
internal to \fBimhist\fR.  This does not include storage in memory of the
image itself, nor any of the other administrative data structures needed.
.LP
Of note on this table is the use of some 22Mb for internal data when
computing an HSI-Alpha correlated histogram on a pathological case
1280 x 1024 image.  If your host doesn't have 22Mb (plus overhead)
of memory, or the equivalent in swap space, \fBimhist\fR will be unabled to
compute the histogram.  Every effort has been made in \fBimhist\fR to keep
memory use to a minimum.  This high use of memory for correlated histograms
cannot be avoided without resorting to temporary files for data storage,
and the attendant sever execution speed impact.
.LP
Please note again that this table was produced for a pathological image
that had a different color for every pixel.  Most images have considerably
fewer colors.  In typical use, memory will not be a problem.
.LP
Computation time for correlated histograms also goes up with the number
of correlated fields, the size of the image, and the number of unique colors.
The following table shows compute times running \fBimhist\fR on local disk
on a Silicon Graphics Indigo using uncompressed RGB images.
.RS 0.5i
.LP
.TS
c c c c c c c
c c c c c c c
l l l l l l l.
\fBSize	Field	# of Unique	Read	Compute	Write	Total\fR
\fB(pixels)	Choice	Colors	(sec)	(sec)	(sec)	(sec)\fR
_
64,000	R	7	<1	<1	<1	<1
64,000	RGB	14	<1	<1	<1	<1
64,000	H	10	<1	<1	<1	<1
64,000	HSI	14	1	1	1	1
_
90,000	R	140	<1	<1	<1	<1
90,000	RGB	256	<1	1	1	2
90,000	H	85	<1	<1	<1	<1
90,000	HSI	256	<1	5	5	10
_
490,000	R	254	4	1	1	5
490,000	RGB	149,942	4	210	20	234
490,000	H	355	4	5	2	11
490,000	HSI	149,942	4	345	68	417
_
1,000,000	R	217	7	2	1	10
1,000,000	RGB	7,256	7	9	3	19
1,000,000	H	284	7	7	1	15
1,000,000	HSI	7,256	7	32	7	46
.TE
.RE
.LP
Column one shows the number of pixels in the test image.  Column two gives
the fields used in computing the histogram.  Column three shows the number
of unique colors found.  Columns four, five, and six show execution times
for reading in the image, computing the histogram, and writing out the data
respectively.  The final column sums these execution times.
.LP
This table illustrates that larger images with larger numbers of unique
colors drastically increase the time it takes to compute a correlated
histogram.  This is to be expected.  The table also shows that computing
in the HSI domain, instead of RGB, takes longer.  This is due to the use
of floating point computations and RGB-to-HSI conversions everywhere.
.LP
Error messages are reported to \fBstderr\fR.
.SH EXAMPLES
Create a histogram of an image and output it to \fBstdout\fR:
.RS 0.5i
.LP
\fBimhist myimage.ras\fR
.RE
.LP
Create a histogram of just the red field:
.RS 0.5i
.LP
\fBimhist myimage.rgb -red\fR
.RE
.LP
Create a histogram of color indexes and write it to an output file:
.RS 0.5i
.LP
\fBimhist image.rgb -index report.text\fR
.RE
.LP
Create a histogram of the hue, saturation, and intensity fields:
.RS 0.5i
.LP
\fBimhist image.rgb -hue -saturation -intensity report.text\fR
.RE
.LP
Only output the header:
.RS 0.5i
.LP
\fBimhist image.rgb -outnohistogram header.text\fR
.RE
.LP
Only output the histogram data:
.RS 0.5i
.LP
\fBimhist image.rgb -outnoheader report.text\fR
.RE
.LP
Skip sorting of the histogram data:
.RS 0.5i
.LP
\fBimhist image.rgb -outnosort report.text\fR
.RE
.LP
.SH "SEE ALSO"
\fBImVfbHist\fR(3IM),
\fBImVfbStat\fR(3IM)
.sp 1
For information on SDSC's image library, see \fBimintro\fR(3IM). 
.sp 1
For information on the individual image file formats, see
their respective \fBman\fR pages:
\fBimbmp\fR (3IM),
\fBimcur\fR (3IM),
\fBimeps\fR (3IM),
\fBimgif\fR (3IM),
\fBimhdf\fR (3IM),
\fBimico\fR (3IM),
\fBimicon\fR (3IM),
\fBimiff\fR (3IM),
\fBimmpnt\fR (3IM),
\fBimpbm\fR (3IM),
\fBimpcx\fR (3IM),
\fBimpgm\fR (3IM),
\fBimpic\fR (3IM),
\fBimpict\fR (3IM),
\fBimpix\fR (3IM),
\fBimpnm\fR (3IM),
\fBimppm\fR (3IM),
\fBimps\fR (3IM),
\fBimras\fR (3IM),
\fBimrgb\fR (3IM),
\fBimrla\fR (3IM),
\fBimrle\fR (3IM),
\fBimrpbm\fR (3IM),
\fBimrpgm\fR (3IM),
\fBimrpnm\fR (3IM),
\fBimrppm\fR (3IM),
\fBimsynu\fR (3IM),
\fBimtga\fR (3IM),
\fBimtiff\fR (3IM),
\fBimviff\fR (3IM),
\fBimx\fR (3IM),
\fBimxbm\fR (3IM),
\fBimxwd\fR (3IM)
.SH AUTHOR
Dave Nadeau and Chris Groening
.br
San Diego Supercomputer Center
.LP
See the individual file format \fBman\fR pages for the authors of the underlying
format read and write code.  The names of these \fBman\fR pages begin
with the letters "im" followed by the format name.
For example, the name of the TIFF \fBman\fR page is \fBimtiff\fR.
To display it, enter \fBman imtiff\fR.
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
