'\"t
.if t .TH IMFILE 1IM "October 13, 1992" "San Diego Supercomputer Center" "IMAGE TOOLS" 
.if n .TH IMFILE 1IM "October 13, 1992" "SDSC" "IMAGE TOOLS"
.SH NAME
imfile  -  Discerns the image format of a file or files
.SH SYNOPSIS
\fBimfile\fR [\fIoptions\fR] \fIfilename1 filename2 ...\fR
.SH DESCRIPTION
\fBimfile\fR attempts to discern the image format of each 
file listed on the command line, much like the UNIX \fBfile\fR(1) utility.
\fBimfile\fR outputs the name of the file and its image file format to 
\fBstdout\fR.
.SH OPTIONS
Invoke \fBimfile\fR with one or more filenames, optionally
preceded by the \fB-infile\fR argument:
.RS +0.5i
.sp 1
.nf
\fBimfile -infile picture.pix newpic.ras\fR
    or
\fBimfile picture.pix newpic.ras\fR
.fi
.RE
.LP
\fBimfile\fR checks each file for a magic number and file
name extension, then prints to \fBstdout\fR its conclusions about the file's
format.  When the \fB-long\fR option is given, \fBimfile\fR reads in each
image file and prints to \fBstdout\fR additional information about the file.
\fB-long\fR information includes the file's format and format version (if
applicable), the number of images contained in the file, image resolution,
image type (color indexed, RGB, etc), the size of its color table (if any),
the type of image compression used by the file, and other data relevant to
the particular image file format.
.LP
\fBimfile\fR also recognizes the following standard SDSC options:
.LP
\fB-feedback\fR
.RS +0.5i
Creates a software feedback (bug report) form in the file \fBimfile\fB.fbk.0\fR.
.RE
.LP
\fB-fullhelp\fR
.RS +0.5i
Displays a detailed list of the arguments and how to use \fBimfile\fR.
.RE
.LP
\fB-help\fR
.RS +0.5i
Displays an abbreviated list of the arguments and how to use \fBimfile\fR.
.RE
.LP
\fB-register\fR
.RS +0.5i
Creates a software-user registration form in the file \fBimfile\fB.reg.0\fR.
.RE
.LP
\fB-version\fR
.RS +0.5i
Displays the version number and copyright for \fBimfile\fR.
.RE
.LP
All options can be abbreviated to the first few unique characters.
.SH NOTES
\fBimfile\fR discerns the type of a file first by checking the file's magic
number against a magic number list for known image formats.
If the magic number doesn't match any of those in the list, \fBimfile\fR
looks at the filename's suffix (the characters following the last
period in the filename) and checks it against a list of known image filename
suffixes.
.LP
If \fBimfile\fR cannot determine the format of a file, it outputs the
string "Unknown image file format."
.SH EXAMPLES
Determine the types of three files:
.RS 0.5i
.LP
\fBimfile thing1.pix thing2.hdf dr.who\fR
.RE
.LP
The above command outputs:
.RS 0.5i
.LP
.TS
l l.
thing1.pix:	'pix', Alias image file, Alias Research, Inc.
thing2.hdf:	'hdf', Hierarchical Data File, NCSA
dr.who:	Unknown image file format
.TE
.sp
.RE
.LP
Display specific information about two image files using \fB-long\fR:
.RS 0.5i
.LP
\fBimfile walking.pict dolphin.pix\fR
.RE
.LP
The above command outputs:
.RS 0.5i
.LP
.TS
l l s
l l l
l l l
l l l
l l l
l l l
l l l
l l s
l l l.
walking.pict:	'pict', Apple Macintosh QuickDraw/PICT file, Apple Computer, Inc.
	Version:	2 (32-bit QuickDraw PICT2)
	Byte Order:	Most Significant Byte First
	Resolution:	646 x 470
	Type:	8-bit Color Indexed
	Color Table:	237 Entries
	Compression Type:	Apple Macintosh PackBits
dolphin.pix:	'pix', Alias image file, Alias Research, Inc.
	Byte Order:	Most Significant Byte First
	Resolution:	420 x 420
	Type:	24-bit RGB
	Compression Type:	Run Length Encoded (RLE)
.TE
.sp
.RE
.SH "SEE ALSO"
\fBimformats\fR (1IM)
.sp 1
For information on SDSC's image library, see \fBimintro\fR(3IM). 
.sp 1
For information on the individual image file formats, see
their respective \fBman\fR pages:
\fBimbmp\fR (3IM),
\fBimcur\fR (3IM),
\fBimeps\fR (3IM),
\fBimgif\fR (3IM),
\fBimhdf\fR (3IM),
\fBimico\fR (3IM),
\fBimicon\fR (3IM),
\fBimiff\fR (3IM),
\fBimmpnt\fR (3IM),
\fBimpbm\fR (3IM),
\fBimpcx\fR (3IM),
\fBimpgm\fR (3IM),
\fBimpic\fR (3IM),
\fBimpict\fR (3IM),
\fBimpix\fR (3IM),
\fBimpnm\fR (3IM),
\fBimppm\fR (3IM),
\fBimps\fR (3IM),
\fBimras\fR (3IM),
\fBimrgb\fR (3IM),
\fBimrla\fR (3IM),
\fBimrle\fR (3IM),
\fBimrpbm\fR (3IM),
\fBimrpgm\fR (3IM),
\fBimrpnm\fR (3IM),
\fBimrppm\fR (3IM),
\fBimsynu\fR (3IM),
\fBimtga\fR (3IM),
\fBimtiff\fR (3IM),
\fBimviff\fR (3IM),
\fBimx\fR (3IM),
\fBimxbm\fR (3IM),
\fBimxwd\fR (3IM)
.SH AUTHOR
Dave Nadeau
.br
San Diego Supercomputer Center
.LP
See the individual file format \fBman\fR pages for the authors of the underlying
format read and write code.  The names of these \fBman\fR pages begin
with the letters "im" followed by the format name.
For example, the name of the TIFF \fBman\fR page is \fBimtiff\fR.
To display it, enter \fBman imtiff\fR.
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR 
.br
