'\"t
.if t .TH IMCONV 1IM "August 26, 1992" "San Diego Supercomputer Center" "IMAGE TOOLS" 
.if n .TH IMCONV 1IM "August 26, 1992" "SDSC" "IMAGE TOOLS"
.SH NAME
imconv  -  Convert between image file formats
.SH SYNOPSIS
\fBimconv\fR [\fIoptions\fR] \fIinfilename\fR \fIoutfilename\fR
.SH DESCRIPTION
With no recognized standard, most commercially available
image-handling applications use their own custom image file format to
store pixel data.  To use imagery generated by one application as 
input into another is complicated by the need to convert from one
custom file format to another. 
.LP
The SDSC image tools are tools developed at the
San Diego Supercomputer Center (SDSC) to handle image manipulation and
file format conversion for a wide range of file formats.
.LP
\fBimconv\fR converts an input image file with one format
to an output image file with a different format.  If the input file
contains multiple images, so will the output file, if its format can
support it.
.SH OPTIONS
\fBimconv\fR has a variety of options in the following four categories:
.LP
.RS +0.5i
.TS
l l.
File Selection	What input and output files to use
Format Selection	What image file format to use
Format Control	What variant of a file format to generate
Standard	Standard generic options on all SDSC tools
.TE
.RE
.LP
These categories are discussed separately below.
.LP
All options can be abbreviated to the first few unique characters.
.LP
.SS "File Selection Options"
\fBimconv\fR needs to know where to read image information
and where to write it.  So, in its simplest form, it requires only 
the input and output filenames as follows:
.RS +0.5i
.sp
\fBimconv picture.pix newpic.ras\fR
.RE
.LP
\fBimconv\fR assumes the first filename is the input file and the second the
output file.
.LP
You may optionally precede the input and output filenames by \fB-infile\fR,
and \fB-outfile\fR, respectively.
For instance:
.RS +0.5i
.sp
\fBimconv -infile picture.pix -outfile newpic.ras\fR
.RE
.LP
To direct \fBimconv\fR to read from \fBstdin\fR or write to \fBstdout\fR, use a
filename consisting of a single dash (-).
.RS +0.5i
.sp
.nf
\fBimconv -pix - newpic.ras < picture.pix\fR
    or
\fBimconv picture.pix -ras - > newpic.ras\fR
    or
\fBimconv -pix - -ras - < picture.pix > newpic.ras\fR
    or
\fBcat picture.pix | imconv -pix - -ras - | cat > newpic.ras\fR
.fi
.RE
.LP
When reading from \fBstdin\fR or writing to \fBstdout\fR,
you must indicate the format of the image
file explicitly with options like \fB-pix\fR and
\fB-ras\fR above.  These options 
are discussed in more detail in the next section.
.SS "Format Selection Options"
\fBimconv\fR supports the following image file formats:
.RS +0.5i
.ne 6
.sp
.TS
c s l
l l l.
\fBFormat Names\fR
\fBPrimary\fR	\fBOthers\fR	\fBDescription\fR
_
bmp	-	Microsoft Windows BitMaP file
cur	-	Microsoft Windows CURsor file
eps	epi, epsf, epsi	Adobe Encapsulated Postscript file
gif	giff	CompuServe Graphics Image Format File
hdf	df, ncsa	Hierarchical Data Format file
ico	-	Microsoft Windows ICOn file
icon	cursor, pr	Sun Icon and Cursor file
iff	vff, suniff, taac	Sun TAAC Image File Format
mpnt	macp, pntg	Apple Macintosh MacPaint file
pbm	-	Portable Bit Map file
pcx	pcc	ZSoft PC Paintbrush file
pgm	-	Portable Grayscale Map file
pic	picio, pixar	PIXAR PICture file
pict	pict2	Apple Macintosh QuickDraw/PICT picture file
pix	alias	Alias PIXel image file
pnm	-	Portable aNy Map file
ppm	-	Portable Pixel Map file
ps	postscript	PostScript image file
ras	sun, sr, scr	Sun RASterfile
rgb	iris, sgi	Silicon Graphics RGB image file
rla	rlb	Wavefront raster image file
rle	-	Utah Run-Length-Encoded image file
rpbm	-	Raw Portable Bit Map file
rpgm	-	Raw Portable Grayscale Map file
rpnm	-	Raw Portable aNy Map file
rppm	-	Raw Portable Pixel Map file
synu	-	Synu image file
tga	vda, ivb	Truevision Targa image file
tiff	tif	Tagged Image File
viff	xv	Khoros's Virtual Image File Format
x	avs	AVS X image file
xbm	bm	X11 Bit Map file
xwd	x11	X11 Window Dump image file
.TE
.RE
.LP
For \fBimconv\fR to read or write an image file, it must know which
of the above formats it is reading or writing.  
In most cases, \fBimconv\fR can determine your
intent by looking at the input and output filenames.
For instance:
.RS +0.5i
.sp
\fBimconv picture.pix mypic.ras\fR
.RE
.LP
To determine the format of \fBpicture.pix\fR,
\fBimconv\fR opens it and looks at the first
few bytes of the file.  It checks these against a list of "magic numbers"
for various image file formats.
If it finds no match,
\fBimconv\fR extracts the filename suffix (\fB.pix\fR from \fBpicture.pix\fR)
and compares it against a list of known suffixes for supported image 
file formats.
.LP
To determine the format to use for \fBmypic.ras\fR, \fBimconv\fR extracts
the output filename suffix (\fB.ras\fR from \fBmypic.ras\fR) and compares
it against a list of suffixes for supported image file formats. 
.LP
If \fBimconv\fR cannot discern what format to use, it issues
an error message and exits.
.LP
On occasion it is necessary to override \fBimconv\fR's file format assumptions.
To do so, you must specify an explicit format option preceding 
an input or output filename.
For instance:
.RS +0.5i
.sp
\fBimconv -pix picture.pix -ras mypic.ras\fR
.sp
.RE
.LP
This is required when reading from \fBstdin\fR or writing to
\fBstdout\fR.
In either case \fBimconv\fR has no filename from which to extract
a filename suffix and, therefore, cannot discern what format to use.  
.LP
The first column in the format table above gives the most commonly
used filename suffix for each of the supported image file formats. 
Because multiple filename suffixes are in common use for a given file
format, \fBimconv\fR recognizes a variety of names for each format.
These additional names are given in the second column of the table.
You can obtain a complete list of the image format names (filename
suffixes and format options) by entering \fBimconv\fR with the
\fB-fullhelp\fR option, as follows:
.RS +0.5i
.sp
\fBimconv -fullhelp\fR
.sp
.RE
.LP
You can use any of these names, preceded by a dash, 
to specify the input and output formats.
If used, the format selection 
option must precede the filename to which
it refers.
.LP
You can obtain more information on the file formats by using
\fBimformats\fR(1IM) with the \fB-long\fR option, as follows:
.RS +0.5i
.sp
\fBimformats -long\fR
.sp
.RE
.SS "Format Control Options"
Virtually all image file formats have multiple variants.  These variants
have different image depths, different compression schemes, different
RGB image interleave methods, inclusion or exclusion of color lookup
tables (CLTs) and alpha planes, and so on.  In most cases \fBimconv\fR 
picks the correct variant to use when writing the output file.
However, in some cases you may wish to override \fBimconv\fR's
defaults and select a variant explicitly using the following format
control options: 
.LP
\fB-outindex\fR
.br
\fB-outrgb\fR
.RS +0.5i
.LP 
Output to color index or RGB image, respectively.
.LP
Typically, image pixels are represented as color index (pseudo-color) or
RGB (true-color) values.
.LP
A color index is a small integer (usually 8- or 12-bits)
that indexes into an associated color lookup table (CLT) to get the 
red-green-blue (RGB) color value for a pixel in the image.
A color index image is often refered to as a "pseudo-color" image because
the color for a given pixel is found in the CLT, not in the pixel data
itself. 
.LP
An RGB image stores the red-green-blue (RGB) value for a pixel's color
for every pixel in the image.  There is no associated CLT.  RGB images
are often refered to as "true-color" because the full color
description (RGB value) is stored in each pixel.
.LP
\fB-outindex\fR forces \fBimconv\fR to convert the incoming image to a
color index image before writing it to the output file.  If the output
file format cannot support storing a color index image, then
\fBimconv\fR reports an error and exits.
.LP
\fB-outrgb\fR forces \fBimconv\fR to convert the incoming image to an
RGB image before writing it to the output file.  If the output file
format cannot support storing an RGB image, then \fBimconv\fR reports
an error and exits. 
.LP
By default, if the input file's image is a color index image, \fBimconv\fR
tries to write it out as a color index image.  Similarly, if the input
file's image is an RGB image, \fBimconv\fR tries to write it out as an
RGB image.  If the output format doesn't support what \fBimconv\fR wants,
\fBimconv\fR automatically converts the image to one of the supported
output file format variants.
.RE
.LP
\fB-outchandepth\fR \fInbits\fR
.RS +0.5i
.LP
Specify output depth.
.LP
Some file formats allow color indexes and RGB values to be stored with
a specific number of "bits-per-channel".  While 8 bits-per-channel is
by far the most common, some formats support 1, 4, 12, 16, 24,
and 32 bits-per-channel. 
.LP
A color index image has 1 channel (the index into the color lookup
table); an RGB image has 3 channels (red, green, and blue).  The
channel depth is the number of bits \fIfor each channel\fP.  So, an RGB
image with an 8-bit channel depth takes 3 * 8 = 24 bits per pixel.  An
RGB image with a 24-bit channel depth takes 3 * 24 = 72 bits per pixel.
.LP
The \fInbits\fR argument to the \fB-outchandepth\fR is the number of
bits to use per channel when writing out the image.  If the output
file format cannot support the number of bits per channel you specify,
\fBimconv\fR reports an error and exits.
.LP
By default, \fBimconv\fR chooses the best number based on the
number of bits per channel used by the incoming image.  If an input file's
image uses a 16-bit color index, \fBimconv\fR tries to output the image
using a 16-bit, or more, color index.  Truncation occurs only if the
output format cannot support the incoming image's number of bits per
channel, or anything larger.  In fact, in the case of color index images,
if \fBimconv\fR is given the choice of truncating a 16-bit color index
image to 8 bits or converting it to RGB for the same output format,
\fBimconv\fR converts it to RGB.  \fBimconv\fR always chooses the path
with the least degradation of the data.
.RE
.LP
\fB-outnchan\fR \fInchan\fR
.RS +0.5i
.LP
Select number of output channels.
.LP
The number of channels in an image is the number of values stored per
pixel.  A color index image has 1 channel (the color index into the color lookup
table).  
An RGB
image has 3 channels (red, green, and blue).  
Though channel numbers other than 1 or 3 are possible, in practice they aren't
used.  (We don't count the alpha channel.)
.LP
The \fInchan\fR argument to the \fB-outnchan\fR option selects the number of
channels per pixel (not including the alpha channel) to use when writing the image.
.LP
This option is provided as a path towards future functionality.  In the
present release, this option provides the same information as 
the \fB-outindex\fR and \fB-outrgb\fR options.
.RE
.LP
\fB-outclt\fR
.br
\fB-outnoclt\fR
.RS +0.5i
.LP
Do or don't output a color lookup table (CLT).
.LP
Color index images usually have a CLT associated with
them.   RGB images can also have them, though less commonly.
.LP
Some image file formats allow the CLT to be left out of the image
file.  The \fB-outnoclt\fR option directs \fBimconv\fR to not write  
the CLT.  The \fB-outclt\fR option directs \fBimconv\fR to 
write the CLT.  
.LP
Some formats require the CLT to be included in the file.  In such cases, 
if you specify 
the \fB-outnoclt\fR option, \fBimconv\fR reports an error and
exits, since it is unable to comply with your request.
.LP
In much rarer cases, some formats do not allow a CLT to be stored in the
image file.  If you specify the \fB-outclt\fR option, \fBimconv\fR reports
an error and exits.
.LP
If the incoming image does not have a CLT but you specify \fB-outclt\fR,
\fBimconv\fR writes a ramping CLT (low to high).
This is most common when reading in a grayscale image (color index image
without a CLT) and writing out a color image (color index image with a
gray ramp for a CLT).
.LP
By default, if the incoming image has a CLT, \fBimconv\fR attempts to store 
it.  If the output format cannot store a CLT but can store an RGB
image, \fBimconv\fR automatically converts a color index image to an
RGB image and stores it that way.
.RE
.LP
\fB-outalpha\fR
.br
\fB-outnoalpha\fR
.RS +0.5i
.LP 
Do or don't output an alpha channel.
.LP
An alpha channel
contains a coverage value for each image pixel and 
typically is used when compositing images.  For instance, to make image ABC
partially cover XYZ, parts of ABC are marked as opaque (they cover XYZ),
while other parts are transparent (XYZ shows through).
.LP
Alpha values typically range from 0 to 255. 0 means transparent, 255 opaque. 
Values between 0 and 255 indicate partial transparency and direct
compositing software to mix the color of the image on top with the color of
the image below, using the alpha value as a weighting factor.
.LP
\fB-outalpha\fR directs that an alpha channel be output for the
image.  If \fB-outalpha\fR is given and the output format cannot
support an alpha channel (most cannot),
\fBimconv\fR reports an error and exits.
.LP
\fB-outnoalpha\fR directs that an alpha channel not be output.
If \fB-outnoalpha\fR is given and the output format must have
an alpha channel (rare), \fBimconv\fR 
reports an error and exits.
.LP
If the incoming image does not have an alpha channel but you specify 
\fB-outalpha\fR,
\fBimconv\fR automatically generates an opaque alpha channel (all 255s).
.LP
By default, if the incoming image has an alpha channel, \fBimconv\fR tries
to write it out.  For some 
file formats, only RGB images, not color index images, can be stored with
alpha channels. In such cases, if the incoming
image is a color index image with an alpha channel, \fBimconv\fR 
automatically converts the image to RGB to preserve the alpha channel.
.RE
.LP
\fB-outinterleave\fR \fImethod\fR
.RS +0.5i
.LP
Specify interleave method.
.LP
This option only applies to RGB images.
.LP
RGB images are written out using one of the following three methods:
.RS +0.5i
.sp
.TS
l l.
noninterleaved	RGBRGBRGBRGB...
scanline-interleaved	RR..GG..BB..RR..GG..BB...
plane-interleaved	RRRR..GGGG..BBB..
.TE
.RE
.LP
Some formats support all three methods.  Other formats support only one
or two.
The \fB-outinterleave\fR option takes one of the following arguments:
.RS +0.5i
.sp
.TS
l l.
\fBnone\fR	noninterleaved
\fBline\fR	scanline-interleaved
\fBplane\fR	plane-interleaved
.TE
.RE
.LP
If the output format does not support the interleave method you select,
\fBimconv\fR reports an error and exits.
.LP
By default, \fBimconv\fR chooses the most efficient or
most widely used interleave
method for the output format.  In most cases \fBimconv\fR chooses 
plane-interleaved
over scanline-interleaved, and scanline-interleaved over
noninterleaved.  This is because image compression schemes (see
below) work better on plane- and scanline-interleaved images, thus
reducing the 
amount of disk space an image file requires.
.RE
.LP
\fB-outcompress\fR \fIscheme\fR
.RS +0.5i
.LP
Specify compression scheme.
.LP
Most image file formats support compression schemes to reduce the size of
a file.  Some formats even support multiple compression schemes.
.LP
The single argument to the \fB-outcompress\fR option is the name
of the compression scheme to use:
.RS +0.5i
.sp
.TS
l l.
\fBnone\fR	noncompressed
\fBlzw\fR	Limpel-Ziv & Welsh compressed
\fBpb, packbits, mac\fR	Apple Macintosh Packbits
\fBrle\fR	Run-Length-Encoded
.TE
.RE
.LP
Noncompressed images store each image pixel as a value or values in
the file.  No tricks are applied to reduce the disk space
requirements.  Noncompressed image files take longer to write out and
read in, and they use up more disk space (often several times as much as a
wellcompressed image). 
.LP
Compression schemes use trickery to reduce the storage requirements of the
image.  The most common among these is Run-Length Encoding (RLE).  RLE
is based on the fact that most images have runs of adjacent pixels of
the same color, such as solid color image backgrounds.  These runs can
be abbreviated to just a count of the number of pixels in the run, and
the color to use for the run.  Runlength-encoded images usually take
30-50% less disk space. 
.LP
Most image formats support some 
variant of RLE compression.  Since these variants are
similar, \fBimconv\fR refers to them all as "rle compression."
.LP
Limpel-Ziv & Welsh and Apple's Packbits compression are
fancier and too complex to explain here.
.LP
If the output format does not support the form of compression you select
with the \fB-outcompress\fR option, \fBimconv\fR reports an error and exits.
.LP
By default, \fBimconv\fR chooses the most efficient
or most widely used compression
scheme supported by the output file format.
.RE
.LP
Most image file formats only support a subset of the functionality represented
by \fBimconv\fR's options.  In rare cases, the format may support the
functionality, but \fBimconv\fR does not.  For a list of what is 
supported, enter \fBimformats\fR(1IM) with the \fB-long\fR option, as follows:
.RS +0.5i
.sp
\fBimformats -long\fR
.RE
.LP
For greater detail, you may specify the \fB-long\fR option twice, as
follows:
.RS +0.5i
.sp
\fBimformats -long -long\fR
.RE
.SS "Standard Options"
\fBimconv\fR recognizes the following standard SDSC options:
.LP
\fB-feedback\fR
.RS +0.5i
Create a software feedback (bug report) form in the file \fBimconv\fB.fbk.0\fR.
.RE
.LP
\fB-fullhelp\fR
.RS +0.5i
Display a detailed list of the arguments and how to use \fBimconv\fR.
.RE
.LP
\fB-help\fR
.RS +0.5i
Display an abbreviated list of the arguments and how to use \fBimconv\fR.
.RE
.LP
\fB-register\fR
.RS +0.5i
Create a software user registration form in the file \fBimconv\fB.reg.0\fR.
.RE
.LP
\fB-verbose\fR
.RS +0.5i
Display progress messages to \fBstdout\fR during the course of the
image file conversion.
.RE
.LP
\fB-version\fR
.RS +0.5i
Display the version number and copyright for \fBimconv\fR.
.RE
.SH NOTES
Error messages are reported to \fBstderr\fR.
.LP
The conversions take varying lengths of time depending upon the complexity
of the input and output file formats and the complexity of the image itself.
.LP
Some file formats create a temporary file in \fB/usr/tmp\fR when reading
from \fBstdin\fR or writing to \fBstdout\fR.
.LP
Some file formats, such as PostScript, cannot be used for input.
.LP
Typically, you don't need to use 
the various channel depth, interleave method, and compression
scheme options.  \fBimconv\fR does a good job of figuring out
how to get the input file's image stored into the output file with a minimum
loss of information, if any at all.  If anything, \fBimconv\fR is overly 
zealous about avoiding loss of information.  Consider this scenario:  
An input file contains a color index image 
with a CLT.  The selected output format supports
both color index (with or without CLT) and RGB images.  The user enters the
following command line:
.RS +0.5i
.sp
\fBimconv input.ras -outnoclt output.hdf\fR
.RE
.LP
What type of image is stored in \fBoutput.hdf\fR?  The answer:  An RGB image,
even though the incoming image was a color index image!
.LP
The intent of the user typing in the above command might be
to strip off the CLT and write
the color index image to the output file.  However, \fBimconv\fR interprets
the \fB-outnoclt\fR option literally.  \fB-outnoclt\fR means a CLT
should not be output.  But it gives no information 
about how image pixels should be
stored.  To avoid
loss of information yet satisfy the user's request, \fBimconv\fR's only recourse
is to convert the image to RGB.
.LP
To strip off the CLT but preserve the image as a
color index image, enter the following command line instead:
.RS +0.5i
.sp
\fBimconv input.ras -outindex -outnoclt output.hdf\fR
.RE
.SH EXAMPLES
To convert an Alias \fBpix\fR file to an \fBhdf\fR file, enter any of the following
command lines:
.RS 0.5i
.LP
.nf
\fBimconv picture.pix picture.hdf\fR
    or
\fBimconv -pix picture.pix -hdf picture.hdf\fR
    or
\fBimconv -pix - picture.hdf < picture.pix\fR
    or
\fBimconv -pix picture.pix -hdf - > picture.hdf\fR
    or
\fBimconv -pix - -hdf - < picture.pix > picture.hdf\fR
    or
\fBcat picture.pix | imconv -pix - -hdf - | cat > picture.hdf\fR
.fi
.RE
.LP
To convert an RGB image stored in a \fBpix\fR format file to an RGB image stored
in a \fBras\fR format file, enter the following:
.RS +0.5i
.sp
\fBimconv truecolor.pix truecolor.ras\fR
.RE
.LP
To convert the same RGB \fBpix\fR file image to an 8-bit-per-channel color
index image in a \fBras\fR file, enter any of the following:
.RS +0.5i
.sp
.nf
\fBimconv truecolor.pix -outindex -outchandepth 8 -outnchan 1 pseudocolor.ras\fR
    or
\fBimconv truecolor.pix -outindex -outchandepth 8 pseudocolor.ras\fR
    or
\fBimconv truecolor.pix -outindex pseudocolor.ras\fR
.fi
.RE 
.LP
To select Apple Macintosh Packbits compression and plane-interleaved
RGB storage for a \fBtiff\fR file, enter any of the following:
.RS +0.5i
.sp
.nf
\fBimconv picture.pix -outcomp pb -outinter plane picture.tiff\fR
    or
\fBimconv picture.pix -outcomp packbits -outinter plane picture.tiff\fR
    or
\fBimconv picture.pix -outcomp mac -outinter plane picture.tiff\fR
.fi
.RE
.LP
To read in an uncompressed Sun Rasterfile and compress it into a new file,
enter the following:
.RS +0.5i
.sp
\fBimconv uncompressed.ras -outcomp rle compressed.ras\fR
.RE
.LP
To convert a Macintosh \fBpict\fR file drawing into an X Window System Bit
Map for use as an icon, cursor, or whatever, enter the following:
.RS +0.5i
.sp
\fBimconv icon.pict icon.xbm\fR
.RE
.SH "SEE ALSO"
\fBimfile\fR(1IM),
\fBimformats\fR(1IM),
\fBimgray\fR(1IM),
\fBimmono\fR(1IM)
.sp 1
For information on SDSC's image library, see \fBimintro\fR(3IM). 
.sp 1
For information on the individual image file formats, see
their respective \fBman\fR pages:
\fBimbmp\fR (3IM),
\fBimcur\fR (3IM),
\fBimeps\fR (3IM),
\fBimgif\fR (3IM),
\fBimhdf\fR (3IM),
\fBimico\fR (3IM),
\fBimicon\fR (3IM),
\fBimiff\fR (3IM),
\fBimmpnt\fR (3IM),
\fBimpbm\fR (3IM),
\fBimpcx\fR (3IM),
\fBimpgm\fR (3IM),
\fBimpic\fR (3IM),
\fBimpict\fR (3IM),
\fBimpix\fR (3IM),
\fBimpnm\fR (3IM),
\fBimppm\fR (3IM),
\fBimps\fR (3IM),
\fBimras\fR (3IM),
\fBimrgb\fR (3IM),
\fBimrla\fR (3IM),
\fBimrle\fR (3IM),
\fBimrpbm\fR (3IM),
\fBimrpgm\fR (3IM),
\fBimrpnm\fR (3IM),
\fBimrppm\fR (3IM),
\fBimsynu\fR (3IM),
\fBimtga\fR (3IM),
\fBimtiff\fR (3IM),
\fBimviff\fR (3IM),
\fBimx\fR (3IM),
\fBimxbm\fR (3IM),
\fBimxwd\fR (3IM)
.SH "KNOWN PROBLEMS"
Different formats use different terminology.  \fBimconv\fR uses generic
terminology.  If you're only familiar with format-specific terms, you may find
\fBimconv\fR confusing.
.LP
\fBimconv\fR supports selection of only the most common
format-specific variants.
For instance, you can't select how GIF 8-bit color index images should
be interlaced when stored (not the same as RGB interleaving).
.LP
When an input file has multiple images in it (such as HDF, GIF, or TIFF files),
the output file format must also support multiple images per file.
SDSC plans to implement tools in the near 
future to create and split multi-image
files.
.SH AUTHOR
Dave Nadeau
.br
San Diego Supercomputer Center
.LP
See the individual file format \fBman\fR pages for the authors of the underlying
format read and write code.  The names of these \fBman\fR pages begin
with the letters "im" followed by the format name.
For example, the name of the TIFF \fBman\fR page is \fBimtiff\fR.
To display it, enter \fBman imtiff\fR.
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
