'\"et
.if t .TH IMCAT 1IM "October 13, 1992" "San Diego Supercomputer Center" "IMAGE TOOLS"
.if n .TH IMCAT 1IM "October 13, 1992" "SDSC" "IMAGE TOOLS"
.SH NAME
imcat  -  Concatenates multiple image files into a single image file
.SH SYNOPSIS
\fBimcat\fR [\fIoptions\fR] \fIinfilenames...\fR \fIoutfilename\fR
.SH DESCRIPTION
\fBimcat\fR reads in each input image file, collects the image data from each,
and writes the entire set to the single, multi-image output file.  The
resulting output file will contain a concatenation of the data found in
each of the individual input files.
.LP
The input and output
image file formats may be different.  The output file format must support
the storage of multiple images in a single file.
.SH OPTIONS
\fBimcat\fR has a variety of options in the following five categories:
.LP
.RS +0.5i
.TS
l l.
File Selection	What input and output files to use
Format Selection	What image file format to use
Format Control	What variant of a file format to generate
Standard	Standard generic options for all SDSC tools
.TE
.RE
.LP
\fIFile Selection\fR, \fIFormat Selection\fR, \fIFormat Control\fR, and
\fIStandard\fR options are common to all SDSC image tools and are
discussed in depth in the \fBman\fP page for \fBimconv\fR(1IM).
However, unlike other image tools, \fBimcat\fR combines the standard
\fB-infile\fR and \fB-outfile\fR arguments into a single \fB-file\fR argument.
.LP
All options can be abbreviated to the first few unique characters.
.LP
.SS "Input File Names"
Input file names may be given explicitly or implicitly.  In an explicit
list, the user gives each image file name on the command-line for \fBimcat\fR.
The following are typical invocations of \fBimcat\fR using explicit file names:
.RS 0.5i
.LP
\fBimcat thing1.rgb thing2.hdf sam.ras i.pix. am.rla outputgroup.hdf\fR
.br
\fBimcat credits0.rgb credits1.rgb credits2.rgb outcredits.tiff\fR
.br
\fBimcat icons*.ico myicons.hdf\fR
.RE
.LP
File names may be given implicitly by providing a file name template
that contains the special character code "%d", like the C language
\fBprintf\fR(3) print format directive.  This template will be
used to generate a series of image file names by replacing the "%d" with
integer frame numbers, one after another.
The template \fBmyimage.%d.rgb\fR, for instance,
could generate the file names \fBmyimage.0.rgb\fR, \fBmyimage.1.rgb\fR,
\fBmyimage.2.rgb\fR, and so on.
.LP
The range of integer frame numbers used to generate input file names from
a template is given using the \fB-frames\fR \fIrange\fR option,
where the \fIrange\fR is a single value, or range of values, taking one
of the following forms:
.RS 0.5i
.LP
.TS
l l.
\fIrange\fR	\fBGenerate file names with frame numbers of\fR
_
\fIn\fR	\fIn\fR only (single value).
\fIn-m\fR	\fIn\fR through \fIm\fR (range of values).
.TE
.RE
.LP
There is no space between \fIn\fR, the dash, and \fIm\fR.  Also, \fIn\fR 
need not be a value less than \fIm\fR.
.LP
The following are typical invocations of \fBimcat\fR using an implicit
file name template and \fB-frames\fR:
.RS 0.5i
.LP
\fBimcat credits%d.rgb -frames 0-2 outcredits.tiff\fR
.br
\fBimcat -frames 0-200 movie.%03d.ras collection.hdf\fR
.br
\fBimcat -frames 200-0 movie.%03d.ras reversed.hdf\fR
.RE
.LP
Implicit and explicit file naming may be combined on the same command-line,
such as:
.RS 0.5i
.LP
\fBimcat title.rgb -frames 0-100 movie.%03d.rgb credit1.rgb copyright.rgb output.hdf\fR
.RE
.LP
\fB-frames\fR can only be given once.  If more than one implicit 
file name template is used on the same command-line, each use will 
use the same frame number range.
.LP
Image files are read in and placed into the output file in the order in
which they appear on the command-line.
.SH NOTES
.LP
Multi-image files created by \fBimcat\fR may be split into multiple
single-image files by \fBimsplit\fR(1IM).
.LP
Most image file formats cannot support the storage of multiple images in
the same file.  This is a limitation of the file format design, not
\fBimcat\fR.  \fBimcat\fR will issue an error message if the selected
output file format cannot support the storage of multiple images in
a single file.
.LP
\fBimformats\fR(1IM) may be used to display a list of
supported file formats and their attributes.  Use \fB-long -long\fR on
\fBimformats\fR(1IM) to display extensive format information
that indicates which file formats support multiple image storage.
.LP
Implicit file naming is most useful when concatenating multiple images from
an animation into a single, large, multi-image file.  In such cases, the
image files being concatenated usually include a frame number in the file name.
.LP
\fBimcat\fR uses the C language \fBsprintf\fR(3) routine to replace
the file name template's "%d" with successive image frame numbers.  The
use of \fBsprintf\fR(3) means the full range of "%d" format directive syntax
is available in generating input file names.  While the \fBsprintf\fR(3)
\fBman\fR page has full details on the "%d" print directive, the following is
a summary as it applies to input file naming:
.RS 0.5i
.LP
The "%d" directive has the following general syntax:
.RS 0.5i
.LP
 "\fB%\fR" [\fIflags\fR] [\fIdigit\fR] ["\fB.\fR" \fIprecision\fR] "\fBd\fR"
.RE
.LP
The directive always starts with a "\fB%\fR" character and ends with a "\fBd\fR"
character.
Field names between [ ]s in the syntax above are optional.  With no
optional field value, the simplest form of the directive is just "\fB%d\fR".
.IP \fIflags\fR
Following the "\fB%\fR" is an optional set of \fIflags\fR characters:
.RS 0.5i
.RS 0.5i
.LP
.TS
l l.
\fIflag\fR	\fBMeaning\fR
_
\fB-\fR	Left justify the frame number.  Default is right justified.
\fB+\fR	Begin with the sign (+ or -) of the frame number.  Default is just -.
\fB(blank)\fR	Use a blank instead of a + for positive frame numbers.
.TE
.RE
.LP
Except for peculiar file naming, users of \fBimcat\fR can omit the optional
\fIflags\fR portion of a print directive.
.RE
.IP \fIdigit\fR
Following the \fIflags\fR field is an optional \fIdigit\fR field that gives the
field width of the number, in characters.  If the number requires fewer
than this minimum, it will be padded on the right or left with blanks
(padding is controlled by the \fB-\fR \fIflag\fR above).  If the number requires
more than this minimum, it will be taken.
.RS 0.5i
_
The \fIdigit\fR field can be preceded by a 0 (zero) to cause padding to
be done with leading zeroes instead of blanks.  This is useful
when referring to frame numbers of the form "001," "002," "003," and so on.
.RE
.IP \fIprecision\fR
The \fIdigit\fR field may be optionally followed by a "\fB.\fR" (period)
and a \fIprecision\fR number that gives the minimum number of digits for
the frame number.  This isn't particularly useful for users of \fBimcat\fR
and can be skipped.
.LP
The following are a few typical "\fB%d\fR" directives for use in \fBimcat\fR:
.RS 0.5i
.LP
.TS
l l.
\fBDirective\fR	\fBUse in imcat\fP
.IP "\fB%d\fR"
No leading zeros or blanks.  Generates numbers like "0," "1," "2," "3," etc.
.IP "\fB%03d\fR"
Leading zeros to fill 3 characters, including the number.  Generates
numbers like "000," "001," "002," "003," etc.
.IP "\fB%.3d\fR"
Same effect as "\fB%03d\fR"
.RE
.RE
.LP
In order to concatenate the image data, \fBimcat\fR reads in every input
image file first, before writing any of it to the output file.  This can
take up quite a bit of memory.  If the host does not have enough memory
and swap space, \fBimcat\fR will fail with a memory allocation error.
.LP
In general, \fBtar\fR(1) is a better way of maintaining multi-image files
than using \fBimcat\fR.  Multi-image files created by \fBtar\fR(1)
can be extracted
one image at a time, or in any combination, and retain the original image
file names.  Multi-image files created by \fBimcat\fR can only be extracted
all at once, such as by using \fBimsplit\fR(1IM), and cannot retain the
original file names due to limitations in the output image file formats.
.LP
\fBtar\fR(1) and \fBimcat\fR multi-image files occupy about the
same amount of disk space and take about the same amount of time to be created
or split apart.  However, the format of \fBtar\fR(1) files is a fairly
universal standard, whereas the few image file formats supporting storage
of multiple images in one file (such as HDF) are less universal.
.LP
\fBimcat\fR is only provided for the relatively few situations where users
need to build multi-image files for use in other existing applications.
For simple storage and data management purposes, \fBtar\fR(1) is a
more appropriate tool.
.LP
For notes regarding file format conversion and standard image tool
options, see the \fBman\fP page on \fBimconv\fR(1IM).
.LP
Error messages are reported to \fBstderr\fR.
.SH EXAMPLES
Concatenate 6 Silicon Graphics RGB files named \fBsingle03\fR through
\fBsingle08\fR into a single multi-image HDF file:
.RS 0.5i
.LP
\fBimcat single%02d.rgb -frames 3-8 many.hdf\fR
.RE
.LP
Concatenate three differently named XWD images into a single TIFF file: 
.RS 0.5i
.LP
\fBimcat one.xwd tiger.xwd beer.xwd many.tiff\fR
.RE
.SH "SEE ALSO"
\fBimsplit\fR (1IM)
.sp 1
For information on SDSC's image library, see \fBimintro\fR(3IM). 
.sp 1
For information on the individual image file formats, see
their respective \fBman\fR pages:
\fBimbmp\fR (3IM),
\fBimcur\fR (3IM),
\fBimeps\fR (3IM),
\fBimgif\fR (3IM),
\fBimhdf\fR (3IM),
\fBimico\fR (3IM),
\fBimicon\fR (3IM),
\fBimiff\fR (3IM),
\fBimmpnt\fR (3IM),
\fBimpbm\fR (3IM),
\fBimpcx\fR (3IM),
\fBimpgm\fR (3IM),
\fBimpic\fR (3IM),
\fBimpict\fR (3IM),
\fBimpix\fR (3IM),
\fBimpnm\fR (3IM),
\fBimppm\fR (3IM),
\fBimps\fR (3IM),
\fBimras\fR (3IM),
\fBimrgb\fR (3IM),
\fBimrla\fR (3IM),
\fBimrle\fR (3IM),
\fBimrpbm\fR (3IM),
\fBimrpgm\fR (3IM),
\fBimrpnm\fR (3IM),
\fBimrppm\fR (3IM),
\fBimsynu\fR (3IM),
\fBimtga\fR (3IM),
\fBimtiff\fR (3IM),
\fBimviff\fR (3IM),
\fBimx\fR (3IM),
\fBimxbm\fR (3IM),
\fBimxwd\fR (3IM)
.SH AUTHOR
Chris Groening
.br
San Diego Supercomputer Center
.LP
See the individual file format \fBman\fR pages for the authors of the underlying
format read and write code.  The names of these \fBman\fR pages begin
with the letters "im" followed by the format name.
For example, the name of the TIFF \fBman\fR page is \fBimtiff\fR.
To display it, enter \fBman imtiff\fR.
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
