/* initial MOTIF interface */
#include <stdio.h>
#include <Xm/Xm.h>
#include <X11/Shell.h>
#include <Xm/MainW.h>
#include <Xm/DrawingA.h>
#include <Xm/RowColumn.h>
#include <Xm/PushBG.h>
#include <Xm/PushB.h>
#include <Xm/FileSB.h>
#include <Xm/Text.h>
#include <Xm/CascadeB.h>
#include <Xm/DialogS.h>
#include <Xm/RowColumn.h>
#include <Xm/MessageB.h>
XmStringCharSet def_charset = (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;
/* default sizes */
#define DEF_HT 512
#define DEF_WD 512
/* global window stuff */
extern Display *display_ptr; /* in xl.c */
extern Window window_id; /* in xl.c */
extern Window top_window_id; /* in xl.c */
#define BINARY_DEF "*.cgm"
#define CLEAR_DEF "*.cgmc"
static char *file_def = BINARY_DEF;

/* declare the widgets */
static Widget topLevel, main_window, menu_bar, file_menu, my_file,
  new_button, new_entry, quit_button, format_menu, format_option,
  next_button, binary_button, clear_text_button, draw_window, prev_button,
  redraw_button, caution_box, picture_menu;

static int n; /* argument counter */
static Arg arglist[10];	/* check that we don't need more */
static XWindowAttributes window_attributes; /* use to get window attributes */
static GC gc_id; /* graphical context */
static XGCValues values_struct; 
static Pixmap my_pixmap = NULL; /* pixmap for backig store */


/* forward declaration of callbacks */
static void Quit(Widget, Opaque, caddr_t); /* quit, close up */
static void binary_set(Widget, Opaque, caddr_t);
static void clear_set(Widget, Opaque, caddr_t); 
static void get_file_name(Widget, Opaque, caddr_t);
static void next_picture(Widget, Opaque, caddr_t);
static void redraw_picture(Widget, Opaque, caddr_t);
static void prev_picture(Widget, Opaque, caddr_t);
/* expose callback */
static void expose_window(Widget, Opaque, caddr_t);
/* file selection callbacks */
static void in_file_ok(Widget, Opaque, caddr_t); 
static void in_file_cancel(Widget, Opaque, caddr_t); 
static void in_file_help(Widget, Opaque, caddr_t); 
/* a few statics */
static unsigned int old_wd = 0, old_ht = 0;
#define BINARY_FORMAT 0
#define CLEAR_FORMAT 1
static int cgm_format, file_open;
/* interface to wint.c */
extern int wint_initialise();
extern int wopen_file();
extern int wdraw_next_page();
/* interface to the device */
#ifdef incxws
/* want xws driver */
extern xws_setup();		/* in xws.c */
extern xws_end(); /* in xl.c */
#define X_SETUP xws_setup
#define X_END xws_end
#else
/* default to xl driver */
extern xl_setup();		/* in xl.c */
extern xl_end(); /* in xl.c */
#define X_SETUP xl_setup
#define X_END xl_end
#endif

/* now the main program */
main(argc, argv)
     int argc;
     char **argv;
{
  /* get things initialised */

  if (!wint_initialise(argc, argv)) exit(0);

  topLevel = XtInitialize(argv[0], "Gplot", NULL, 0, &argc, argv);
  
  make_main_window(); /* make the main window */
  
  make_draw_window(); /* make the drawing window */
  
  make_menu_system(); /* make all of the options */
  XmMainWindowSetAreas(main_window, menu_bar, NULL, NULL, NULL, draw_window);
  
  XtRealizeWidget(topLevel); /* realise the system */
  display_ptr = XtDisplay(draw_window); /* store window specifics */
  window_id = XtWindow(draw_window);
  top_window_id = XtWindow(topLevel);

  if (!XGetWindowAttributes(display_ptr, window_id, &window_attributes)){
    fprintf(stderr, "couldn't get attributes\n");
    return;
  }
  old_wd = window_attributes.width;
  old_ht = window_attributes.height;
  /* get the default graphics context */
  gc_id = XCreateGC(display_ptr, window_id, 0, &values_struct);


  XtMainLoop(); /* enter main loop */
  
  return(0); /* never reached */
  
}
/* Callbacks */

/* get the new file name */
static void get_file_name(w, tag, call_data)
     Widget w;
     Opaque tag;
     caddr_t call_data;
{
  Widget my_file;
  
  /* create and manage the input file menu entry */
  n = 0;
  XtSetArg(arglist[n], XmNtitle,
	   XmStringCreate("Input File", def_charset)); ++n;
  XtSetArg(arglist[n], XmNdirMask,
	   XmStringCreate(file_def, def_charset)); ++n;
  XtSetArg(arglist[n], XmNdirSpec,
	   XmStringCreate("/tmp", def_charset)); ++n;
  my_file = XmCreateFileSelectionDialog(main_window, "my_file", arglist, n);

  /* add callbacks */
  XtAddCallback(my_file, XmNokCallback, in_file_ok, 0);
  XtAddCallback(my_file, XmNcancelCallback, in_file_cancel, 0);
  
  XtManageChild(my_file);
}
/* the Quit callback */
static void Quit(w, tag, call_data)
     Widget w;
     Opaque tag;
     caddr_t call_data;
{
  /* close up the device */
  X_END(0);
  XtCloseDisplay(display_ptr);
  exit(0);
}
/* the Binary callback */
static void binary_set(w, tag, call_data)
     Widget w;
     Opaque tag;
     caddr_t call_data;
{
  cgm_format = BINARY_FORMAT;
  file_def = BINARY_DEF;
}
/* the Clear callback */
static void clear_set(w, tag, call_data)
     Widget w;
     Opaque tag;
     caddr_t call_data;
{
  cgm_format = CLEAR_FORMAT;
  file_def = CLEAR_DEF;
}
/* picture callbacks */
static void next_picture(w, tag, call_data)
     Widget w;
     Opaque tag;
     caddr_t call_data;
{
  if (!file_open) return; /* do nothing */
  draw_picture(0);
}
static void redraw_picture(w, tag, call_data)
     Widget w;
     Opaque tag;
     caddr_t call_data;
{
  if (!file_open) return; /* do nothing */
  draw_picture(-1);
}
static void prev_picture(w, tag, call_data)
     Widget w;
     Opaque tag;
     caddr_t call_data;
{
  if (!file_open) return; /* do nothing */
  draw_picture(-2);
}
/* file selection callbacks */
static void in_file_ok(w, tag, info)
     Widget w;
     Opaque tag;
     caddr_t info;
{
  void info_error();
  XmString my_string;
  int status;
  unsigned int win_wd, win_ht, win_depth;
  char *result;

  my_string = ((XmFileSelectionBoxCallbackStruct *) info)->value;

  status = XmStringGetLtoR(my_string, def_charset, &result);
  if (status == False) {
    info_error("couldn't get file name");
    return;
  }
  XtUnmanageChild(w);
  file_open = wopen_file(result, cgm_format, X_SETUP);
  if (file_open) { /* must save new image */
    /* find out our size */
    if (!XGetWindowAttributes(display_ptr, window_id, &window_attributes)){
      fprintf(stderr, "couldn't get attributes\n");
      return;
    }
    
    win_wd = window_attributes.width;
    win_ht = window_attributes.height;
    win_depth = window_attributes.depth;    
    if ((old_wd != win_wd) || (old_ht != win_ht) || !my_pixmap) {
      /* need a new pixmap */
      if (my_pixmap) XFreePixmap(display_ptr, my_pixmap);
      my_pixmap = XCreatePixmap(display_ptr, window_id,
				win_wd, win_ht, win_depth);
      old_ht = win_ht;
      old_wd = win_wd;
    }
    
    /* now copy over the image */
    if (my_pixmap) XCopyArea(display_ptr, window_id, my_pixmap, gc_id,
			     0, 0, win_wd, win_ht, 0, 0);
  }
}
static void in_file_cancel(w, tag, call_data)
     Widget w;
     Opaque tag;
     caddr_t call_data;
{
  XtUnmanageChild(w);
}
static void in_file_help(w, tag, call_data)
     Widget w;
     Opaque tag;
     caddr_t call_data;
{
}
/* the expose callback */
static void expose_window(w, tag, call_data)
     Widget w;
     Opaque tag;
     caddr_t call_data;
{
  unsigned int win_wd, win_ht, win_depth;
  
  if (!file_open) return; /* nothing to show */

  /* see if we changed size */
  if (!XGetWindowAttributes(display_ptr, window_id, &window_attributes)){
    fprintf(stderr, "couldn't get attributes\n");
    return;
  }

  win_wd = window_attributes.width;
  win_ht = window_attributes.height;
  win_depth = window_attributes.depth;
  
  if ((old_wd != win_wd) || (old_ht != win_ht) || !my_pixmap) {
    /* draw the picture */
    draw_picture(-1);
    old_wd = win_wd;
    old_ht = win_ht;
  } else { /* can use stored image */
    if (my_pixmap) XCopyArea(display_ptr, my_pixmap, window_id, gc_id,
			      0, 0, win_wd, win_ht, 0, 0);
  }
  
}
static int draw_picture(page_shift)
     int page_shift;
{
  unsigned int win_wd, win_ht, win_depth;
  /* find out our size */
  if (!XGetWindowAttributes(display_ptr, window_id, &window_attributes)){
    fprintf(stderr, "couldn't get attributes\n");
    return;
  }

  win_wd = window_attributes.width;
  win_ht = window_attributes.height;
  win_depth = window_attributes.depth;

  if ((old_wd != win_wd) || (old_ht != win_ht) || !my_pixmap) {
    /* need a new pixmap */
    if (my_pixmap) XFreePixmap(display_ptr, my_pixmap);
    my_pixmap = XCreatePixmap(display_ptr, window_id,
			      win_wd, win_ht, win_depth);
    old_ht = win_ht;
    old_wd = win_wd;
  }

  wdraw_next_page(page_shift);
  /* now copy over the image */
  if (my_pixmap) XCopyArea(display_ptr, window_id, my_pixmap, gc_id,
	    0, 0, win_wd, win_ht, 0, 0);
  return(1);
}
static int make_main_window()
{
  /* create and manage the main window */
  n = 0;
  XtSetArg(arglist[n], XmNwidth, DEF_WD); ++n;
  XtSetArg(arglist[n], XmNheight, DEF_HT); ++n;
  main_window = XmCreateMainWindow(topLevel, "Main Window", arglist, n);
  XtManageChild(main_window);
  return(1);
}
static int make_draw_window()
{
  /* create and manage the drawing window */
  n = 0;
  XtSetArg(arglist[n], XmNwidth, DEF_WD); ++n;
  XtSetArg(arglist[n], XmNheight, DEF_HT); ++n;
  draw_window = XmCreateDrawingArea(main_window, "Draw Window", arglist, n);
  /* add a callback */
  XtAddCallback(draw_window, XmNexposeCallback, expose_window, 0);
  XtManageChild(draw_window);
  return(1);
}
static int make_menu_system()
{
  /* create the menu bar */
  n = 0;
  XtSetArg(arglist[n], XmNorientation, XmHORIZONTAL); ++n; 
  menu_bar = XmCreateMenuBar(main_window, "Menu Bar", arglist, n);
  
  /* create the File pulldown menu */
  n = 0;
  file_menu = XmCreatePulldownMenu(menu_bar, "File", arglist, n);
  
  /* make menu entries */
  n = 0;
  XtSetArg(arglist[n], XmNsubMenuId, file_menu); ++n;
  new_entry = XmCreateCascadeButton(menu_bar, "File", arglist,  n);
/*  XtManageChild(file_menu); */
  XtManageChild(new_entry);

  /* add the Open File Button */
  n = 0;
  XtSetArg(arglist[n], XmNlabelString,
	   XmStringCreate("Open File", def_charset)); ++n;
  new_button = XmCreatePushButton(file_menu, "New Button",
				  arglist, n);
  /* give it a callback */
  XtAddCallback(new_button, XmNactivateCallback, get_file_name, 0);
  
  /* add the quit button */
  n = 0;
  XtSetArg(arglist[n], XmNlabelString,
	   XmStringCreate("Quit", def_charset)); ++n;
  quit_button = XmCreatePushButton(file_menu, "Quit Button",
				   arglist, n);
  /* give it a callback */
  XtAddCallback(quit_button, XmNactivateCallback, Quit, 0);
  
  /* manage the children */
  XtManageChild(new_button);
  XtManageChild(quit_button);
  
  /* add the format options */
  /* now the options */

/*  n = 0;
  XtSetArg(arglist[n], XmNsubMenuId, format_menu); ++n;
  XtSetArg(arglist[n], XmNlabelString,
	   XmStringCreate("Format: ", def_charset)); ++n;
  format_option = XmCreateOptionMenu(file_menu, "Format Options",
				     arglist, n);
  XtManageChild(format_option); */

  n = 0;
  format_menu = XmCreatePulldownMenu(menu_bar, "Format Menu",
				      arglist, n);

  n = 0;
  XtSetArg(arglist[n], XmNsubMenuId, format_menu); ++n;
  XtManageChild(XmCreateCascadeButton(menu_bar, "Format", arglist,  n));
 

  n = 0;
  XtSetArg(arglist[n], XmNlabelString,
	   XmStringCreate("Binary", def_charset)); ++n;
  binary_button = XmCreatePushButton(format_menu, "Binary Button",
				   arglist, n);

  XtAddCallback(binary_button, XmNactivateCallback, binary_set, 0);

  n = 0;
  XtSetArg(arglist[n], XmNlabelString,
	   XmStringCreate("Clear Text", def_charset)); ++n;
  clear_text_button = XmCreatePushButton(format_menu, "Clear Text Button",
					 arglist, n);

  XtAddCallback(clear_text_button, XmNactivateCallback, clear_set, 0);


  XtManageChild(binary_button);
  XtManageChild(clear_text_button);
  
  /* create the Picture pulldown menu */
  n = 0;
  picture_menu = XmCreatePulldownMenu(menu_bar, "Picture", arglist, n);
  
  /* make menu entries */
  n = 0;
  XtSetArg(arglist[n], XmNsubMenuId, picture_menu); ++n;
  XtManageChild(XmCreateCascadeButton(menu_bar, "Picture", arglist,  n));

  /* make menu entries */
  /* next picture button */
  n = 0;
  XtSetArg(arglist[n], XmNlabelString,
	   XmStringCreate("Next Pic", def_charset)); ++n;
  next_button = XmCreatePushButton(picture_menu, "Next Button",
				   arglist, n);
  /* add a callback */
  XtAddCallback(next_button, XmNactivateCallback, next_picture, 0);

  /* redraw button */
  n = 0;
  XtSetArg(arglist[n], XmNlabelString,
	   XmStringCreate("Redraw", def_charset)); ++n;
  redraw_button = XmCreatePushButton(picture_menu, "Redraw Button",
				    arglist, n);
  /* add a callback */
  XtAddCallback(redraw_button, XmNactivateCallback, redraw_picture, 0);

  /* previous picture button */
  n = 0;
  XtSetArg(arglist[n], XmNlabelString,
	   XmStringCreate("Prev Pic", def_charset)); ++n;
  prev_button = XmCreatePushButton(picture_menu, "Prev Button",
				   arglist, n);
  /* add a callback */
  XtAddCallback(prev_button, XmNactivateCallback, prev_picture, 0);
  
  /* manage the children */
  XtManageChild(next_button);
  XtManageChild(redraw_button);
  XtManageChild(prev_button);

/*  XtManageChild(picture_menu); */

  /* manage the menu bar */
  XtManageChild(menu_bar);
  return(1);
}
/* routine to handle error messages */
void info_error(instr)
char *instr;
{
  /* create and manage the caution box widget */
  n = 0;
  XtSetArg(arglist[n], XmNmessageString,
	   XmStringCreate(instr, def_charset)); ++n;
  XtSetArg(arglist[n], XmNokLabelString,
	   XmStringCreate("Acknowledged", def_charset)); ++n;
  XtSetArg(arglist[n], XmNcancelLabelString,
	   XmStringCreate("Quit", def_charset)); ++n;
  caution_box = XmCreateWarningDialog(menu_bar, "Caution Box",
				      arglist, n);
  /* add a callback */
  XtAddCallback(caution_box, XmNcancelCallback, Quit, 0);
  XtManageChild(caution_box);
}


