/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997	Tim Janik	<timj@psynet.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* widdata.h: various utility functions
 * RCS_ID("$Id: widdata.h,v 1.10 1997/08/19 01:35:26 timj Exp $")
*/


#ifndef		__widdata_h__
#define		__widdata_h__

#ifdef		__cplusplus
  extern	"C"	{
#endif

#include	"config.h"
#include	"gbuild.h"
#include	"wdtree.h"



/* --- typedefs --- */
typedef	struct	gubi_data_S	gubi_data_S;
typedef	enum
{
	WID_CAT_NORMAL		= 0,
	WID_CAT_GENERIC		= 1 <<  0
				/* this indicates a generic symbol name
				*/,
	WID_CAT_AUXILLARY	= 1 <<  1
				/* is widget in auxillary pool ?
				*/
} wid_category_options_E;


/* --- defines --- */
#define	UPDATE_CHILD_COUNT(widget_data)				\
	GUBI_DATA(widget_data)->child_count=(			\
		widget_data_base_child_count(widget_data) +	\
		g_list_length(GUBI_DATA(widget_data)->children)	)

#define	HAS_MAX_CHILD_COUNT(widget_data)			\
	(! (GUBI_DATA(widget_data)->child_count < 		\
	    GUBI_DATA(widget_data)->max_child_count) )



/* --- structures --- */

/* FIXME
*/
#ifndef	__gsi_h__
typedef struct  gsi_struct_info_S       gsi_struct_info_S;
#endif	/*__gsi_h__*/

/* structure piggy back on gb_wdat_base_S.clone
*/
struct	gubi_data_S {
	gb_struct_type_E	type;
	wid_category_options_E	category;
	gb_wdat_base_S		*widget_data
				/* back link for
				 * gtk_object_get_user_data()
				*/;
	gchar			*symbol_name
				/* MALLOC
				*/;
	const gsi_struct_info_S	*struct_info;
	tree_S			*tree;
	GList			*children;
	guint			max_child_count
				/* number of children that can be added
				 * to this widget.
				 * (0, 1 or MAX_CHILDREN)
				*/;
	guint			child_count
				/* current number of childs
				*/;
	GtkWidget		*editor;
	GtkWidget		*browser;
	GList			*item_refs;
	GList			*link_refs;
};



/* --- global variables --- */
/* doubly linked list of auxillary widget data structures
*/
extern  GList           *Gubi_auxillary_list;



/* --- prototypes --- */


/* the widget_data_initialize() function greets the docs ;)
*/
void		widget_data_initialize	(void);


/* the tree_widget_data_new() function allocates and initializes
 * the space for a new gb_wdat_*_S. the initialization is done
 * according to the widget type specified by widget_enum.
*/
gb_wdat_base_S	*widget_data_new	(gb_struct_type_E	struct_type
					 /* if this is a numeric value that
					  * is not declared for
					  * gb_widget_type_E,
					  * g_error() will be invoked.
					 */,
					 const gchar		*widget_name
					 /* if this is a NULL pointer
					  * or if strlen(widget_name)==0,
					  * a name will be generated.
					 */,
					 gboolean		auxillary);


/* the widget_data_delete_R() function free()s widget_data and
 * it's sub structures. this also descends a possible child
 * tree of widget_data.
*/
void    widget_data_delete_R		(gb_wdat_base_S	*widget_data);


/* the widget_data_last_child() will return a pointer to the
 * last child in widget_data's widget tree.
 * the return value might be widget_data itself.
*/
gb_wdat_base_S*
	widget_data_last_child		(gb_wdat_base_S	*widget_data);


/* the widget_data_base_child_count() function returns the child count of
 * widget_data, that is caused by it's field values. on most widget types this
 * is simply 0, but on e.g. buttons a non NULL string pointer for the button
 * label causes at least a child count of 1.
 * the existence of *widget_data is asserted!
*/
guint	widget_data_base_child_count	(gb_wdat_base_S	*widget_data);


/* the widget_data_parent_level() functions returns the
 * parentation level of a widget data structure within
 * it's tree.
*/
guint	widget_data_parent_level	(gb_wdat_base_S	*widget_data);


/* the widget_data_new_item() function will create a GtkListItem
 * for widget_data.
 * the GtkListItem will be inserted into the children list of
 * List at the specified position.
 * indent_level indicates prefixing spaces for the item's label.
*/
GtkWidget*
	widget_data_new_item		(gb_wdat_base_S	*widget_data,
					 guint		indent_level,
					 GtkList	*List,
					 gint		position);


/* the widget_data_update_items() function updates the symbol
 * name of widget_data in all items referring to it, by preserving
 * the indentation level of each item.
*/
void
widget_data_update_items		(gb_wdat_base_S	*widget_data);


/* the widget_data_destroy_item() function will destroy the
 * specified item of a widget.
*/
void	widget_data_destroy_item	(gb_wdat_base_S	*widget_data,
					 GtkWidget	*item);


/* the widget_data_get_symbol_name() function returns a pointer to an
 * allocated char buffer, containing the symbol name of a gb_wdat_*_S.
 * the buffer must not be free()d and it's value might change because of
 * calls to other widget related functions!
 * the existence of *widget_data is asserted!
*/
const	gchar*
	widget_data_get_symbol_name	(gb_wdat_base_S		*widget_data);


/* the widget_data_set_symbol_name() function sets the symbol_name of
 * widget_data. if this name already exists, a new one will be generated.
 * the new symbol_name is also registered in the global symbol name
 * registery.
 * therefore the widget data must not be in the clipboard.
 * the existence of *widget_data is asserted!
*/
void	widget_data_set_symbol_name	(gb_wdat_base_S		*widget_data,
					 const gchar		*widget_name);


/* the widget_data_lookup() function looks up the specified symbol_name
 * in the global symbol name registery.
 * the existence of *symbol_name is asserted!
 * returns:
 * this returns a pointer to a gb_wdat_base_S or NULL if the look up failed.
*/
gb_wdat_base_S*
	widget_data_lookup		(const gchar		 *symbol_name);


/* the widget_data_register_symbol_name() function registers widget_data
 * in the global symbol name registery.
 * the existence of *widget_data is asserted!
*/
void	widget_data_register_symbol_name (gb_wdat_base_S	*widget_data);


/* the widget_data_unregister_symbol_name() function unregisters widget_data
 * in the global symbol name registery.
 * the existence of *widget_data is asserted!
*/
void	widget_data_unregister_symbol_name (gb_wdat_base_S	*widget_data);


/* the widget_data_add_handler() function apends the specified handler
 * to the handler list of widget_data.
 * the existence of *widget_data is asserted!
 * returns:
 * index of the newly appended handler in handler stack.
*/
guint	widget_data_add_handler		(gb_wdat_base_S		*widget_data,
					 const gchar		*signal_name,
					 const gchar		*func_name,
					 const gchar		*data_name,
					 const guint		connect_options);


/* the widget_data_delete_handler_stack() function deletes the
 * signal_handler_stack of widget_data.
 * the existence of *widget_data is asserted!
*/
void	widget_data_delete_handler_stack(gb_wdat_base_S		*widget_data);


/* the widget_data_new_linkage() functions initializes the linkage field
 * of a gb_wdat_base_S appropriate to the parent widget type of widget_data.
 * the existence of *widget_data is asserted!
*/
void	widget_data_new_linkage		(gb_wdat_base_S		*widget_data);


/* the widget_data_check_linkage() function checks all fields of
 * widget_data->linkage for validity.
 * the existence of *widget_data is asserted!
 * returns:
 * the return value indicates wether all fields of the linkage have
 * default values.
*/
gboolean
	widget_data_check_linkage	(gb_wdat_base_S		*widget_data);


/* the widget_data_children_check_linkage() function corrects the
 * linkage information of all child widgets.
 * this function returns wether some children might have changed or not.
*/
gboolean
	widget_data_children_check_linkage	(gb_wdat_base_S	*widget_data);


/* the function is passed to gsi_set_reference_func(). it is used to manage
 * inter gb_wdat_data_S references.
 * this function will either add or remove a link to widget_data to/from the
 * reference list of reference_data. the intended behaviour is specified by add_link.
*/
void	widget_data_reference_func	(gb_any_S		*widget_data,
					 gb_any_S		*reference_data,
					 gboolean		add_link);






#ifdef		__cplusplus
  }
#endif
#endif		/*__widdata_h__*/
