/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997	Tim Janik	<timj@psynet.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include	"rcs.h"
RCS_ID("$Id: treelist.c,v 1.12 1997/08/19 02:05:08 timj Exp $")


#define		__treelist_c__

#include	"treelist.h"
#include	"browser.h"
#include	"widgets.h"
#include	"builder.h"
#include	"widdata.h"
#include	"ufunc.h"
#include	"gbcio.h"
#include	"defines.h"
#include	"config.h"



/* --- variables --- */
static	gboolean	ignore_hints=FALSE;



/* --- functions --- */
void
treelist_refresh	(gboolean	select_last)
{
	register GList		*list;
	register tree_S		*old_tree;
	
	if (GTK_LIST(TreeList_List->widget)->selection) {
		register GtkWidget	*item;
		register gb_wdat_base_S	*window_data;
		
		item=GTK_LIST(TreeList_List->widget)->selection->data;
		
		g_assert((window_data=gtk_object_get_user_data(GTK_OBJECT(item))));
		g_assert(GB_IS_WIDDAT_WINDOW(window_data));
		g_assert((old_tree=GUBI_DATA(window_data)->tree));
	} else
		old_tree=NULL;
	
	gtk_list_clear_items(GTK_LIST(TreeList_List->widget), 0, -1);
	
	
	list=UD_tree_list;
	while (list) {
		register tree_S		*tree;
		register gb_wdat_base_S	*window_data;
		register GtkWidget	*item;
		
		g_assert((tree=list->data));
		g_assert(tree->widget_data_list);
		window_data=tree->widget_data_list->data;
		g_assert(GB_IS_WIDDAT_WINDOW(window_data));
		
		item=widget_data_new_item(window_data,
					  0,
					  GTK_LIST(TreeList_List->widget),
					  -1);
		gtk_object_set_data(GTK_OBJECT(item), "button_1_clicked_2", (gpointer)GB_LA_BROWSER);
		gtk_object_set_data(GTK_OBJECT(item), "button_3_clicked_1", (gpointer)GB_LA_TOGGLE_WINDOW);
		gtk_object_set_data(GTK_OBJECT(item), "button_3_clicked_2", (gpointer)GB_LA_TOGGLE_WINDOW);
		gtk_object_set_data(GTK_OBJECT(item), "button_3_clicked_3", (gpointer)GB_LA_TOGGLE_WINDOW);
		gtk_signal_connect(GTK_OBJECT(item),
				   "button_press_event",
				   GTK_SIGNAL_FUNC(sigh_widget_data_item_clicked),
				   NULL);
		gtk_signal_connect(GTK_OBJECT(item),
				   "button_release_event",
				   GTK_SIGNAL_FUNC(sigh_widget_data_item_clicked),
				   NULL);
		if (tree==old_tree)
			gtk_list_select_child(GTK_LIST(TreeList_List->widget), item);
		list=list->next;
        }
        
        if (select_last)
		gtk_list_select_item(GTK_LIST(TreeList_List->widget),
				     g_list_length(GTK_LIST(TreeList_List->widget)->children)-1);
	
	
	if (!GTK_LIST(TreeList_List->widget)->selection)
		gtk_list_select_item(GTK_LIST(TreeList_List->widget), 0);
}


void
sigh_treelist_selection_changed	(GtkList	*gtklist,
				 gpointer	func_data)
{
	register tree_S			*tree;
	register gb_wdat_window_S	*window_data;
	
	if (gtklist->selection) {
		register GtkObject	*item;
		g_assert((item=gtklist->selection->data));
		g_assert((window_data=gtk_object_get_user_data(item)));
		g_assert(GB_IS_WIDDAT_WINDOW(window_data));
		g_assert((tree=GUBI_DATA(window_data)->tree));
	} else {
		tree=NULL;
		window_data=NULL;
	}
	
	tree_set_current(tree);
	
	treelist_hints_update(tree);
	
	if (window_data && window_data->widget)
		_gtk_widget_raise(window_data->widget);
}


void
treelist_hints_update	(tree_S	*tree)
{
	ignore_hints=TRUE;
	if (tree==tree_get_current()) {
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(TreeList_Toggle_Visible->widget),
					    tree ? tree->visible     : FALSE);
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(TreeList_Toggle_Resize->widget),
					    tree ? tree->auto_resize : FALSE);
	}
	ignore_hints=FALSE;
}


void
sigh_treelist_Rebuild_clicked	(GtkWidget	*widget,
				 gpointer	func_data)
{
	register GList			*list;
	register gb_wdat_window_S	*window_data;
	
	list=UD_tree_list;
	while (list) {
		tree_rebuild(list->data);
		tree_show(list->data);
		list=list->next;
	}
	
	window_data=window_data_get_current();
	if (window_data && window_data->widget)
		_gtk_widget_raise(window_data->widget);
}


void
sigh_treelist_Hints_changed	(GtkWidget	*widget,
				 gpointer	func_data)
{
	if (ignore_hints)
		return;
		
	if (GTK_LIST(TreeList_List->widget)->selection) {
		register tree_S		*tree;
		register GtkWidget	*item;
		register gb_wdat_base_S	*window_data;
		register gboolean	old_resize;
		
		item=GTK_LIST(TreeList_List->widget)->selection->data;
		g_assert((window_data=gtk_object_get_user_data(GTK_OBJECT(item))));
		g_assert(GB_IS_WIDDAT_WINDOW(window_data));
		g_assert((tree=GUBI_DATA(window_data)->tree));
		
		tree->visible=GTK_TOGGLE_BUTTON(TreeList_Toggle_Visible->widget)->active;
		old_resize=tree->auto_resize;
		tree->auto_resize=GTK_TOGGLE_BUTTON(TreeList_Toggle_Resize->widget)->active;
		
		if (old_resize!=tree->auto_resize)
			tree_rebuild(tree);
		tree_show(tree);
	}
}


void
sigh_treelist_New_clicked	(GtkWidget	*widget,
				 guint		widget_type)
{
	register gb_wdat_window_S	*window_data;
	register tree_S			*tree;
	
	
	g_assert(widget_type == GB_WIDGET_WINDOW ||
		 widget_type == GB_WIDGET_FILE_SELECTION);
	
	
	/* we need a new tree
	*/
	tree=tree_new(TRUE, TRUE);
	
	
	/* create a new window widget data structure
	 * (add window to widget tree)
	*/
	window_data=GB_wCAST(window, widget_data_new(widget_type, NULL, FALSE));
	tree_insert_widget_data_R(tree, NULL, GB_wCAST(base, window_data), 0);
	tree_set_current_widget_data(tree, GB_wCAST(base, window_data));
	
	
	/* *first* show tree, otherwise
	 * we can't raise the window!
	*/
	tree_show(tree);
	treelist_refresh(TRUE);
}


void
sigh_treelist_List_clicked	(GtkWidget	*widget,
				 gpointer	func_data)
{
	register gb_wdat_base_S	*widget_data;
	
	widget_data=GB_wCAST(base, window_data_get_current());
	
	if (widget_data) {
		if (GUBI_DATA(widget_data)->browser)
			_gtk_widget_raise(GUBI_DATA(widget_data)->browser);
		else
			browser_create_window(widget_data);
	}
}


void
sigh_treelist_Delete_clicked	(GtkWidget	*widget,
				 gpointer	func_data)
{
	static	 GtkWidget	*gb_delete_dialog=NULL;
	register gb_wdat_base_S	*DelWin;
	
	DelWin=GB_wCAST(base, window_data_get_current());
	
	if (!gb_delete_dialog && DelWin)
		gb_delete_dialog= dialog_create_window(
				GTK_OBJECT(widget),
				&gb_delete_dialog,
				"Delete",
				GTK_SIGNAL_FUNC(sigh_delete_window_real),
				tree_get_current(),
				"Delete  <%s> %s ?",
				widget_data_get_symbol_name(DelWin),
				g_list_length(GUBI_DATA(DelWin)->children)>0 ?
				  " recursively" : "" );
}


void
sigh_delete_window_real	(GtkWidget	*widget,
			 tree_S		*tree)
{
	register gb_wdat_window_S	*window_data;
	
	g_assert(tree);
	g_assert(tree->widget_data_list);
	window_data=tree->widget_data_list->data;
	g_assert(GB_IS_WIDDAT_WINDOW(window_data));
	
	if (tree==tree_get_current())
		tree_set_current(NULL);
	
	if (g_list_length(GUBI_DATA(window_data)->children)>0) {
		register gb_wdat_base_S	*widget_data;
		
		widget_data=GUBI_DATA(window_data)->children->data;
		
		
		/* unlink and delete children
		*/
		tree_unlink_widget_data_R(tree, widget_data);
		widget_data_delete_R(widget_data);
	}
	
	
	/* delete tree entry with window
	*/
	tree_delete(tree);
}
