/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997	Tim Janik	<timj@psynet.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* defines.h: definitions used througout the program
 * RCS_ID("$Id: defines.h,v 1.9 1997/08/18 03:31:36 timj Exp $")
*/



#ifndef		__defines_h__
#define		__defines_h__

#ifdef		__cplusplus
  extern	"C"	{
#endif

#include	<stdio.h>



/* --- my name ;) --- */
#ifdef	PRGNAME
  #undef	PRGNAME
#endif	/*PRGNAME*/
#define	PRGNAME_SHORT	"GUBI"
#define	PRGNAME		PRGNAME_SHORT
#define	PRGNAME_LONG	"GUBI - GTK+ USER INTERFACE BUILDER"



/* --- gbc stuff --- */
#define	GBC_IDENT		PRGNAME_Short"(gbc)"
#define	GBC_STREAM_WARN		(stderr)
#define	GBC_STREAM_ERROR	(stderr)



/* --- macros --- */


/* macro returning internal byte offset of the member of a structure
*/
#undef	offsetof
#define	offsetof(struct_type, struct_member)	((guint)&((struct_type*)0)->struct_member)


/* macro for access to gubi_data_S fields
*/
#define	PIGGY_BACK_user_data	clone
#define	GUBI_DATA_FIELD		user_data
#define	GUBI_DATA(WidDat)	(((gubi_data_S*)((WidDat)->GUBI_DATA_FIELD)))


/* HACK macro, DON'T USE! (FIXME: remove)
*/
#define		BREAKPOINT()	__asm__("int $03")



/* --- parser tokens for *.gbc file --- */
/* token base for basic token types and TOKEN_WIDGET_*
*/
#define		TOKEN			(300)


/* tokens (with values in yytoken_U)
*/
#define		TOKEN_ANY		(0)
#define		TOKEN_EOF		(-1)
#define		TOKEN_NULL		(TOKEN -  1)
#define		TOKEN_LONG		(TOKEN -  2)
#define		TOKEN_DOUBLE		(TOKEN -  3)
#define		TOKEN_STRING		(TOKEN -  4)
#define		TOKEN_TREE		(TOKEN -  5)
#define		TOKEN_STRUCT		(TOKEN -  6)
#define		TOKEN_FIELD		(TOKEN -  7)
#define		TOKEN_WIDGET		(TOKEN -  8)
#define		TOKEN_ERROR		(TOKEN -  9)
#define		TOKEN_HANDLER		(TOKEN - 10)






#ifdef		__cplusplus
  }
#endif
#endif		/*__defines_h__*/
