/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997  Tim Janik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* wdtree.h: tree operations for widget data
 * RCS_ID("$Id: wdtree.h,v 1.6 1997/05/09 16:29:43 tim Exp $")
*/


#ifndef		__wdtree_h__
#define		__wdtree_h__

#ifdef		__cplusplus
  extern	"C"	{
#endif

#include	"gbconf.h"



/* --- typedefs --- */
typedef	struct	tree_S		tree_S;



/* --- structures ---- */


/* data nodes for tree list
*/
struct	tree_S {
	gb_struct_type_E	type;
	gboolean		visible;
	gboolean		auto_resize;
	gint			width;
	gint			height;
	GList			*widget_data_list;
	gb_wdat_base_S		*current;
};



/* --- global variables --- */


/* doubly linked list of widget data trees
*/
extern	GList		*UD_tree_list;



/* --- prototypes --- */


/* the tree_widget_data_insert_R() function inserts WidDat into
 * tree. possible children of WidDat will be inserted
 * as well. the WidDat is also added to the parent's ParDat child
 * list.
*/
void	tree_widget_data_insert_R	(tree_S		*tree,
					 gb_wdat_base_S	*ParDat,
					 gb_wdat_base_S	*WidDat,
					 guint		position);


/* the tree_widget_data_unlink_R() function unlinks WidDat
 * and possible children from tree.
 * if associated GtkWidgets are not destroyed, they will be.
*/
void	tree_widget_data_unlink_R	(tree_S		*tree,
					 gb_wdat_base_S	*WidDat);


/* the tree_new() function allocates and initializes the
 * space for a new tree_S.
 * if the tree is a user defined window, it is appended to
 * the UD_tree_list.
*/
tree_S	*tree_new			(gboolean	user_window,
					 gboolean	visible);


/* the tree_delete() function deletes tree and a possible
 * gb_wdat_window_S.
*/
void	tree_delete			(tree_S		*tree);


/* the tree_show() function rebuilds the whole
 * tree but doesn't show it.
*/
void	tree_rebuild			(tree_S		*tree);


/* the tree_show() updates the visibility of the
 * tree. if neccessary, this invokes tree_rebuild().
*/
void	tree_show			(tree_S		*tree);


/* the tree_set_current_widget_data() function sets the current
 * widget within a tree.
*/
void	tree_set_current_widget_data	(tree_S		*tree,
					 gb_wdat_base_S	*WidDat);


/* the tree_set_current() function sets the current tree.
*/
void	tree_set_current		(tree_S		*tree);


/* the tree_get_current() function returns a pointer to the current tree.
*/
tree_S*	tree_get_current		(void);


/* the window_data_get_current() returns a pointer to the first widget
 * within the current tree, wich is a widget with its own window.
*/
gb_wdat_window_S*
	window_data_get_current		(void);


/*
*/
void	tree_set_hints			(gboolean	flash_current);







#ifdef		__cplusplus
  }
#endif
#endif		/*__wdtree_h__*/
