/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997  Tim Janik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* ufunc.c: empty user function bodies
 * file created 1997/05/06 03:16:24 by gubi (dynamic)
*/
#include	"RCS.h"
RCS_ID("$Id: ufunc.c,v 1.6 1997/05/20 21:17:50 tim Exp $")
RCS_KEY(Template, "$Template: ufuncc.tpl 1997 gubi $")

#define		__ufunc_c__

#include	"ufunc.h"
#include	"widgets.h"
#include	"widdata.h"
#include	"editor.h"
#include	"gbcio.h"
#include	"misc.h"
#include	"defines.h"
#include	<time.h>


/* --- variables --- */
static	gchar	*gbc_file_name=NULL;



/* --- prototypes --- */
static	void	SigH_gbc_Read_clicked	(GtkWidget	*fs_window);
static	void	SigH_gbc_Save_clicked	(GtkWidget	*widget,
					 GtkWidget	*fs_window);
static	void	SigH_gbc_Save_real	(GtkWidget	*widget,
					 GtkWidget	*fs_window);



/* --- user functions --- */
void
ufunc_main_init		(int	argc,
			 char	*argv[])
{
	/* gdk_set_debug_level(0);
	 * gdk_set_show_events(0);
	*/
}


void
ufunc_widgets_init	(void)
{
}


void
ufunc_main_end		(void)
{
}



/* --- user callback functions --- */
/* void	GtkCallback(GtkWidget *widget, gpointer data); */
gint
SigH_WidDat_item_clicked	(GtkWidget	*widget,
				 GdkEventButton	*event)
{
	register gboolean	handled;
	
	g_assert(GTK_IS_LIST_ITEM(widget));
	
	handled=FALSE;
	
	if (event->button==3) {
		register gb_wdat_base_S	*WidDat;
		static	 gb_wdat_base_S	*WidDat_on_press=NULL;
		
		WidDat=gtk_object_get_user_data(GTK_OBJECT(widget));
		
		g_assert(GB_IS_WIDDAT(WidDat));
		
		if (event->type!=GDK_BUTTON_RELEASE) {
			WidDat_on_press=WidDat;
		} else {
			if (WidDat_on_press==WidDat) {
				if (!GUBI_DATA(WidDat)->editor)
					Editor_create(WidDat);
				else
					_gtk_widget_raise(GUBI_DATA(WidDat)->editor);
			}
		}
	} else if (event->type==GDK_2BUTTON_PRESS && event->button==1) {
		register gb_wdat_base_S	*WidDat;
		
		WidDat=gtk_object_get_user_data(GTK_OBJECT(widget));
		
		g_assert(GB_IS_WIDDAT(WidDat));
		
		if (!GUBI_DATA(WidDat)->browser) {
			if (GB_IS_WIDDAT_WINDOW(WidDat) ||
			    g_list_length(GUBI_DATA(WidDat)->children)>0)
				Browser_create(WidDat);
		} else
			_gtk_widget_raise(GUBI_DATA(WidDat)->browser);
	}
	
	return handled;
}


void
SigH_Main_Toggle_Test	(GtkWidget	*widget)
{
	tree_set_hints(GTK_TOGGLE_BUTTON(widget)->active);
}


void
SigH_Main_GBCio_clicked	(GtkWidget	*widget,
			 gboolean	save)
{
	if (!FileSel_Window->widget) {
		gtk_widget_set_sensitive(Main_Button_GbcRead->widget, FALSE);
		gtk_widget_set_sensitive(Main_Button_GbcSave->widget, FALSE);
	} else
		return;
	
	FileSel_Window->filename=gbc_file_name;
	
	gb_window_build(GB_wCAST(window, FileSel_Window));
	
	gb_window_connect(GB_wCAST(window, FileSel_Window));
	
	if (save) {
		gtk_widget_show(FileSel_VBox_WriteOptions->widget);
		gtk_label_set(GTK_LABEL(GTK_BUTTON(GTK_FILE_SELECTION(FileSel_Window->widget)->ok_button)->child), "Save");
	} else {
		gtk_widget_show(FileSel_VBox_ReadOptions->widget);
		gtk_label_set(GTK_LABEL(GTK_BUTTON(GTK_FILE_SELECTION(FileSel_Window->widget)->ok_button)->child), "Read");
	}
	
	gtk_widget_show(FileSel_Window->widget);
	
	gtk_widget_set_sensitive(GTK_FILE_SELECTION(FileSel_Window->widget)->help_button, FALSE);
	
	gtk_signal_connect_object(GTK_OBJECT(FileSel_Window->widget),
				  "destroy",
				  GTK_SIGNAL_FUNC(_gtk_widget_set_sensitivity),
				  GTK_OBJECT(Main_Button_GbcRead->widget));
	gtk_signal_connect_object(GTK_OBJECT(FileSel_Window->widget),
				  "destroy",
				  GTK_SIGNAL_FUNC(_gtk_widget_set_sensitivity),
				  GTK_OBJECT(Main_Button_GbcSave->widget));
	
	gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(FileSel_Window->widget)->cancel_button),
				  "clicked",
				  GTK_SIGNAL_FUNC(gtk_widget_destroy),
				  GTK_OBJECT(FileSel_Window->widget));

	if (save)
		gtk_signal_connect(
				GTK_OBJECT(GTK_FILE_SELECTION(FileSel_Window->widget)->ok_button),
				"clicked",
				GTK_SIGNAL_FUNC(SigH_gbc_Save_clicked),
				GTK_OBJECT(FileSel_Window->widget));
	else
		gtk_signal_connect_object(
				GTK_OBJECT(GTK_FILE_SELECTION(FileSel_Window->widget)->ok_button),
				"clicked",
				GTK_SIGNAL_FUNC(SigH_gbc_Read_clicked),
				GTK_OBJECT(FileSel_Window->widget));
}

void
SigH_gbc_Read_clicked	(GtkWidget	*fs_window)
{
	register gchar	*file_name;
	register FILE	*f_in;
	register guint	errors;
	
	file_name=gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs_window));
	
	if (!S_ISREG(get_stat_mode(file_name))) {
		
		gtk_file_selection_set_filename(GTK_FILE_SELECTION(fs_window), file_name);
		
		/*
		Message_create(GTK_OBJECT(fs_window),
			       "Not a regular file:\n%s",
			       file_name);
		*/
		
		return;
	}
	
	if (!(f_in=fopen(file_name, "r"))) {
		Message_create	(GTK_OBJECT(fs_window),
				 "Failed to open file:\n%s:\n%s",
				 g_strerror(errno),
				 file_name);
		return;
	}
	
	g_free(gbc_file_name);
	gbc_file_name=g_strdup(file_name);
	
	if (!GTK_TOGGLE_BUTTON(FileSel_Toggle_Merging->widget)->active)
		while (UD_tree_list)
			SigH_Delete_window_real(NULL, UD_tree_list->data);
	
	if ((errors=Read_trees(f_in, file_name, 10)))
		Message_create	(NULL,
				 "%s :\n %s %d error%s.",
				 file_name,
				 errors>=10 ? "Parsing aborted after" : "Encountered",
				 errors,
				 errors>1 ? "s" : "");
	
	TreeList_refresh(TRUE);
	
	if (fclose(f_in))
		Message_create	(GTK_OBJECT(fs_window),
				 "Failed to close file:\n%s:\n%s",
				 g_strerror(errno),
				 file_name);
	
	gtk_widget_destroy(fs_window);
}


void
SigH_gbc_Save_clicked	(GtkWidget	*widget,
			 GtkWidget	*fs_window)
{
	register gchar	*file_name;
	register int	stat_mode;
	
	file_name=gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs_window));
	
	stat_mode=get_stat_mode(file_name);
	if (stat_mode!=0 && !S_ISREG(stat_mode)) {
		
		gtk_file_selection_set_filename(GTK_FILE_SELECTION(fs_window), file_name);
		
		/*
		Message_create(GTK_OBJECT(fs_window),
			       "Not a regular file:\n%s",
			       file_name);
		*/
		
		return;
	}
	
	gtk_object_set_user_data(GTK_OBJECT(fs_window), file_name);
	
	if (stat_mode) {
		register GtkWidget	*dialog;
		
		gtk_widget_set_sensitive(widget, FALSE);
		
		dialog=Dialog_create(
				GTK_OBJECT(fs_window),
				NULL,
				"OK",
				GTK_SIGNAL_FUNC(SigH_gbc_Save_real),
				fs_window,
				"File exists:\n%s\nOverwrite ?",
				file_name);
		
		gtk_signal_connect_object(GTK_OBJECT(dialog),
					"destroy",
					GTK_SIGNAL_FUNC(_gtk_widget_set_sensitivity),
					GTK_OBJECT(widget));
		return;
	}
	
	SigH_gbc_Save_real(NULL, fs_window);
	
	return;
}


void
SigH_gbc_Save_real	(GtkWidget	*widget,
			 GtkWidget	*fs_window)
{
	register gchar		*file_name;
	register FILE		*f_out;
	register GList		*list;
	register struct	tm	*s_tm;
		 time_t		timet;
	
	file_name=gtk_object_get_user_data(GTK_OBJECT(fs_window));
	
	if (!(f_out=fopen(file_name, "w"))) {
		Message_create(GTK_OBJECT(fs_window),
			       "Failed to open file:\n%s:\n%s",
			       g_strerror(errno),
			       file_name);
		return;
	}
	
	g_free(gbc_file_name);
	gbc_file_name=g_strdup(file_name);
	
	
	/* start the output file with an
	 * appropriate comment
	*/
	timet=time(NULL);
	s_tm=localtime(&timet);
	fprintf(f_out, "/*\t%s: widget tree configuration file for ", file_name);
	fprintf(f_out, "%s\n", PRGNAME_Short);
	fprintf(f_out, " *\tcreated ");
	fprintf(f_out, "%04d/%02d/%02d ", s_tm->tm_year+1900, s_tm->tm_mon+1, s_tm->tm_mday);
	fprintf(f_out, "%02d:%02d:%02d ", s_tm->tm_hour, s_tm->tm_min, s_tm->tm_sec);
	fprintf(f_out, "by %s\n", PRGNAME_short);
	fprintf(f_out, "*/\n\n\n");


	/* give a warning about editing
	*/
	fprintf(f_out, "/* since parsing is very unflexible,\n");
	fprintf(f_out, " * you shouldn't edit this file, if you\n");
	fprintf(f_out, " * don't know what you are doing.\n");
	fprintf(f_out, "*/\n");
	
	list=UD_tree_list;
	
	while (list) {
		register tree_S			*tree;
		
		g_assert((tree=list->data));
		
		if (tree->widget_data_list) {
			register gb_wdat_window_S	*WinDat;
			
			WinDat=tree->widget_data_list->data;
			g_assert(GB_IS_WIDDAT_WINDOW(WinDat));
			
			Save_window(f_out,
				    file_name,
				    WinDat,
				    GTK_TOGGLE_BUTTON(FileSel_Toggle_Defaults->widget)->active);
		}
		
		list=list->next;
	}
	
	fclose(f_out);
	
	gtk_widget_destroy(fs_window);
}
