/* main.c: reference main()
 * file created 1997/05/21 01:49:59 by gubi (static)
*/
#include	"RCS.h"
RCS_ID("$Id$")
RCS_KEY(Template, "$Template: main.tpl 1997 gubi $")

#define		__main_c__

#include	"gbconf.h"
#include	"widgets.h"
#include	"ufunc.h"
#include	<signal.h>
#include	<unistd.h>



/* --- prototypes --- */
static	void	gb_system_signal_handler	(int	sig_num);



/* --- main() --- */
int
main	(int	argc,
	 char	*argv[])
{
	static	guint	i;
	

	/* gtk/gdk initialization
	 */
	gtk_init(&argc, &argv);
	
	
	/* catch system signals
	*/
	gb_system_signal_handler(0);
	

	/* user defined program initialization
	*/
	ufunc_main_init(argc, argv);
	
	
	/* build windows
	 */
	for (i=0; i<gb_number_of_windows; i++) {
		if (gb_window_list[i] && GB_wCAST(window, gb_window_list[i])->auto_build)
			gb_window_build(gb_window_list[i]);
	}
	
	
	/* connect signal handlers
	 */
	for (i=0; i<gb_number_of_windows; i++) {
		if (gb_window_list[i] && GB_wCAST(window, gb_window_list[i])->auto_build)
			gb_window_connect(gb_window_list[i]);
	}
	
	
	/* user defined widget initializations
	*/
	ufunc_widgets_init();
	
	
	/* show windows
	 */
	for (i=0; i<gb_number_of_windows; i++) {
		if (gb_window_list[i] && GB_wCAST(window, gb_window_list[i])->auto_build)
			gtk_widget_show(gb_window_list[i]->widget);
	}
	

	/* gtk's main loop
	 */
	gtk_main();
	
	
	/* user defined program shutdown
	*/
	ufunc_main_end();
	
	
	/* exit program
	*/
	gtk_exit(0);

	return 0;
}


void
gb_system_signal_handler	(int	sig_num)
{
	static	gboolean	in_call=FALSE;
	
	if (in_call) {
		fprintf(stderr, "\naborting on another signal: `%s'\n",
			g_strsignal(sig_num));
		fflush(stderr);
		gtk_exit(0);
	} else
		in_call=TRUE;
	
	signal(SIGINT,	gb_system_signal_handler);
	signal(SIGTRAP,	gb_system_signal_handler);
	signal(SIGABRT,	gb_system_signal_handler);
	signal(SIGBUS,	gb_system_signal_handler);
	signal(SIGSEGV,	gb_system_signal_handler);
	signal(SIGPIPE,	gb_system_signal_handler);
	/* signal(SIGTERM,	gb_system_signal_handler); */
	
	if (sig_num>0) {
		fprintf(stderr, "%s: (pid: %d) caught signal: `%s'\n",
			PRGNAME,
			getpid(),
			g_strsignal(sig_num));
		fflush(stderr);
		g_debug(PRGNAME);
	}
	in_call=FALSE;
}
