/* gbconf.h: various functions needed at runtime for widget trees
 * file created 1997/05/09 18:57:45 by gubi (static)
 * RCS_ID("$Id$")
 * RCS_KEY(Template, "$Template: gbconfh.tpl 1997 gubi $")
*/


#ifndef		__gbconf_h__
#define		__gbconf_h__

#ifdef		__cplusplus
  extern "C"	{
#endif

#include	<gtk.h>



/* --- defines --- */


/* we depend on this!
*/
#undef	NULL
#define	NULL	((void*)(0))


/* the GB_CAST macro is used to cast a pointer into any
 * gb_*_S pointer.
*/
#define	GB_CAST(type,struct_p)	((gb_##type##_S*)(struct_p))
#define	GB_wCAST(type,struct_p)	((gb_wdat_##type##_S*)(struct_p))


/* macros to check type validity
*/
#define	GB_TYPE_IS_STRUCT(type)						\
			( ((type)>GB_STRUCT_NONE) &&			\
			  ((type)<GB_STRUCT_LAST) )
#define	GB_TYPE_IS_WIDGET(type)						\
			( GB_TYPE_IS_CHILD_WIDGET((type)) ||		\
			  GB_TYPE_IS_WINDOW_WIDGET((type)) )
#define	GB_TYPE_IS_CHILD_WIDGET(type)					\
			( ((type)>=_GB_CHILD_WIDGET_FIRST) &&		\
			  ((type)<=_GB_CHILD_WIDGET_LAST) )
#define	GB_TYPE_IS_WINDOW_WIDGET(type)					\
			( ((type)>=_GB_WINDOW_WIDGET_FIRST) &&		\
			  ((type)<=_GB_WINDOW_WIDGET_LAST) )
#define	GB_TYPE_IS_CONTAINER_WIDGET(type)				\
			( ( ((type)>=_GB_CONTAINER_WIDGET_FIRST) &&	\
			    ((type)<=_GB_CONTAINER_WIDGET_LAST) ) ||	\
			  GB_TYPE_IS_WINDOW_WIDGET((type)) )
#define	GB_TYPE_IS_LINKAGE(type)					\
			( ((type)>=_GB_LINKAGE_FIRST) &&		\
			  ((type)<=_GB_LINKAGE_LAST) )


/* macros to check structure pointer for type
*/
#define	GB_IS_STRUCT(struct_p)						\
			( (struct_p) &&					\
			  GB_TYPE_IS_STRUCT((struct_p)->type) )
#define	GB_IS_WIDGET(struct_p)						\
			( (struct_p) &&					\
			  GB_TYPE_IS_WIDGET((struct_p)->type) )
#define	GB_IS_CHILD_WIDGET(struct_p)					\
			( (struct_p) &&					\
			  GB_TYPE_IS_CHILD_WIDGET((struct_p)->type) )
#define	GB_IS_WINDOW_WIDGET(struct_p)					\
			( (struct_p) &&					\
			  GB_TYPE_IS_WINDOW_WIDGET((struct_p)->type) )
#define	GB_IS_CONTAINER_WIDGET(struct_p)				\
			( (struct_p) &&					\
			  GB_TYPE_IS_CONTAINER_WIDGET((struct_p)->type) )
#define	GB_IS_LINKAGE(struct_p)						\
			( (struct_p) &&					\
			  GB_TYPE_IS_LINKAGE((struct_p)->type) )


/* the GB_NULLIFY_ON_DESTROY macro is used to add a
 * signal handler to a GtkWidget for nullification of the
 * pointer pointer_adress points to. the signal handler is
 * invoked, when the widget gets destroyed.
*/
#define	GB_NULLIFY_ON_DESTROY(widget,pointer_adress)			\
	gtk_signal_connect(GTK_OBJECT((widget)),				\
			   "destroy",					\
			   GTK_SIGNAL_FUNC(gb_sigh_pointer_nullify),	\
			   (pointer_adress))


/* the GB_GFREE_ON_DESTROY macro is used to add a
 * signal handler to a GtkWidget that frees the space pointer
 * points to. the signal handler is invoked, when the widget
 * gets destroyed.
*/
#define	GB_GFREE_ON_DESTROY(widget,pointer)				\
	gtk_signal_connect_object(GTK_OBJECT((widget)),			\
				  "destroy",				\
				  GTK_SIGNAL_FUNC(g_free),		\
				  (GtkObject*)(pointer))


/* macro for memory allocation and copy
*/
#define	memdup(source, size)	memcpy(g_malloc(size), source, size)



/* --- typedefs --- */


/* the gb_struct_type_E enum typedef specifies the various structure types.
*/
typedef enum
{
	GB_STRUCT_NONE,
	

	/* abstract structures for common widget data fields
	*/
	GB_WIDGET_BASE,
	GB_WIDGET_CONTAINER,


	/* structures for widget data information
	 * that can act as children
	*/
#define	_GB_CHILD_WIDGET_FIRST		GB_WIDGET_LABEL
	GB_WIDGET_LABEL,
	GB_WIDGET_ENTRY,
	GB_WIDGET_H_SEPARATOR,
	GB_WIDGET_V_SEPARATOR,
	GB_WIDGET_PROGRESS_BAR,
	GB_WIDGET_ARROW,
	GB_WIDGET_H_SCALE,
	GB_WIDGET_V_SCALE,
	GB_WIDGET_H_RULER,
	GB_WIDGET_V_RULER,
	GB_WIDGET_DRAWING_AREA,
#define	_GB_CONTAINER_WIDGET_FIRST	GB_WIDGET_H_BOX
	GB_WIDGET_H_BOX,
	GB_WIDGET_V_BOX,
	GB_WIDGET_TABLE,
	GB_WIDGET_FRAME,
	GB_WIDGET_BUTTON,
	GB_WIDGET_TOGGLE_BUTTON,
	GB_WIDGET_CHECK_BUTTON,
	GB_WIDGET_RADIO_BUTTON,
	GB_WIDGET_LIST,
	GB_WIDGET_SCROLLED_WINDOW,
#define	_GB_CONTAINER_WIDGET_LAST	GB_WIDGET_SCROLLED_WINDOW
#define	_GB_CHILD_WIDGET_LAST		_GB_CONTAINER_WIDGET_LAST


	/* structures for widget data information
	 * that can not act as children (windows)
	*/
#define	_GB_WINDOW_WIDGET_FIRST		GB_WIDGET_WINDOW
	GB_WIDGET_WINDOW,
	GB_WIDGET_FILE_SELECTION,
#define	_GB_WINDOW_WIDGET_LAST		GB_WIDGET_FILE_SELECTION


	/* structures for linkage information
	*/
#define	_GB_LINKAGE_FIRST		GB_LINKAGE_BOX
	GB_LINKAGE_BOX,
	GB_LINKAGE_TABLE,
#define	_GB_LINKAGE_LAST		GB_LINKAGE_TABLE

	GB_STRUCT_LAST
} gb_struct_type_E;


/* the gb_connect_options_E enum typedef specifies the
 * signal connect options.
*/
typedef enum
{
	GB_CONNECT		= 1 << 0,
	GB_CONNECT_OBJECT	= 1 << 1,
	GB_CONNECT_AFTER	= 1 << 2,
	GB_CONNECT_DATA_POINTER	= 1 << 3	/* FIXME: remove */
} gb_connect_options_E;


/* the gb_reference_E enum typedef specifies the way
 * a pointer is dereferenced.
*/
typedef enum
{
	GB_DEREF_NONE,
	GB_DEREF_POINTER,
	GB_DEREF_GB_SELF_WIDGET,
	GB_DEREF_GB_PARENT_WIDGET,
	GB_DEREF_GB_LAST_PARENT_WIDGET,
	GB_DEREF_GB_WIDGET,
	GB_DEREF_GB_CLONE_WIDGET
} gb_reference_E;


/* typedefs to introduce the various structures.
*/
typedef	struct	gb_any_S			gb_any_S;
typedef	struct	gb_linkage_box_S		gb_linkage_box_S;
typedef	struct	gb_linkage_table_S		gb_linkage_table_S;
typedef	struct	gb_wdat_base_S			gb_wdat_base_S;
typedef	struct	gb_wdat_container_S		gb_wdat_container_S;
typedef	struct	gb_wdat_label_S			gb_wdat_label_S;
typedef	struct	gb_wdat_entry_S			gb_wdat_entry_S;
typedef	struct	gb_wdat_base_S			gb_wdat_h_separator_S;
typedef	struct	gb_wdat_base_S			gb_wdat_v_separator_S;
typedef	struct	gb_wdat_button_S		gb_wdat_button_S;
typedef	struct	gb_wdat_toggle_button_S		gb_wdat_toggle_button_S;
typedef	struct	gb_wdat_toggle_button_S		gb_wdat_check_button_S;
typedef	struct	gb_wdat_radio_button_S		gb_wdat_radio_button_S;
typedef	struct	gb_wdat_frame_S			gb_wdat_frame_S;
typedef	struct	gb_wdat_box_S			gb_wdat_h_box_S;
typedef	struct	gb_wdat_box_S			gb_wdat_v_box_S;
typedef	struct	gb_wdat_list_S			gb_wdat_list_S;
typedef	struct	gb_wdat_scrolled_window_S	gb_wdat_scrolled_window_S;
typedef	struct	gb_wdat_progress_bar_S		gb_wdat_progress_bar_S;
typedef	struct	gb_wdat_arrow_S			gb_wdat_arrow_S;
typedef	struct	gb_wdat_scale_S			gb_wdat_h_scale_S;
typedef	struct	gb_wdat_scale_S			gb_wdat_v_scale_S;
typedef	struct	gb_wdat_ruler_S			gb_wdat_h_ruler_S;
typedef	struct	gb_wdat_ruler_S			gb_wdat_v_ruler_S;
typedef	struct	gb_wdat_drawing_area_S		gb_wdat_drawing_area_S;
typedef	struct	gb_wdat_table_S			gb_wdat_table_S;
typedef	struct	gb_wdat_window_S		gb_wdat_window_S;
typedef	struct	gb_wdat_file_selection_S	gb_wdat_file_selection_S;


/* typedefs to introduce handler structures.
*/
typedef	union	gb_handler_data_U	gb_handler_data_U;
typedef	struct	gb_handler_S		gb_handler_S;



/* --- auxillary structures --- */


/* the gb_handler_data_U contains the data associated with
 * a handler from gb_handler_S.
*/
union	gb_handler_data_U {
	gpointer		func_data;
	gpointer		*func_data_p;
	GtkObject		*slot_object
				/* here, NULL indicates
				 * the connecting object
				 * itself
				*/;
	GtkObject		**slot_object_p;
};


/* the gb_handler_S holds the user function pointers, as well as
 * their type definitions.
*/
struct	gb_handler_S {
	guint16			connect_options;
	gint			handler_id;
	GtkSignalFunc		handler_func;
	gchar			*signal_name;
	gb_handler_data_U	data;
};


/* the gb_any_S acts as base type for
 * all structures.
*/
struct	gb_any_S {
	gb_struct_type_E	type;
};


/* the gb_linkage_box_S holds information about the
 * linkage of a box's child.
*/
struct	gb_linkage_box_S {
	gb_struct_type_E	type;
	GtkPackType		pack_type;
	GtkAttachOptions	attach;
	gint			padding;
};


/* the gb_linkage_table_S holds information about the
 * attachment of a table's child.
*/
struct	gb_linkage_table_S {
	gb_struct_type_E	type;
	GtkAttachOptions	xoptions;
	GtkAttachOptions	yoptions;
	gint			xpadding;
	gint			ypadding;
	gint			left_attach;
	gint			right_attach;
	gint			top_attach;
	gint			bottom_attach;
};


/* --- widget structures --- */


/* the GB_BASE_DATA_S_FIELDS macro contains the field declarations
 * of the gb_wdat_base_S. this is used for coherence of the
 * basic fields for the various gb_*_wdat_S.
*/
#define	GB_BASE_DATA_S_FIELDS	\
	gb_struct_type_E	type					\
				/* widget type				\
				*/;					\
	gb_wdat_base_S		*parent					\
				/* pointer to parent			\
				*/;					\
	gboolean		gfree_on_destroy			\
				/* connect gb_sigh_structure_free()	\
				 * or gb_sigh_pointer_nullify()?	\
				*/;					\
	gb_wdat_base_S		*clone					\
				/* self reference used on cloning	\
				*/;					\
	gb_wdat_base_S		*next					\
				/* link to next gb_wdat_base_S		\
				*/;					\
	GtkWidget		*widget					\
				/* the widget returned from gtk_*_new()	\
				*/;					\
	gb_handler_S		*handler_stack				\
				/* pointer to NULL-terminated		\
				 * signal handler array.		\
				*/;					\
	gb_any_S		*linkage				\
				/* pointer to any gb_linkage_*_S type	\
				 * or NULL to indicate linkage by	\
				 * gtk_container_add().			\
				*/;					\
	gchar			*widget_name;				\
	guint32			flags					\
				/* used bits:				\
				 * GTK_SENSITIVE			\
				 * GTK_CAN_DEFAULT			\
				 * GTK_CAN_FOCUS			\
				 * GTK_HAS_DEFAULT			\
				 * GTK_HAS_FOCUS			\
				*/;					\
	gint			x, y					\
				/* initial position			\
				*/;					\
	guint			width, height				\
				/* initial size				\
				*/;					\
	gpointer		user_data				\
				/* initialy NULL			\
				*/


/* the GB_CONTAINER_DATA_S_FIELDS macro contains the field declarations
 * of the gb_wdat_container_S. this is used for coherence of the
 * basic fields for the various gb_*_wdat_S.
*/
#define	GB_CONTAINER_DATA_S_FIELDS	\
	GB_BASE_DATA_S_FIELDS;						\
	gint			border_width				\
				/* space separating container		\
				 * from children			\
				*/


/* the base widget data structure includes the basic fields,
 * that are common to all gb_*_wdat_S.
*/
struct	gb_wdat_base_S {
	GB_BASE_DATA_S_FIELDS;
};


/* the container widget data structure includes the basic fields,
 * that are common to all gb_*_wdat_S whose Gtk counterparts
 * serve as containers.
*/
struct	gb_wdat_container_S {
	GB_CONTAINER_DATA_S_FIELDS;
};

struct	gb_wdat_label_S {
	GB_BASE_DATA_S_FIELDS;
	gchar			*label;
};

struct	gb_wdat_entry_S {
	GB_BASE_DATA_S_FIELDS;
	gchar			*init_text;
};

struct	gb_wdat_button_S {
	GB_CONTAINER_DATA_S_FIELDS;
	gchar			*label
				/* NULL indicates no label
				*/;
};

struct	gb_wdat_toggle_button_S {
	GB_CONTAINER_DATA_S_FIELDS;
	gchar			*label
				/* NULL indicates no label
				*/;
	gboolean		init_state;
	gboolean		draw_indicator;
};


struct	gb_wdat_radio_button_S {
	GB_CONTAINER_DATA_S_FIELDS;
	gchar			*label
				/* NULL indicates no label
				*/;
	gboolean		init_state;
	gboolean		draw_indicator;
	gb_wdat_radio_button_S	*grouping;
};

struct	gb_wdat_frame_S {
	GB_CONTAINER_DATA_S_FIELDS;
	gchar			*label
				/* NULL indicates no label
				*/;
	GtkShadowType		shadow_type;
	gfloat			xalign;
	gfloat			yalign;
};

struct	gb_wdat_box_S {
	GB_CONTAINER_DATA_S_FIELDS;
	gboolean		homogeneous;
	gint			spacing;
};

struct	gb_wdat_table_S {
	GB_CONTAINER_DATA_S_FIELDS;
	gboolean		homogeneous;
	gint			rows;
	gint			columns;
	gint			row_spacing;
	gint			col_spacing;
};

struct	gb_wdat_list_S {
	GB_CONTAINER_DATA_S_FIELDS;
	GtkSelectionMode	select_mode;
};

struct	gb_wdat_scrolled_window_S {
	GB_CONTAINER_DATA_S_FIELDS;
	GtkPolicyType		hscrollbar_policy;
	GtkPolicyType		vscrollbar_policy;
};

struct	gb_wdat_progress_bar_S {
	GB_BASE_DATA_S_FIELDS;
	gfloat			init_percentage;
};

struct	gb_wdat_arrow_S {
	GB_BASE_DATA_S_FIELDS;
	GtkArrowType		arrow_type;
	GtkShadowType		shadow_type;
};

struct	gb_wdat_ruler_S {
	GB_BASE_DATA_S_FIELDS;
	GtkMetricType	metric;
	gfloat		lower;
	gfloat		upper;
	gfloat		position;
	gfloat		max_size;
};

struct	gb_wdat_scale_S {
	GB_BASE_DATA_S_FIELDS;
	gboolean		draw_value;
	GtkPositionType		value_pos;
	GtkUpdateType		update_type;
	gint			digits;
	GtkAdjustment		*adjustment;
};

struct	gb_wdat_drawing_area_S {
	GB_BASE_DATA_S_FIELDS;
	gint			req_width;
	gint			req_height;
};

#define	GB_ALLOW_SHRINK		( 1 << 0 )
#define	GB_ALLOW_GROW		( 1 << 1 )
#define	GB_AUTO_SHRINK		( 1 << 2 )

struct	gb_wdat_window_S {
	GB_CONTAINER_DATA_S_FIELDS;
	gchar			*title;
	GtkWindowType		win_type;
	GtkWindowPosition	win_position;
	guint			resize_policy;
	gboolean		auto_build
				/* automatic creation in main() ?
				*/;
};

struct	gb_wdat_file_selection_S {
	GB_CONTAINER_DATA_S_FIELDS;
	gchar			*title;
	GtkWindowType		win_type;
	GtkWindowPosition	win_position;
	guint			resize_policy;
	gboolean		auto_build;
	gchar			*filename;
};



/* --- global variables --- */


/* gb_number_of_windows reflects the number of window configuration,
 * and therefore the number of widget trees.
*/
extern	guint			gb_number_of_windows;


/* the gb_window_list[] array contains pointers to all window configurations.
 * it's maximum index is identified by gb_number_of_windows-1.
*/
extern	gb_wdat_window_S	*gb_window_list[];



/* --- prototypes --- */


/* the gb_struct_size() function returns sizeof(gb_*_S) for a
 * gb_*_S specified by enum_value.
 * some gb_struct_type_E are not valid to actualy form a real
 * structure, those values will be considered a fatal error.
 * returns:
 * sizeof() value for a specific gb_*_S.
*/
guint	gb_struct_size		(const	gb_struct_type_E	struct_type
				 /* numeric value indicating the
				  * gb_*_S type.
				 */);


/* the gb_window_build() function builds the whole window's widget tree.
 * this is done by first creating the window from *WinDat and later on
 * the creation of all the corresponding GtkWidget's according to the
 * gb_*_wdat_S linked to *WinDat by the next pointer.
*/
void	gb_window_build		(gb_wdat_window_S	*WinDat
				 /* *valid* pointer to an existing
				  * gb_wdat_window_S
				 */);


/* the gb_window_connect() function just calls the gb_widget_connect()
 * function for all gb_*_wdat_S of it's tree similar to gb_window_build().
*/
void	gb_window_connect	(gb_wdat_window_S	*WinDat);


/* the gb_widget_create() function creates a new GtkWidget and adds it to
 * it's parent GtkWidget, specified through the parent pointer of the
 * gb_*_wdat_S, by taking apropriate actions according to the linkage
 * specification.
 * this function also connects a signal handler to the "destroy" signal
 * of the GtkWidget.
 * this signal handler either resets the widget pointer of the gb_*_wdat_S
 * to NULL or frees the memory of the gb_*_wdat_S and it's auxilary
 * structures.
 * what action is performed by the signal handler depends on the value
 * of the free_clone field within the gb_*_wdat_S.
*/
void	gb_widget_create	(gb_wdat_base_S		*WidDat
				 /* *valid* pointer to an existing
				  * gb_wdat_base_S or derrived type
				 */);


/* the gb_widget_connect() function connects the handlers of WidDat,
 * specified through the auxilary handler_stack.
*/
void	gb_widget_connect	(gb_wdat_base_S		*WidDat);


/* the gb_widget_wdat_clone() function clones the subtree of the specified
 * gb_*_wdat_S.
 * the clone pointer of the gb_*_wdat_S in the source tree contain
 * pointer to their related clones afterwards.
 * the free_clone field of the cloned gb_*_wdat_S is set to TRUE.
*/
void	gb_widget_data_clone	(gb_wdat_base_S		*WidDat);


/* the gb_sigh_pointer_nullify() function is a signal handler that
 * nullifies the pointer located at pointer_adress.
*/
void	gb_sigh_pointer_nullify	(GtkWidget	*pointer
				 /* unused pointer
				 */,
				 gpointer	*pointer_adress
				 /* *valid* pointer to a
				  * pointer.
				 */);


/* the gb_sigh_structure_free() function is a signal handler, normaly
 * used to free a cloned gb_wdat_base_S and it's auxilary structures.
*/
void	gb_sigh_structure_free	(GtkWidget	*pointer,
				 gb_any_S	*Struct
				 /* *valid* pointer to a gb_any_S
				  * or derived type.
				 */);


/* the gb_sigh_widget_dump() function just dumps known data about
 * a GtkWidget to stdout.
*/
void	gb_sigh_widget_dump	(GtkWidget	*widget
				 /* *valid* pointer to a GtkWidget
				 */);






#ifdef		__cplusplus
  }
#endif

#endif		/*__gbconf_h__*/
