/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GLESHELL_H__
#define __GLESHELL_H__


#include	"gleselector.h"


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */


/* --- type macros --- */
#define	GLE_SHELL(object)	(GTK_CHECK_CAST ((object), gle_shell_get_type (), GleShell))
#define	GLE_SHELL_CLASS(klass)	(GTK_CHECK_CLASS_CAST ((klass), gle_shell_get_type (), GleShellClass))
#define	GLE_IS_SHELL(object)	(GTK_CHECK_TYPE ((object), gle_shell_get_type ()))


/* --- typedefs --- */
typedef	struct	_GleShell	GleShell;
typedef	struct	_GleShellClass	GleShellClass;


/* --- structures --- */
struct	_GleShell
{
  GtkWindow	window;

  GtkWidget	*customer;
  gint		customer_destroy_handler;

  GtkWidget	*customer_label;
  GtkWidget	*clist;
  GMemChunk	*row_data_mem_chunk;
  gchar		*clist_indent;
  GtkWidget	*update_button;

  GtkWidget	*list_popup;

  GtkWidget	*selector;
};

struct	_GleShellClass
{
  GtkWindowClass	parent_class;
};


/* --- prototypes --- */
GtkType		gle_shell_get_type		(void);
GleShell*	gle_shell_get			(void);
void		gle_shell_set_customer		(GleShell	*shell,
						 GtkWidget	*customer);
void		gle_shell_update_tree		(GleShell	*shell);
void		gle_shell_popup_selector	(GleShell	*shell);
GtkWidget*	gle_shell_get_customer		(GleShell	*shell);





#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */


#endif	/* __GLESHELL_H__ */
