/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include	"config.h"

#include	"gle.h"
#include	"glemem.h"
#include	"gleshell.h"
#include	"gleprivate.h"
#include	<gdk/gdkkeysyms.h>


/* --- global variables --- */
const guint     gle_libversion_major = LIBGLE_MAJOR;
const guint     gle_libversion_revision = LIBGLE_REVISION;
const guint     gle_libversion_age = LIBGLE_AGE;
const gchar     *gle_libversion = LIBGLE_VERSION;


/* --- prototypes --- */
static gint	gle_snooper		(GtkWidget   *grab_widget,
					 GdkEventKey *event,
					 gpointer     func_data);
static gint	gle_quit_handler	(gpointer     data);
extern void	_gle_root_object_setup	(void);
extern void	_gle_root_object_finish	(void);


/* --- static variables --- */
static	guint	snooper_id = 0;
static	guint	quit_id = 0;
static	gchar	*prg_name = NULL;


/* --- functions --- */
void
gle_init (int          *argc_p,
	  char       ***argv_p)
{
  static gboolean initialized = FALSE;
  gint argc;
  gchar buffer[64];
  gchar **argv;

  if (initialized)
    return;
  initialized = TRUE;

  sprintf (buffer, "%u.%u.%u", gtk_major_version, gtk_minor_version, gtk_micro_version);
  if (!g_str_equal (GLE_WORKS_WITH_GTK_VERSION, buffer))
    {
      g_warning ("GLE v%s needs to be rebuild to work with Gtk+ v%d.%d.%d",
		 VERSION,
		 gtk_major_version, gtk_minor_version, gtk_micro_version);
      return;
    }

  if (!argc_p)
    argc = 0;
  else
    argc = *argc_p;

  if (!argv_p)
    argv = NULL;
  else
    argv = *argv_p;

  if (argc < 1 || !argv || !argv[0])
    prg_name = g_strdup ("GLE-Unknown");
  else
    prg_name = g_strdup (argv[0]);

  _gle_mem_chunks_init ();

  _gle_root_object_setup ();

  snooper_id = gtk_key_snooper_install (gle_snooper, NULL);
  quit_id = gtk_quit_add (1, gle_quit_handler, NULL);
}

static gint
gle_quit_handler (gpointer     data)
{
  gle_root_shutdown ();

  return TRUE;
}

const gchar*
gle_prg_name (void)
{
  return prg_name;
}

void
gle_finish (void)
{
  if (!prg_name)
    return;

  gle_root_shutdown ();

  gtk_key_snooper_remove (snooper_id);
  snooper_id = 0;

  gtk_quit_remove (quit_id);
  quit_id = 0;

  _gle_root_object_finish ();

  _gle_mem_chunks_destroy ();

  g_free (prg_name);
  prg_name = NULL;
}

static gint
gle_snooper (GtkWidget   *grab_widget,
	     GdkEventKey *event,
	     gpointer     func_data)
{
  if ((event->state & (GDK_CONTROL_MASK | GDK_MOD1_MASK)) &&
      (event->keyval == '\t' || event->keyval == GDK_Tab))
    {
      if (event->type == GDK_KEY_PRESS)
	{
	  if (gdk_pointer_is_grabbed ())
	    gle_popup_gle_shell_selector ();
	  else
	    {
	      GtkWidget *event_widget;
	      
	      event_widget = gtk_get_event_widget ((GdkEvent*) event);
	      if (event_widget)
		while (event_widget->parent)
		  event_widget = event_widget->parent;
	      
	      gle_popup_gle_shell_customer (event_widget);
	    }
	}
      return TRUE;
    }
  return FALSE;
}
