/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include	"config.h"

#include	"gleselector.h"
#include	"gleprivate.h"



/* --- prototypes --- */
static void		selector_destroy	(GtkWidget	*widget,
						 gpointer	func_data);
static gint		selector_event_grabber	(GtkWidget	*selector,
						 GdkEvent	*event,
						 gpointer	func_data);


/* --- variables --- */
static const gchar	*key_candidate_label = "gle-candidate-label";
static const gchar	*pkey_eventmask = GLE_PRIVATE_KEY (gle-event-mask);
static const gchar	*key_restore_list = "gle-restore-list";
static GtkWidget	*selector = NULL;
static GtkWidget	*candidate = NULL;
static const gchar	*check_tag = NULL;
static gpointer		*check_value = NULL;



/* --- functions --- */
GtkWidget*
gle_selector_setup (const gchar   *window_title)
{
  if (!window_title)
    window_title = "GLE Selector";

  if (!selector)
    {
      GtkWidget *window;
      GtkWidget *main_vbox;
      GtkWidget *label;
      GtkWidget *dummy;
      GtkWidget *button;
      
      window	= gtk_widget_new (gtk_window_get_type (),
				  "GtkWindow::type", GTK_WINDOW_TOPLEVEL,
				  "GtkWindow::window_position", GTK_WIN_POS_CENTER,
				  "GtkObject::signal::delete_event", gtk_true, NULL,
				  "GtkObject::signal::destroy", gtk_widget_destroyed, &selector,
				  "GtkObject::signal::destroy", selector_destroy, NULL,
				  "GtkObject::signal::event", selector_event_grabber, NULL,
				  "GtkWindow::allow_shrink", FALSE,
				  "GtkWindow::allow_grow", FALSE,
				  "GtkWindow::auto_shrink", TRUE,
				  NULL);
      main_vbox	= gtk_widget_new (gtk_vbox_get_type (),
				  "GtkBox::homogeneous", FALSE,
				  "GtkBox::spacing", 5,
				  "GtkContainer::border_width", 10,
				  "GtkWidget::parent", window,
				  "GtkWidget::visible", TRUE,
				  NULL);
      label	= gtk_widget_new (gtk_label_get_type (),
				  "GtkLabel::label", "Select a window by clicking",
				  "GtkWidget::parent", main_vbox,
				  "GtkWidget::visible", TRUE,
				  NULL);
      dummy	= gtk_widget_new (gtk_frame_get_type (),
				  "GtkFrame::shadow", GTK_SHADOW_ETCHED_OUT,
				  "GtkFrame::label_xalign", 0.5,
				  "GtkFrame::label", "Candidate",
				  "GtkWidget::parent", main_vbox,
				  "GtkWidget::visible", TRUE,
				  NULL);
      label	= gtk_widget_new (gtk_label_get_type (),
				  "GtkLabel::label", "<None>",
				  "GtkWidget::sensitive", FALSE,
				  "GtkWidget::parent", dummy,
				  "GtkWidget::visible", TRUE,
				  NULL);
      gtk_object_set_data (GTK_OBJECT (window), key_candidate_label, label);
      gtk_box_set_child_packing (GTK_BOX (main_vbox), label, FALSE, FALSE, 10, GTK_PACK_START);
      dummy	= gtk_widget_new (gtk_hseparator_get_type (),
				  "GtkWidget::parent", main_vbox,
				  "GtkWidget::visible", TRUE,
				  NULL);
      button	= gtk_widget_new (gtk_button_get_type (),
				  "GtkButton::label", "Abort",
				  "GtkContainer::border_width", 5,
				  "GtkObject::object_signal::clicked", gtk_widget_destroy, window,
				  "GtkWidget::can_default", TRUE,
				  "GtkWidget::parent", main_vbox,
				  "GtkWidget::visible", TRUE,
				  "GtkWidget::has_default", TRUE,
				  NULL);
      selector = window;
    }

  gtk_window_set_title (GTK_WINDOW (selector), window_title);

  return selector;
}

GtkWidget*
gle_selector_get_widget (const gchar    *object_tag,
			 gpointer        tag_value)
{
  gpointer anti_pointer;
  GtkWidget *result;

  if (!selector)
    gle_selector_setup (NULL);
  candidate = NULL;

  if (!object_tag)
    {
      check_tag = GLE_PRIVATE_KEY (gle-my-private-selector-key-that-no-one-else-has);
      check_value = NULL;
    }
  else
    {
      check_tag = object_tag;
      check_value = tag_value;
    }

  anti_pointer = (gpointer) (~ ((glong) check_value));
  g_assert (check_value != anti_pointer);
  gtk_object_set_data (GTK_OBJECT (selector), check_tag, anti_pointer);

  gtk_grab_add (selector);
  gtk_widget_show (selector);
  gtk_main ();
  g_assert (!selector);
  result = candidate;
  candidate = NULL;

  return result;
}

static void
selector_destroy (GtkWidget	*selector,
		  gpointer	func_data)
{
  GList *list, *free_list;

  gtk_grab_remove (selector);

  free_list = list = gtk_object_get_data (GTK_OBJECT (selector), key_restore_list);
  while (list)
    {
      GtkWidget *window;
      GdkEventMask *event_mask;

      window = list->data;
      event_mask = gtk_object_get_data (GTK_OBJECT (window), pkey_eventmask);
      if (event_mask)
	{
	  gtk_object_set_data (GTK_OBJECT (window), pkey_eventmask, NULL);
	  gdk_window_set_events (window->window, *event_mask);
	  g_free (event_mask);
	}
      list = list->next;
    }
  g_list_free (free_list);

  gtk_main_quit ();
}

static gboolean
selector_set_window (GtkWidget *toplevel)
{
  GtkLabel *label;
  gchar *string;
  gboolean foreign;
  
  foreign = toplevel && gtk_object_get_data (GTK_OBJECT (toplevel), check_tag) == check_value;
  if (foreign)
    candidate = toplevel;
  else
    candidate = NULL;
  label = gtk_object_get_data (GTK_OBJECT (selector), key_candidate_label);
  if (!toplevel)
    string = "<None>";
  else
    {
      if (GTK_CHECK_TYPE (toplevel, gtk_window_get_type ()))
	{
	  if (GTK_WINDOW (toplevel)->title)
	    string = GTK_WINDOW (toplevel)->title;
	  else
	    string = "<NULL> Title";
	}
      else if (GTK_CHECK_TYPE (toplevel, gtk_menu_get_type ()))
	string = "GtkMenu";
      else
	string = "<Unknown Toplevel>";
    }
  if (!g_str_equal (label->label, string))
    gtk_label_set (label, string);
  gtk_widget_set_sensitive (GTK_WIDGET (label), foreign);
  
  return foreign;
}

static gint
selector_event_grabber (GtkWidget	       *selector,
			GdkEvent	       *event,
			gpointer		func_data)
{
  GtkWidget *event_window;
  
  event_window = gtk_get_event_widget (event);
  g_return_val_if_fail (event_window != NULL, FALSE);
  
  while (event_window->parent)
    event_window = event_window->parent;
  
  
  switch (event->type)
    {
      GdkEventMask *event_mask;
      GdkWindow *pointer_window;
      
    case  GDK_ENTER_NOTIFY:
      if (selector_set_window (event_window))
	{
	  event_mask = gtk_object_get_data (GTK_OBJECT (event_window), pkey_eventmask);
	  if (!event_mask)
	    {
	      GList *list;
	      event_mask = g_new (GdkEventMask, 1);
	      *event_mask = gdk_window_get_events (event_window->window);
	      gtk_object_set_data (GTK_OBJECT (event_window), pkey_eventmask, event_mask);
	      gdk_window_set_events (event_window->window,
				     *event_mask |
				     GDK_BUTTON_RELEASE_MASK |
				     GDK_ENTER_NOTIFY_MASK |
				     GDK_LEAVE_NOTIFY_MASK);
	      list = gtk_object_get_data (GTK_OBJECT (selector), key_restore_list);
	      list = g_list_prepend (list, event_window);
	      gtk_object_set_data (GTK_OBJECT (selector), key_restore_list, list);
	    }
	}
      return TRUE;
      
    case  GDK_LEAVE_NOTIFY:
      pointer_window = gdk_window_get_pointer (event_window->window, NULL, NULL, NULL);
      event_window = NULL;
      if (pointer_window)
	gdk_window_get_user_data (pointer_window, (gpointer*) &event_window);
      if (event_window)
	{
	  while (event_window->parent)
	    event_window = event_window->parent;
	}
      selector_set_window (event_window);
      return TRUE;
      
    case  GDK_BUTTON_RELEASE:
      if (selector_set_window (event_window))
	gtk_widget_destroy (selector);
      return TRUE;
      
    default:
      return FALSE;
    }
}
